/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.internal.util.LatencyDistribution;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationexecutor.OperationRunnerFactory;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerImpl;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.TenantAwareOperationRunnerImpl;
import com.hazelcast.spi.impl.tenantcontrol.impl.TenantControlServiceImpl;
import java.util.concurrent.ConcurrentMap;

class OperationRunnerFactoryImpl
implements OperationRunnerFactory {
    private final ConcurrentMap<Class, LatencyDistribution> opLatencyDistributions;
    private final OperationServiceImpl operationService;
    private final boolean tenantControlEnabled;
    private int genericId;

    OperationRunnerFactoryImpl(OperationServiceImpl operationService) {
        this.operationService = operationService;
        this.opLatencyDistributions = operationService.opLatencyDistributions;
        TenantControlServiceImpl tenantControlService = operationService.nodeEngine.getTenantControlService();
        this.tenantControlEnabled = tenantControlService.isTenantControlEnabled();
    }

    @Override
    public OperationRunner createAdHocRunner() {
        if (this.tenantControlEnabled) {
            return new TenantAwareOperationRunnerImpl(this.operationService, -2, 0, null, this.opLatencyDistributions);
        }
        return new OperationRunnerImpl(this.operationService, -2, 0, null, this.opLatencyDistributions);
    }

    @Override
    public OperationRunner createPartitionRunner(int partitionId) {
        if (this.tenantControlEnabled) {
            return new TenantAwareOperationRunnerImpl(this.operationService, partitionId, 0, this.operationService.failedBackupsCount, this.opLatencyDistributions);
        }
        return new OperationRunnerImpl(this.operationService, partitionId, 0, this.operationService.failedBackupsCount, this.opLatencyDistributions);
    }

    @Override
    public OperationRunner createGenericRunner() {
        if (this.tenantControlEnabled) {
            return new TenantAwareOperationRunnerImpl(this.operationService, -1, this.genericId++, null, this.opLatencyDistributions);
        }
        return new OperationRunnerImpl(this.operationService, -1, this.genericId++, null, this.opLatencyDistributions);
    }
}

