/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.topic.impl.TopicDataSerializerHook;
import java.io.IOException;

class TopicEvent
implements IdentifiedDataSerializable {
    String name;
    long publishTime;
    Address publisherAddress;
    Data data;

    TopicEvent() {
    }

    TopicEvent(String name, Data data, Address publisherAddress) {
        this.name = name;
        this.publishTime = Clock.currentTimeMillis();
        this.publisherAddress = publisherAddress;
        this.data = data;
    }

    @Override
    public int getFactoryId() {
        return TopicDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeLong(this.publishTime);
        out.writeObject(this.publisherAddress);
        IOUtil.writeData(out, this.data);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.publishTime = in.readLong();
        this.publisherAddress = (Address)in.readObject();
        this.data = IOUtil.readData(in);
    }

    public String toString() {
        return "TopicEvent{name='" + this.name + "', publishTime=" + this.publishTime + ", publisherAddress=" + this.publisherAddress + "}";
    }
}

