/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.vector.SearchOptions;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class SearchOptionsImpl
implements SearchOptions,
IdentifiedDataSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean includeValue;
    private boolean includeVectors;
    private int limit;
    private Map<String, String> hints = Map.of();

    public SearchOptionsImpl() {
    }

    public SearchOptionsImpl(boolean includeValue, boolean includeVectors, int limit, Map<String, String> hints) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        this.includeValue = includeValue;
        this.includeVectors = includeVectors;
        this.limit = limit;
        this.hints = hints != null ? hints : Map.of();
    }

    @Override
    public boolean isIncludeValue() {
        return this.includeValue;
    }

    @Override
    public boolean isIncludeVectors() {
        return this.includeVectors;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public Map<String, String> getHints() {
        return Collections.unmodifiableMap(this.hints);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.includeValue);
        out.writeBoolean(this.includeVectors);
        out.writeInt(this.limit);
        SerializationUtil.writeMapStringKey(this.hints, out, ObjectDataOutput::writeString);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.includeValue = in.readBoolean();
        this.includeVectors = in.readBoolean();
        this.limit = in.readInt();
        this.hints = SerializationUtil.readMapStringKey(in, ObjectDataInput::readString);
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchOptionsImpl that = (SearchOptionsImpl)o;
        return this.includeValue == that.includeValue && this.includeVectors == that.includeVectors && this.limit == that.limit;
    }

    public int hashCode() {
        return Objects.hash(this.includeValue, this.includeVectors, this.limit);
    }

    public String toString() {
        return "SearchOptionsImpl{limit=" + this.limit + ", includeValue=" + this.includeValue + ", includeVectors=" + this.includeVectors + ", hints=" + this.hints + "}";
    }
}

