/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.StandardMBean;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayStatisticsMXBean;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;
import oracle.jdbc.replay.driver.StatisticsTracker;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public class ReplayStatisticsMBeanImpl
extends StandardMBean
implements ReplayStatisticsMXBean {
    public static final ReplayStatisticsMBeanImpl SOLE_INSTANCE = new ReplayStatisticsMBeanImpl();
    private static final Set<StatisticsTracker> trackerSet = Collections.synchronizedSet(new HashSet());
    private static ReplayStatisticsImpl STATS_ON_CLOSED_DS = new ReplayStatisticsImpl();

    private ReplayStatisticsMBeanImpl() {
        super(ReplayStatisticsMXBean.class, true);
    }

    public void addTrackerForDS(StatisticsTracker statisticsTracker) {
        trackerSet.add(statisticsTracker);
    }

    public void removeTrackerForDS(StatisticsTracker statisticsTracker) {
        trackerSet.remove(statisticsTracker);
        STATS_ON_CLOSED_DS.aggregate(statisticsTracker.getReplayStatistics());
    }

    @Override
    public String allStatistics() {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        int[] nArray = new int[31];
        for (StatisticsTracker statisticsTracker : trackerSet) {
            ReplayStatistics replayStatistics = statisticsTracker.getReplayStatistics();
            l2 += replayStatistics.getTotalRequests();
            l3 += replayStatistics.getTotalCompletedRequests();
            l4 += replayStatistics.getTotalCalls();
            l5 += replayStatistics.getTotalProtectedCalls();
            l6 += replayStatistics.getTotalCallsAffectedByOutages();
            l7 += replayStatistics.getTotalCallsTriggeringReplay();
            l8 += replayStatistics.getTotalCallsAffectedByOutagesDuringReplay();
            l9 += replayStatistics.getSuccessfulReplayCount();
            l10 += replayStatistics.getFailedReplayCount();
            l11 += replayStatistics.getReplayDisablingCount();
            l12 += replayStatistics.getTotalReplayAttempts();
            int[] nArray2 = replayStatistics.getRequestSizeHistogram();
            if (nArray2 == null || nArray2.length <= 0) continue;
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n2 = i2;
                nArray[n2] = nArray[n2] + nArray2[i2];
            }
        }
        ReplayStatisticsImpl replayStatisticsImpl = new ReplayStatisticsImpl(l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, 0);
        replayStatisticsImpl.setRequestSizeHistogram(nArray);
        replayStatisticsImpl.aggregate(STATS_ON_CLOSED_DS);
        return replayStatisticsImpl.toString();
    }

    @Override
    public String getStatisticsForDataSource(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (StatisticsTracker statisticsTracker : trackerSet) {
            String string2 = statisticsTracker.getDataSourceName();
            if (string == null || !string.equals(string2)) continue;
            if (!bl) {
                stringBuffer.append(statisticsTracker.getReplayStatistics().toString());
                bl = true;
                continue;
            }
            stringBuffer.append("\n\nWARNING: there are data sources with duplicate names and replay statistics is only reported for one of them. Check names and try again.");
            break;
        }
        if (!bl) {
            stringBuffer.append("WARNING: replay statistics not available for this data source name. Check name and try again.");
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getDescription(MBeanInfo mBeanInfo) {
        return DatabaseError.findMessage("ReplayStatisticsMBeanDescription", (Object)this);
    }

    @Override
    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return DatabaseError.findMessage("ReplayStatisticsMBeanConstructor", (Object)this);
    }

    @Override
    protected String getDescription(MBeanOperationInfo mBeanOperationInfo) {
        String string = mBeanOperationInfo.getName();
        if (string.equals("allStatistics")) {
            return DatabaseError.findMessage("ReplayStatisticsMBeanAllStatisticsDescription", (Object)this);
        }
        if (string.equals("getStatisticsForDataSource")) {
            return DatabaseError.findMessage("ReplayStatisticsMBeanGetDSStatisticsDescription", (Object)this);
        }
        Logger.getLogger("oracle.jdbc.internal.replay").log(Level.SEVERE, "Got a request to describe an unexpected operation: " + string);
        return super.getDescription(mBeanOperationInfo);
    }
}

