/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.AssociativeArrayEntry;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.COLLECTION_METADATA})
public class ArrayDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Array,
Serializable {
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_ALL = 1;
    public static final int CACHE_LAST = 2;
    static final long serialVersionUID = 3838105394346513809L;

    public static ArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        return ArrayDescriptor.createDescriptor(string, connection, false, false);
    }

    public static ArrayDescriptor createDescriptor(String string, Connection connection, boolean bl, boolean bl2) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            throw (SQLException)DatabaseError.createSqlException(60, "ArrayDescriptor.createDescriptor: Invalid argument, 'name' should not be an empty string and 'conn' should not be null.").fillInStackTrace();
        }
        connection = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)connection);
        SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
        String string2 = sQLName.getName();
        ArrayDescriptor arrayDescriptor = null;
        if (!bl2) {
            arrayDescriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string2);
        }
        if (arrayDescriptor == null) {
            short s2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getVersionNumber();
            arrayDescriptor = s2 >= 12000 ? new ArrayDescriptor(string, connection) : new ArrayDescriptor(sQLName, connection);
            if (bl) {
                arrayDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string2, arrayDescriptor);
        }
        return arrayDescriptor;
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        return ArrayDescriptor.createDescriptor(sQLName, connection, false, false);
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl, boolean bl2) throws SQLException {
        connection = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)connection);
        String string = sQLName.getName();
        ArrayDescriptor arrayDescriptor = null;
        if (!bl2) {
            arrayDescriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string);
        }
        if (arrayDescriptor == null) {
            arrayDescriptor = new ArrayDescriptor(sQLName, connection);
            if (bl) {
                arrayDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, arrayDescriptor);
        }
        return arrayDescriptor;
    }

    public static ArrayDescriptor createDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION) throws SQLException {
        String string = oracleTypeCOLLECTION.getFullName();
        oracle.jdbc.OracleConnection oracleConnection = oracleTypeCOLLECTION.getConnection();
        ArrayDescriptor arrayDescriptor = (ArrayDescriptor)(oracleConnection = ConcreteProxyUtil.unwrapConnectionProxy(oracleConnection)).getDescriptor(string);
        if (arrayDescriptor == null) {
            SQLName sQLName = new SQLName(oracleTypeCOLLECTION.getSchemaName(), oracleTypeCOLLECTION.getSimpleName(), oracleTypeCOLLECTION.getConnection());
            arrayDescriptor = new ArrayDescriptor(sQLName, oracleTypeCOLLECTION, (Connection)oracleConnection);
            oracleConnection.putDescriptor(string, arrayDescriptor);
        }
        return arrayDescriptor;
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        OracleTypeADT oracleTypeADT = new OracleTypeADT(sQLName, byArray, n2, byArray2, oracleConnection);
        oracleTypeADT.init(byArray2, oracleConnection);
        OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
        return new ArrayDescriptor(sQLName, oracleTypeCOLLECTION, (Connection)oracleConnection);
    }

    public ArrayDescriptor(String string, Connection connection) throws SQLException {
        super((short)122, string, connection);
        this.initPickler();
    }

    public ArrayDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super((short)122, sQLName, connection);
        this.initPickler();
    }

    public ArrayDescriptor(SQLName sQLName, OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super((short)122, sQLName, oracleTypeCOLLECTION, connection);
    }

    public ArrayDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super((short)122, oracleTypeCOLLECTION, connection);
    }

    ArrayDescriptor(byte[] byArray, int n2, Connection connection) throws SQLException {
        super((short)122);
        this.toid = byArray;
        this.toidVersion = n2;
        this.setPhysicalConnectionOf(connection);
        this.initPickler();
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        return OracleTypeMetaData.Kind.ARRAY;
    }

    @Override
    public int getBaseType() throws SQLException {
        return ((OracleTypeCOLLECTION)this.pickler).getElementType().getTypeCode();
    }

    @Override
    public String getBaseName() throws SQLException {
        Object object = null;
        switch (this.getBaseType()) {
            case 12: {
                object = "VARCHAR";
                break;
            }
            case 1: {
                object = "CHAR";
                break;
            }
            case -9: {
                object = "NVARCHAR";
                break;
            }
            case -15: {
                object = "NCHAR";
                break;
            }
            case -2: {
                object = "RAW";
                break;
            }
            case 6: {
                object = "FLOAT";
                break;
            }
            case 2: {
                object = "NUMBER";
                break;
            }
            case 8: {
                object = "DOUBLE";
                break;
            }
            case 3: {
                object = "DECIMAL";
                break;
            }
            case 91: {
                object = "DATE";
                break;
            }
            case 93: {
                object = "TIMESTAMP";
                break;
            }
            case -101: {
                object = "TIMESTAMP WITH TIME ZONE";
                break;
            }
            case -102: {
                object = "TIMESTAMP WITH LOCAL TIME ZONE";
                break;
            }
            case 2004: {
                object = "BLOB";
                break;
            }
            case 2005: {
                object = "CLOB";
                break;
            }
            case 2011: {
                object = "NCLOB";
                break;
            }
            case -13: {
                object = "BFILE";
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                object = oracleNamedType.getFullName();
                break;
            }
            case 2006: {
                OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                object = "REF " + ((OracleTypeREF)oracleNamedType).getFullName();
                break;
            }
            case 100: {
                object = "BINARY_FLOAT";
                break;
            }
            case 101: {
                object = "BINARY_DOUBLE";
                break;
            }
            case -104: {
                object = "INTERVALDS";
                break;
            }
            case -103: {
                object = "INTERVALYM";
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        return (OracleTypeCOLLECTION)this.pickler;
    }

    @Override
    public OracleTypeMetaData.ArrayStorage getArrayStorage() throws SQLException {
        return OracleTypeMetaData.ArrayStorage.withCode(this.getArrayType());
    }

    public int getArrayType() throws SQLException {
        return ((OracleTypeCOLLECTION)this.pickler).getUserCode();
    }

    @Override
    public long getMaxLength() throws SQLException {
        return this.getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.pickler).getMaxLength() : 0L;
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        Object object = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            object = (String)object + "  ";
        }
        String string = (String)object + "  ";
        stringBuffer.append((String)object);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        int n3 = this.getBaseType();
        if (n3 == 2002 || n3 == 2008) {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            structDescriptor.descType(stringBuffer, n2 + 1);
        } else if (n3 == 2003) {
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            arrayDescriptor.descType(stringBuffer, n2 + 1);
        } else if (n3 == 2007) {
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            opaqueDescriptor.descType(stringBuffer, n2 + 1);
        } else {
            stringBuffer.append(string);
            stringBuffer.append(this.getBaseName());
            stringBuffer.append("\n");
        }
        return stringBuffer.substring(0, stringBuffer.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int toLength(OracleArray oracleArray, Datum datum) throws SQLException {
        if (oracleArray.getNumElems() != -1) return oracleArray.getNumElems();
        if (oracleArray.getDatumArray() != null) {
            oracleArray.setLength(oracleArray.getDatumArray().length);
            return oracleArray.getNumElems();
        } else if (oracleArray.getObjArray() != null) {
            Object object = oracleArray.getObjArray();
            int n2 = oracleArray.getNumElems();
            if (object instanceof Object[]) {
                n2 = ((Object[])object).length;
            } else if (object instanceof int[]) {
                n2 = ((long[])object).length;
            } else if (object instanceof long[]) {
                n2 = ((float[])object).length;
            } else if (object instanceof float[]) {
                n2 = ((double[])object).length;
            } else if (object instanceof double[]) {
                n2 = ((boolean[])object).length;
            } else if (object instanceof boolean[]) {
                n2 = ((int[])object).length;
            } else if (object instanceof byte[]) {
                n2 = ((byte[])object).length;
            } else if (object instanceof short[]) {
                n2 = ((short[])object).length;
            } else if (object instanceof char[]) {
                n2 = ((char[])object).length;
            }
            oracleArray.setLength(n2);
            return oracleArray.getNumElems();
        } else if (oracleArray.getLocator() != null) {
            oracleArray.setLength(this.toLengthFromLocator(oracleArray.getLocator()));
            return oracleArray.getNumElems();
        } else {
            if (oracleArray.shareBytes() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
            this.pickler.unlinearize(oracleArray.shareBytes(), oracleArray.getImageOffset(), datum, 0, null);
            if (oracleArray.getNumElems() != -1) return oracleArray.getNumElems();
            if (oracleArray.getLocator() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to get array length").fillInStackTrace();
            oracleArray.setLength(this.toLengthFromLocator(oracleArray.getLocator()));
        }
        return oracleArray.getNumElems();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toBytes(OracleArray oracleArray, Datum datum, boolean bl) throws SQLException {
        byte[] byArray = oracleArray.shareBytes();
        if (byArray == null) {
            if (oracleArray.getDatumArray() != null || oracleArray.getLocator() != null) {
                byArray = this.pickler.linearize(datum);
                if (bl) return byArray;
                oracleArray.setShareBytes(null);
                return byArray;
            } else {
                if (oracleArray.getObjArray() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                oracleArray.setDatumArray(this.toOracleArray(oracleArray.getObjArray(), 1L, -1));
                byArray = this.pickler.linearize(datum);
                if (bl) return byArray;
                oracleArray.setDatumArray(null);
                oracleArray.setShareBytes(null);
            }
            return byArray;
        } else {
            if (oracleArray.getImageLength() == 0L) return byArray;
            long l2 = oracleArray.getImageLength();
            if (oracleArray.getImageOffset() == 0L && l2 == (long)byArray.length) return byArray;
            byte[] byArray2 = new byte[(int)l2];
            System.arraycopy(byArray, (int)oracleArray.getImageOffset(), byArray2, 0, (int)l2);
            oracleArray.setImage(byArray2, 0L, 0L);
            return byArray2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Datum[] toOracleArray(OracleArray oracleArray, Datum datum, long l2, int n2, boolean bl) throws SQLException {
        Datum[] datumArray = oracleArray.getDatumArray();
        if (datumArray == null) {
            if (oracleArray.getObjArray() != null) {
                datumArray = this.toOracleArray(oracleArray.getObjArray(), l2, n2);
            } else if (oracleArray.getLocator() != null) {
                datumArray = this.toOracleArrayFromLocator(oracleArray.getLocator(), l2, n2, null);
            } else {
                if (oracleArray.shareBytes() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status.").fillInStackTrace();
                this.pickler.unlinearize(oracleArray.shareBytes(), oracleArray.getImageOffset(), datum, l2, n2, 1, null);
                datumArray = oracleArray.getLocator() != null ? this.toOracleArrayFromLocator(oracleArray.getLocator(), l2, n2, null) : oracleArray.getDatumArray();
                if (!bl) {
                    oracleArray.setDatumArray(null);
                }
            }
        } else {
            if (l2 > (long)datumArray.length) {
                return new Datum[0];
            }
            int n3 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
            datumArray = new Datum[n3];
            System.arraycopy(oracleArray.getDatumArray(), (int)l2 - 1, datumArray, 0, n3);
        }
        Datum[] datumArray2 = null;
        if (!bl) return datumArray;
        oracleArray.setDatumArray(datumArray);
        return (Datum[])datumArray.clone();
    }

    public Object[] toJavaArray(OracleArray oracleArray, Datum datum, long l2, int n2, Map map, boolean bl) throws SQLException {
        Object[] objectArray = null;
        if (oracleArray.getObjArray() != null) {
            objectArray = (Object[])((Object[])oracleArray.getObjArray()).clone();
            int n3 = objectArray.length;
            int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
            if (n4 <= 0) {
                Object[] objectArray2 = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
                return objectArray2;
            }
            objectArray = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
            System.arraycopy(oracleArray.getObjArray(), (int)l2 - 1, objectArray, 0, n4);
        } else {
            if (oracleArray.getDatumArray() != null) {
                objectArray = (Object[])this.toJavaArray(oracleArray, l2, n2, map);
            } else if (oracleArray.getLocator() != null) {
                objectArray = this.toArrayFromLocator(oracleArray.getLocator(), l2, n2, map);
            } else if (oracleArray.shareBytes() != null) {
                this.pickler.unlinearize(oracleArray.shareBytes(), oracleArray.getImageOffset(), datum, l2, n2, 2, map);
                objectArray = oracleArray.getLocator() != null ? this.toArrayFromLocator(oracleArray.getLocator(), l2, n2, map) : (Object[])oracleArray.getObjArray();
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
            }
            if (bl && this.getBaseType() != 2002 && this.getBaseType() != 2008 && objectArray != null) {
                oracleArray.setObjArray(objectArray.clone());
            } else {
                oracleArray.setNullObjArray();
            }
        }
        return objectArray;
    }

    private Datum[] toOracleArrayFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        int n3 = this.toLengthFromLocator(byArray);
        int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
        Datum[] datumArray = null;
        if (n4 <= 0) {
            datumArray = new Datum[]{};
        } else {
            datumArray = new Datum[n4];
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, map);
            int n5 = 0;
            while (resultSet.next()) {
                datumArray[n5] = ((OracleResultSet)resultSet).getOracleObject(2);
                ++n5;
            }
            resultSet.close();
        }
        return datumArray;
    }

    private Object[] toArrayFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        int n3 = this.toLengthFromLocator(byArray);
        int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
        Object[] objectArray = null;
        if (n4 <= 0) {
            objectArray = ArrayDescriptor.makeJavaArray(0, this.getBaseType());
        } else {
            objectArray = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, map);
            int n5 = 0;
            while (resultSet.next()) {
                objectArray[n5] = ((OracleResultSet)resultSet).getObject(2, map);
                ++n5;
            }
            resultSet.close();
        }
        return objectArray;
    }

    public ResultSet toResultSet(ARRAY aRRAY, long l2, int n2, Map map, boolean bl) throws SQLException {
        return this.toResultSet(aRRAY, aRRAY, l2, n2, map, bl);
    }

    public ResultSet toResultSet(OracleArray oracleArray, Datum datum, long l2, int n2, Map map, boolean bl) throws SQLException {
        ResultSet resultSet = null;
        if (oracleArray.getDatumArray() != null) {
            resultSet = this.toResultSet(oracleArray.getDatumArray(), l2, n2, map);
        } else if (oracleArray.getLocator() != null) {
            resultSet = this.toResultSetFromLocator(oracleArray.getLocator(), l2, n2, map);
        } else if (oracleArray.getObjArray() != null) {
            resultSet = this.toResultSet(this.toOracleArray(oracleArray.getObjArray(), l2, n2), 1L, -1, map);
        } else if (oracleArray.shareBytes() != null) {
            if (((OracleTypeCOLLECTION)this.pickler).isInlineImage(oracleArray.shareBytes(), (int)oracleArray.getImageOffset())) {
                resultSet = this.toResultSetFromImage(oracleArray, l2, n2, map);
            } else {
                this.pickler.unlinearize(oracleArray.shareBytes(), oracleArray.getImageOffset(), datum, 1, null);
                if (oracleArray.getLocator() != null) {
                    resultSet = this.toResultSetFromLocator(oracleArray.getLocator(), l2, n2, map);
                } else {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                }
            }
        }
        if (resultSet == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to create array ResultSet").fillInStackTrace();
        }
        return resultSet;
    }

    public ResultSet toResultSet(Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        ResultSet resultSet = null;
        resultSet = n2 == -1 ? this.connection.newArrayDataResultSet(datumArray, l2, datumArray.length, map) : this.connection.newArrayDataResultSet(datumArray, l2, n2, map);
        return resultSet;
    }

    public ResultSet toResultSetFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        ResultSet resultSet = this.connection.newArrayLocatorResultSet(this, byArray, l2, n2, map);
        return resultSet;
    }

    public ResultSet toResultSetFromImage(OracleArray oracleArray, long l2, int n2, Map map) throws SQLException {
        ResultSet resultSet = this.connection.newArrayDataResultSet(oracleArray, l2, n2, map);
        return resultSet;
    }

    public static Object[] makeJavaArray(int n2, int n3) throws SQLException {
        Object[] objectArray = null;
        switch (n3) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = new BigDecimal[n2];
                break;
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                objectArray = new String[n2];
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = new Timestamp[n2];
                break;
            }
            case -102: 
            case -101: {
                objectArray = new OffsetDateTime[n2];
                break;
            }
            case 2002: 
            case 2008: {
                objectArray = new Object[n2];
                break;
            }
            case -13: {
                objectArray = new BFILE[n2];
                break;
            }
            case 2004: {
                objectArray = new BLOB[n2];
                break;
            }
            case 2005: 
            case 2011: {
                objectArray = new CLOB[n2];
                break;
            }
            case -3: 
            case -2: {
                objectArray = (Object[])new byte[n2][];
                break;
            }
            case 2006: {
                objectArray = new REF[n2];
                break;
            }
            case 2003: {
                objectArray = new Object[n2];
                break;
            }
            case 2007: {
                objectArray = new Object[n2];
                break;
            }
            case 100: {
                objectArray = new Float[n2];
                break;
            }
            case 101: {
                objectArray = new Double[n2];
                break;
            }
            case -104: {
                objectArray = new INTERVALDS[n2];
                break;
            }
            case -103: {
                objectArray = new INTERVALYM[n2];
                break;
            }
            case -8: {
                objectArray = new ROWID[n2];
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(1, "makeJavaArray doesn't support type " + n3).fillInStackTrace();
            }
        }
        return objectArray;
    }

    private int toLengthFromLocator(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.connection, (Object)null);
        aRRAY.setLocator(byArray);
        int n2 = 0;
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        oraclePreparedStatement = (OraclePreparedStatement)this.connection.prepareStatement("SELECT count(*) FROM TABLE( CAST(:1 AS " + this.getName() + ") )");
        oraclePreparedStatement.setArray(1, aRRAY);
        oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
        if (!oracleResultSet.next()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Fail to access array storage table").fillInStackTrace();
        }
        n2 = oracleResultSet.getInt(1);
        oracleResultSet.close();
        oraclePreparedStatement.close();
        return n2;
    }

    public Datum[] toOracleArray(Object object, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            OracleType oracleType = this.getElementType();
            if (this.getArrayType() == 1) {
                if (object.getClass().isArray()) {
                    int n3 = Array.getLength(object);
                    Datum[] datumArray2 = new Datum[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        Object object2 = Array.get(object, i2);
                        Datum datum = oracleType.toDatum(object2, this.connection);
                        datumArray2[i2] = new AssociativeArrayEntry<Integer, Datum>(i2, datum);
                    }
                    datumArray = datumArray2;
                } else if (object instanceof Map) {
                    Map map = (Map)object;
                    Datum[] datumArray3 = new Datum[map.size()];
                    int n4 = 0;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof Integer)) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "SQL Associative Array Index Type").fillInStackTrace();
                        }
                        Datum datum = oracleType.toDatum(entry.getValue(), this.connection);
                        datumArray3[n4] = new AssociativeArrayEntry<Integer, Datum>((Integer)entry.getKey(), datum);
                        ++n4;
                    }
                    datumArray = datumArray3;
                }
            } else {
                datumArray = oracleType.toDatumArray(object, this.connection, l2, n2);
            }
        }
        return datumArray;
    }

    private Object toJavaArray(OracleArray oracleArray, long l2, int n2, Map map) throws SQLException {
        HashMap<Integer, Object> hashMap = null;
        if (this.getArrayType() == 1) {
            hashMap = new HashMap<Integer, Object>();
        }
        Datum[] datumArray = oracleArray.getDatumArray();
        int n3 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
        if (n3 < 0) {
            n3 = 0;
        }
        Object[] objectArray = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
        for (int i2 = 0; i2 < n3; ++i2) {
            Integer n4 = null;
            Datum datum = datumArray[(int)l2 + i2 - 1];
            if (datum instanceof AssociativeArrayEntry) {
                n4 = (Integer)((AssociativeArrayEntry)datum).getKey();
                datum = (Datum)((AssociativeArrayEntry)datum).getValue();
            }
            if (this.getBaseType() == 2002) {
                objectArray[i2] = datum != null ? ((STRUCT)datum).toJdbc(map) : null;
            } else if (this.getBaseType() == -101) {
                objectArray[i2] = datum != null ? ((TIMESTAMPTZ)datum).offsetDateTimeValue(oracleArray.getJavaSqlConnection()) : null;
            } else if (this.getBaseType() == -102) {
                objectArray[i2] = datum != null ? ((TIMESTAMPLTZ)datum).offsetDateTimeValue(oracleArray.getJavaSqlConnection()) : null;
            } else {
                Object object = objectArray[i2] = datum != null ? datum.toJdbc() : null;
            }
            if (hashMap == null) continue;
            hashMap.put(n4, objectArray[i2]);
        }
        oracleArray.setJavaMap(hashMap);
        return objectArray;
    }

    private Object toNumericArray(Datum[] datumArray, long l2, int n2, int n3) throws SQLException {
        Object[] objectArray = null;
        int n4 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
        if (n4 < 0) {
            n4 = 0;
        }
        switch (n3) {
            case 4: {
                int[] nArray = new int[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    Datum datum = datumArray[(int)l2 + i2 - 1];
                    if (datum == null) continue;
                    nArray[i2] = datum.intValue();
                }
                objectArray = nArray;
                break;
            }
            case 5: {
                double[] dArray = new double[n4];
                for (int i3 = 0; i3 < n4; ++i3) {
                    Datum datum = datumArray[(int)l2 + i3 - 1];
                    if (datum == null) continue;
                    dArray[i3] = datum.doubleValue();
                }
                objectArray = dArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    Datum datum = datumArray[(int)l2 + i4 - 1];
                    if (datum == null) continue;
                    fArray[i4] = datum.floatValue();
                }
                objectArray = fArray;
                break;
            }
            case 7: {
                long[] lArray = new long[n4];
                for (int i5 = 0; i5 < n4; ++i5) {
                    Datum datum = datumArray[(int)l2 + i5 - 1];
                    if (datum == null) continue;
                    lArray[i5] = datum.longValue();
                }
                objectArray = lArray;
                break;
            }
            case 8: {
                short[] sArray = new short[n4];
                for (int i6 = 0; i6 < n4; ++i6) {
                    Datum datum = datumArray[(int)l2 + i6 - 1];
                    if (datum == null) continue;
                    sArray[i6] = ((NUMBER)datum).shortValue();
                }
                objectArray = sArray;
                break;
            }
            default: {
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLFeatureNotSupportedException.fillInStackTrace();
                throw sQLFeatureNotSupportedException;
            }
        }
        return objectArray;
    }

    private Object toNumericArrayFromLocator(byte[] byArray, long l2, int n2, int n3) throws SQLException {
        Object[] objectArray = null;
        int n4 = this.toLengthFromLocator(byArray);
        ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, null);
        int n5 = 0;
        switch (n3) {
            case 4: {
                int[] nArray = new int[n4];
                while (resultSet.next() && n5 < n4) {
                    nArray[n5++] = ((OracleResultSet)resultSet).getInt(2);
                }
                resultSet.close();
                objectArray = nArray;
                break;
            }
            case 5: {
                double[] dArray = new double[n4];
                while (resultSet.next() && n5 < n4) {
                    dArray[n5++] = ((OracleResultSet)resultSet).getDouble(2);
                }
                resultSet.close();
                objectArray = dArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n4];
                while (resultSet.next() && n5 < n4) {
                    fArray[n5++] = ((OracleResultSet)resultSet).getFloat(2);
                }
                resultSet.close();
                objectArray = fArray;
                break;
            }
            case 7: {
                long[] lArray = new long[n4];
                while (resultSet.next() && n5 < n4) {
                    lArray[n5++] = ((OracleResultSet)resultSet).getLong(2);
                }
                resultSet.close();
                objectArray = lArray;
                break;
            }
            case 8: {
                short[] sArray = new short[n4];
                while (resultSet.next() && n5 < n4) {
                    sArray[n5++] = ((OracleResultSet)resultSet).getShort(2);
                }
                resultSet.close();
                objectArray = sArray;
                break;
            }
            default: {
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLFeatureNotSupportedException.fillInStackTrace();
                throw sQLFeatureNotSupportedException;
            }
        }
        return objectArray;
    }

    public Object toNumericArray(OracleArray oracleArray, Datum datum, long l2, int n2, int n3, boolean bl) throws SQLException {
        OracleType oracleType = this.getElementType();
        if (!(oracleType instanceof OracleTypeNUMBER) && !(oracleType instanceof OracleTypeFLOAT)) {
            SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
            sQLFeatureNotSupportedException.fillInStackTrace();
            throw sQLFeatureNotSupportedException;
        }
        Object object = null;
        if (oracleArray.getObjArray() != null) {
            Object object2 = oracleArray.getObjArray();
            if (n3 == 4 && object2 instanceof int[]) {
                int n4 = ((int[])object2).length;
                if (l2 > (long)n4) {
                    return new int[0];
                }
                n4 = (int)(n2 == -1 ? (long)n4 - l2 + 1L : Math.min((long)n4 - l2 + 1L, (long)n2));
                int[] nArray = new int[n4];
                System.arraycopy(object2, (int)l2 - 1, nArray, 0, n4);
                object = nArray;
            } else if (n3 == 5 && object2 instanceof double[]) {
                int n5 = ((double[])object2).length;
                if (l2 > (long)n5) {
                    return new double[0];
                }
                n5 = (int)(n2 == -1 ? (long)n5 - l2 + 1L : Math.min((long)n5 - l2 + 1L, (long)n2));
                double[] dArray = new double[n5];
                System.arraycopy(object2, (int)l2 - 1, dArray, 0, n5);
                object = dArray;
            } else if (n3 == 6 && object2 instanceof float[]) {
                int n6 = ((float[])object2).length;
                if (l2 > (long)n6) {
                    return new float[0];
                }
                n6 = (int)(n2 == -1 ? (long)n6 - l2 + 1L : Math.min((long)n6 - l2 + 1L, (long)n2));
                float[] fArray = new float[n6];
                System.arraycopy(object2, (int)l2 - 1, fArray, 0, n6);
                object = fArray;
            } else if (n3 == 7 && object2 instanceof long[]) {
                int n7 = ((long[])object2).length;
                if (l2 > (long)n7) {
                    return new long[0];
                }
                n7 = (int)(n2 == -1 ? (long)n7 - l2 + 1L : Math.min((long)n7 - l2 + 1L, (long)n2));
                long[] lArray = new long[n7];
                System.arraycopy(object2, (int)l2 - 1, lArray, 0, n7);
                object = lArray;
            } else if (n3 == 8 && object2 instanceof short[]) {
                int n8 = ((short[])object2).length;
                if (l2 > (long)n8) {
                    return new short[0];
                }
                n8 = (int)(n2 == -1 ? (long)n8 - l2 + 1L : Math.min((long)n8 - l2 + 1L, (long)n2));
                short[] sArray = new short[n8];
                System.arraycopy(object2, (int)l2 - 1, sArray, 0, n8);
                object = sArray;
            }
        } else {
            if (oracleArray.getDatumArray() != null) {
                object = this.toNumericArray(oracleArray.getDatumArray(), l2, n2, n3);
            } else if (oracleArray.getLocator() != null) {
                object = this.toNumericArrayFromLocator(oracleArray.getLocator(), l2, n2, n3);
            } else if (oracleArray.shareBytes() != null) {
                this.pickler.unlinearize(oracleArray.shareBytes(), oracleArray.getImageOffset(), datum, l2, n2, n3, null);
                object = oracleArray.getLocator() != null ? this.toNumericArrayFromLocator(oracleArray.getLocator(), l2, n2, n3) : oracleArray.getObjArray();
            } else {
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLFeatureNotSupportedException.fillInStackTrace();
                throw sQLFeatureNotSupportedException;
            }
            if (!bl) {
                oracleArray.setNullObjArray();
            }
        }
        return object;
    }

    private void initPickler() throws SQLException {
        try {
            String string = this.typeNameByUser;
            if (string == null) {
                string = this.getName();
            }
            OracleTypeADT oracleTypeADT = new OracleTypeADT(string, (Connection)this.connection);
            oracleTypeADT.init(this.connection);
            this.pickler = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
            this.toid = ((OracleTypeADT)this.pickler).getTOID();
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type: \"" + this.getName() + "\"").fillInStackTrace();
        }
    }

    private OracleType getElementType() throws SQLException {
        OracleType oracleType = ((OracleTypeCOLLECTION)this.pickler).getElementType();
        return oracleType;
    }

    @Override
    public int getTypeCode() throws SQLException {
        int n2 = 2003;
        return n2;
    }

    public SQLInput toJdbcToSQLInput(ARRAY aRRAY, Map map) throws SQLException {
        return new OracleJdbc2SQLInput(this.toOracleArray(aRRAY, aRRAY, 0L, aRRAY.length(), false), map, this.connection);
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.connection, datumArray);
        return this.pickler.linearize(aRRAY);
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toArray(objectArray);
        byte[] byArray = this.toBytes(datumArray);
        return byArray;
    }

    public int length(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.connection, byArray);
        int n2 = this.toLength(aRRAY, aRRAY);
        return n2;
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        Datum[] datumArray = null;
        if (byArray != null) {
            ARRAY aRRAY = new ARRAY(this, this.connection, byArray);
            datumArray = this.toOracleArray(aRRAY, aRRAY, 1L, -1, false);
        }
        return datumArray;
    }

    public Datum[] toArray(Object object) throws SQLException {
        Datum[] datumArray = this.toOracleArray(object, 1L, -1);
        return datumArray;
    }

    public ResultSet toResultSet(byte[] byArray, Map map) throws SQLException {
        ResultSet resultSet = null;
        if (byArray != null) {
            ARRAY aRRAY = (ARRAY)this.pickler.unlinearize(byArray, 0L, null, 1, null);
            resultSet = this.toResultSet(aRRAY, aRRAY, 1L, -1, map, false);
        }
        return resultSet;
    }

    public ResultSet toResultSet(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        ResultSet resultSet = null;
        if (byArray != null) {
            ARRAY aRRAY = (ARRAY)this.pickler.unlinearize(byArray, 0L, null, 1, null);
            resultSet = this.toResultSet(aRRAY, aRRAY, l2, n2, map, false);
        }
        return resultSet;
    }

    @Override
    String tagName() {
        return "ArrayDescriptor";
    }

    public static int getCacheStyle(OracleArray oracleArray) throws SQLException {
        int n2 = 2;
        if (oracleArray.getAutoIndexing() && (oracleArray.getAccessDirection() == 2 || oracleArray.getAccessDirection() == 3)) {
            n2 = 1;
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

