/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.app;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.wicket.authentication.strategy.DefaultAuthenticationStrategy;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.crypt.SunJceCrypt;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmAuthenticationStrategy
extends DefaultAuthenticationStrategy {
    private static final Logger log = LoggerFactory.getLogger(OmAuthenticationStrategy.class);
    private static final String COOKIE_KEY = "LoggedIn";

    public OmAuthenticationStrategy(String encryptionKey, String salt) {
        super(COOKIE_KEY, OmAuthenticationStrategy.defaultCrypt(encryptionKey, salt));
    }

    protected String[] decode(String value) {
        if (!Strings.isEmpty((String)value)) {
            String username = null;
            String password = null;
            String type = null;
            String domainId = null;
            String[] values = value.split("-sep-");
            if (values.length > 0 && !Strings.isEmpty((String)values[0])) {
                username = values[0];
            }
            if (values.length > 1 && !Strings.isEmpty((String)values[1])) {
                password = values[1];
            }
            if (values.length > 2 && !Strings.isEmpty((String)values[2])) {
                type = values[2];
            }
            if (values.length > 3 && !Strings.isEmpty((String)values[3])) {
                domainId = values[3];
            }
            return new String[]{username, password, type, domainId};
        }
        return new String[0];
    }

    public void save(String username, String password, User.Type type, Long domainId) {
        if (type != User.Type.OAUTH) {
            super.save(username, new String[]{password, type.name(), String.valueOf(domainId)});
        }
    }

    private static ICrypt defaultCrypt(String encryptionKey, String saltStr) {
        SunJceCrypt crypt = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             PrintStream ps = new PrintStream(baos);){
            ps.append(saltStr).append("om_secret");
            byte[] salt = Arrays.copyOfRange(baos.toByteArray(), 0, 8);
            crypt = new SunJceCrypt(salt, 1000);
            crypt.setKey(encryptionKey);
        }
        catch (IOException e) {
            log.error("Enxpected error while creating crypt", (Throwable)e);
        }
        return crypt;
    }
}

