/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.openmeetings.db.dao.room.InvitationDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.service.room.InvitationManager;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.InvitationDialog;
import org.apache.openmeetings.web.common.LanguageDropDown;
import org.apache.openmeetings.web.common.datetime.OmDateTimePicker;
import org.apache.openmeetings.web.util.CalendarWebHelper;
import org.apache.openmeetings.web.util.UserMultiChoice;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.util.string.Strings;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InvitationForm
extends Form<Invitation> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(InvitationForm.class);
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final PasswordTextField passwd = new PasswordTextField("password");
    private final DropDownChoice<String> timeZoneId = new DropDownChoice("timeZoneId", (IModel)Model.of((Serializable)((Object)((String)null))), WebSession.AVAILABLE_TIMEZONES);
    private final OmDateTimePicker from = new OmDateTimePicker("from", (IModel<LocalDateTime>)Model.of((Serializable)LocalDateTime.now()));
    private final OmDateTimePicker to = new OmDateTimePicker("to", (IModel<LocalDateTime>)Model.of((Serializable)LocalDateTime.now()));
    private final LanguageDropDown lang = new LanguageDropDown("language", (IModel<Long>)Model.of((Serializable)null));
    protected final TextField<String> subject = new TextField("subject", (IModel)Model.of((Serializable)((Object)((String)null))));
    protected final TextArea<String> message = new TextArea("message", (IModel)Model.of((Serializable)((Object)((String)null))));
    protected final TextField<String> url = new TextField("url", (IModel)Model.of((Serializable)((Object)((String)null))));
    protected final UserMultiChoice recipients = new UserMultiChoice("recipients", (IModel<Collection<User>>)new CollectionModel(new ArrayList()));
    protected InvitationDialog dialog;
    protected String dropDownParentId;
    @Inject
    private InvitationDao inviteDao;
    @Inject
    private UserDao userDao;
    @Inject
    private InvitationManager inviteManager;

    protected InvitationForm(String id, String dropDownParentId) {
        super(id, (IModel)new CompoundPropertyModel((Object)new Invitation()));
        this.dropDownParentId = dropDownParentId;
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        this.add(new Component[]{this.subject, this.message});
        this.recipients.setLabel((IModel)new ResourceModel("216")).setRequired(true).add(new Behavior[]{AjaxFormComponentUpdatingBehavior.onUpdate((String)"change", (SerializableConsumer & Serializable)target -> {
            this.url.setModelObject(null);
            this.updateButtons((AjaxRequestTarget)target);
        })}).setOutputMarkupId(true);
        if (this.dropDownParentId != null) {
            this.recipients.getSettings().setDropdownParent(this.dropDownParentId);
        }
        this.add(new Component[]{new AjaxCheckBox("passwordProtected"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                ((Invitation)InvitationForm.this.getModelObject()).setPasswordProtected(((Boolean)this.getConvertedInput()).booleanValue());
                InvitationForm.this.passwd.setEnabled(((Boolean)this.getConvertedInput()).booleanValue());
                target.add(new Component[]{InvitationForm.this.passwd});
            }
        }});
        RadioGroup valid = new RadioGroup("valid");
        valid.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                boolean dateEnabled = ((Invitation)InvitationForm.this.getModelObject()).getValid() == Invitation.Valid.PERIOD;
                target.add(new Component[]{InvitationForm.this.from.setEnabled(dateEnabled), InvitationForm.this.to.setEnabled(dateEnabled), InvitationForm.this.timeZoneId.setEnabled(dateEnabled)});
            }
        }});
        this.add(new Component[]{valid.add(new Component[]{new Radio("one", (IModel)Model.of((Serializable)Invitation.Valid.ONE_TIME)), new Radio("period", (IModel)Model.of((Serializable)Invitation.Valid.PERIOD)), new Radio("endless", (IModel)Model.of((Serializable)Invitation.Valid.ENDLESS))})});
        this.add(new Component[]{this.passwd});
        Invitation i = (Invitation)this.getModelObject();
        this.passwd.setLabel((IModel)new ResourceModel("110")).setOutputMarkupId(true).setEnabled(i.isPasswordProtected());
        this.add(new Component[]{this.from.setLabel((IModel<String>)new ResourceModel("530")).setOutputMarkupId(true), this.to.setLabel((IModel<String>)new ResourceModel("531")).setOutputMarkupId(true), this.timeZoneId.setOutputMarkupId(true)});
        this.timeZoneId.add(new Behavior[]{AjaxFormComponentUpdatingBehavior.onUpdate((String)"change", (SerializableConsumer & Serializable)target -> {})});
        this.add(new Component[]{this.url.setOutputMarkupId(true)});
        this.add(new Component[]{this.lang, this.feedback.setOutputMarkupId(true)});
        super.onInitialize();
    }

    protected void updateButtons(AjaxRequestTarget target) {
        Collection recpnts = (Collection)this.recipients.getModelObject();
        boolean generateEnabled = false;
        if (recpnts.size() == 1) {
            User u = (User)recpnts.iterator().next();
            generateEnabled = WebSession.getUserId().equals(u.getId()) || User.Type.CONTACT == u.getType();
        }
        target.add(new Component[]{this.dialog.getSend().setEnabled(!recpnts.isEmpty()), this.dialog.getGenerate().setEnabled(generateEnabled)});
    }

    protected void onValidate() {
        if (this.from.getConvertedInput() != null && this.to.getConvertedInput() != null && ((LocalDateTime)this.from.getConvertedInput()).isAfter((ChronoLocalDateTime)this.to.getConvertedInput())) {
            this.error((Serializable)((Object)this.getString("1592")));
        }
    }

    protected Invitation create(User u) {
        Invitation i = new Invitation((Invitation)this.getModelObject());
        i.setInvitedBy(this.userDao.get(WebSession.getUserId()));
        i.setId(null);
        i.setUsed(false);
        i.setPassword(CryptProvider.get().hash(i.getPassword()));
        i.setValidFrom(CalendarHelper.getDate((LocalDateTime)((LocalDateTime)this.from.getModelObject()).minusMinutes(5L), (String)((String)this.timeZoneId.getModelObject())));
        i.setValidTo(CalendarHelper.getDate((LocalDateTime)((LocalDateTime)this.to.getModelObject()), (String)((String)this.timeZoneId.getModelObject())));
        i.setInvitee(u);
        i.setHash(UUID.randomUUID().toString());
        if (User.Type.CONTACT == u.getType()) {
            u.setLanguageId(((Long)this.lang.getModelObject()).longValue());
        }
        return this.inviteDao.update(i);
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(false);
    }

    public void onError(AjaxRequestTarget target) {
        target.add(new Component[]{this.feedback});
    }

    public void updateModel(AjaxRequestTarget target) {
        Invitation i = new Invitation();
        User u = this.userDao.get(WebSession.getUserId());
        i.setInvitedBy(u);
        i.setRoom(null);
        LocalDateTime now = ZonedDateTime.now(CalendarWebHelper.getZoneId()).toLocalDateTime();
        this.from.setModelObject(now);
        this.to.setModelObject(now.plusDays(1L));
        i.setPassword(null);
        i.setHash(null);
        this.subject.setModelObject(null);
        this.message.setModelObject(null);
        this.timeZoneId.setModelObject((Object)u.getTimeZoneId());
        this.lang.setModelObject(u.getLanguageId());
        this.url.setModelObject(null);
        this.setModelObject(i);
        this.recipients.setModelObject(new ArrayList());
        this.recipients.setEnabled(true);
        this.passwd.setEnabled(false);
        boolean isPeriod = i.getValid() == Invitation.Valid.PERIOD;
        this.from.setEnabled(isPeriod);
        this.to.setEnabled(isPeriod);
        this.timeZoneId.setEnabled(isPeriod);
        target.add(new Component[]{this});
    }

    public void setDialog(InvitationDialog dialog) {
        this.dialog = dialog;
    }

    public void onClick(AjaxRequestTarget target, Action action) {
        String userbaseUrl = WebSession.get().getExtendedProperties().getBaseUrl();
        if (Action.GENERATE == action) {
            Invitation i = this.create((User)((Collection)this.recipients.getModelObject()).iterator().next());
            this.setModelObject(i);
            this.url.setModelObject((Object)Application.getInvitationLink(i, userbaseUrl));
            target.add(new Component[]{this.url});
        } else {
            if (Strings.isEmpty((String)((String)this.url.getModelObject()))) {
                for (User u : (Collection)this.recipients.getModelObject()) {
                    Invitation i = this.create(u);
                    try {
                        this.inviteManager.sendInvitationLink(i, Invitation.MessageType.CREATE, (String)this.subject.getModelObject(), (String)this.message.getModelObject(), false, userbaseUrl);
                    }
                    catch (Exception e) {
                        log.error("error while sending invitation by User ", (Throwable)e);
                    }
                }
            } else {
                Invitation i = (Invitation)this.getModelObject();
                try {
                    this.inviteManager.sendInvitationLink(i, Invitation.MessageType.CREATE, (String)this.subject.getModelObject(), (String)this.message.getModelObject(), false, userbaseUrl);
                }
                catch (Exception e) {
                    log.error("error while sending invitation by URL ", (Throwable)e);
                }
            }
            this.dialog.close((IPartialPageRequestHandler)target);
        }
    }

    public static enum Action {
        GENERATE,
        SEND;

    }
}

