/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common.tree;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.SplitButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconType;
import jakarta.inject.Inject;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.NameDialog;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.common.tree.ConvertingErrorsDialog;
import org.apache.openmeetings.web.common.tree.FileItemTree;
import org.apache.openmeetings.web.common.tree.OmTreeProvider;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.AjaxDownloadBehavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.FileSystemResource;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.ui.interaction.droppable.Droppable;
import org.wicketstuff.jquery.ui.interaction.droppable.DroppableBehavior;
import org.wicketstuff.jquery.ui.interaction.droppable.IDroppableListener;

public abstract class FileTreePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String BASE_CLASS = " om-icon big clickable";
    private static final String UPLOAD_CLASS = "upload om-icon big clickable float-start ";
    private static final String CREATE_DIR_CLASS = "folder-create om-icon big clickable float-start ";
    private static final String TRASH_CLASS = "trash om-icon big clickable float-end ";
    private static final String DISABLED_CLASS = " disabled";
    final WebMarkupContainer trees = new WebMarkupContainer("tree-container");
    private final WebMarkupContainer sizes = new WebMarkupContainer("sizes");
    private BaseFileItem lastSelected = null;
    private Map<String, BaseFileItem> selected = new HashMap<String, BaseFileItem>();
    private File dwnldFile;
    private String dwnldName;
    final AjaxDownloadBehavior downloader = new AjaxDownloadBehavior(new IResource(){
        private static final long serialVersionUID = 1L;

        public void respond(IResource.Attributes attributes) {
            new FileSystemResource(FileTreePanel.this.dwnldFile.toPath()){
                private static final long serialVersionUID = 1L;

                protected AbstractResource.ResourceResponse createResourceResponse(IResource.Attributes attr, Path path) {
                    AbstractResource.ResourceResponse response = super.createResourceResponse(attr, path);
                    response.setCacheDuration(Duration.ZERO);
                    response.setFileName(FileTreePanel.this.dwnldName);
                    return response;
                }
            }.respond(attributes);
        }
    });
    protected final IModel<String> homeSize = Model.of((Serializable)((Object)((String)null)));
    protected final IModel<String> publicSize = Model.of((Serializable)((Object)((String)null)));
    final ConvertingErrorsDialog errorsDialog = new ConvertingErrorsDialog("errors", (IModel<BaseFileItem>)Model.of((Serializable)((Recording)null)));
    FileItemTree tree;
    private final WebMarkupContainer buttons = new WebMarkupContainer("buttons");
    private final Form<Void> form = new Form("form");
    private final NameDialog addFolder;
    private final WebMarkupContainer trash = new WebMarkupContainer("trash");
    private final Long roomId;
    private boolean readOnly = true;
    private final Component createDir = new WebMarkupContainer("create").add(new Behavior[]{new AjaxEventBehavior("click"){
        private static final long serialVersionUID = 1L;

        protected void onEvent(AjaxRequestTarget target) {
            FileTreePanel.this.addFolder.show((IPartialPageRequestHandler)target);
        }
    }});
    private final Component upload = new WebMarkupContainer("upload");
    @Inject
    private RecordingDao recDao;
    @Inject
    private FileItemDao fileDao;

    protected FileTreePanel(String id, Long roomId, NameDialog addFolder) {
        super(id);
        this.roomId = roomId;
        this.addFolder = addFolder;
    }

    protected void onInitialize() {
        super.onInitialize();
        OmTreeProvider tp = new OmTreeProvider(this.roomId);
        this.select(tp.getRoot(), null, false, false);
        Component[] componentArray = new Component[1];
        this.tree = new FileItemTree("tree", this, tp);
        componentArray[0] = this.tree;
        this.form.add(componentArray);
        this.add(new Component[]{this.form.add(new Behavior[]{this.downloader})});
        Droppable<BaseFileItem> trashToolbar = new Droppable<BaseFileItem>("trash-toolbar"){
            private static final long serialVersionUID = 1L;

            public void onConfigure(JQueryBehavior behavior) {
                super.onConfigure(behavior);
                behavior.setOption("hoverClass", (Object)Options.asString((String)"trash-toolbar-hover"));
                behavior.setOption("accept", (Object)Options.asString((String)".recorditem, .fileitem"));
            }

            public JQueryBehavior newWidgetBehavior(String selector) {
                return new DroppableBehavior(selector, (IDroppableListener)this){
                    private static final long serialVersionUID = 1L;

                    protected JQueryAjaxBehavior newOnDropAjaxBehavior(IJQueryAjaxAware source) {
                        return new DroppableBehavior.OnDropAjaxBehavior(source){
                            private static final long serialVersionUID = 1L;

                            public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
                                return "OmFileTree.confirmTrash($(this), ui, function() {" + String.valueOf(super.getCallbackFunctionBody(parameters)) + "});";
                            }
                        };
                    }
                };
            }

            public void onDrop(AjaxRequestTarget target, Component component) {
                Object o = component.getDefaultModelObject();
                if (o instanceof BaseFileItem) {
                    BaseFileItem f = (BaseFileItem)o;
                    if (FileTreePanel.this.isSelected(f)) {
                        FileTreePanel.this.deleteAll(target);
                    } else {
                        FileTreePanel.this.delete(f, (IPartialPageRequestHandler)target);
                    }
                }
            }
        };
        this.form.add(new Component[]{trashToolbar});
        trashToolbar.add(new Component[]{this.getUpload()});
        trashToolbar.add(new Component[]{this.createDir});
        trashToolbar.add(new Component[]{new WebMarkupContainer("refresh").add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                FileTreePanel.this.update((IPartialPageRequestHandler)target);
            }
        }})});
        trashToolbar.add(new Component[]{this.trash.setOutputMarkupId(true)});
        this.trash.add(new Behavior[]{new AjaxEventBehavior("confirmed.bs.confirmation"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                FileTreePanel.this.deleteAll(target);
            }
        }});
        ConfirmationBehavior trashConfirm = new ConfirmationBehavior(ConfirmationHelper.newOkCancelDangerConfirmCfg((Component)trashToolbar, this.getString("80")).withContent(this.getString("713"))){
            private static final long serialVersionUID = 1L;

            public boolean isEnabled(Component component) {
                return !FileTreePanel.this.readOnly && !FileTreePanel.this.selected.isEmpty();
            }
        };
        this.trash.add(new Behavior[]{trashConfirm});
        this.form.add(new Component[]{this.trees.add(new Component[]{this.tree}).setOutputMarkupId(true)});
        this.updateSizes();
        this.form.add(new Component[]{this.sizes.add(new Component[]{new Label("homeSize", this.homeSize), new Label("publicSize", this.publicSize)}).setOutputMarkupId(true)});
        this.form.add(new Component[]{this.errorsDialog});
        this.setReadOnly(false, null);
        SplitButton download = new SplitButton("download", (IModel)Model.of((Serializable)((Object)""))){
            private static final long serialVersionUID = 1L;

            private boolean isDownloadable(BaseFileItem f) {
                return !f.isReadOnly() && (BaseFileItem.Type.PRESENTATION == f.getType() || BaseFileItem.Type.IMAGE == f.getType() || BaseFileItem.Type.RECORDING == f.getType());
            }

            private AbstractLink createLink(String markupId, IModel<String> model, final String ext) {
                return new BootstrapAjaxLink<String>(markupId, model, Buttons.Type.Outline_Primary, model){
                    private static final long serialVersionUID = 1L;

                    protected void onConfigure() {
                        BaseFileItem fi;
                        super.onConfigure();
                        for (CssClassNameAppender b : this.getBehaviors(CssClassNameAppender.class)) {
                            this.remove(new Behavior[]{b});
                        }
                        File f = null;
                        if (FileTreePanel.this.getSelected().size() == 1 && this.isDownloadable(fi = FileTreePanel.this.getLastSelected())) {
                            f = fi.getFile(ext);
                        }
                        this.setEnabled(f != null && f.exists());
                    }

                    public void onClick(AjaxRequestTarget target) {
                        this.onDownlownClick(target, ext);
                    }
                }.setIconType((IconType)FontAwesome6IconType.download_s);
            }

            protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                return List.of(this.createLink(buttonMarkupId, (IModel<String>)new ResourceModel("files.download.original"), null), this.createLink(buttonMarkupId, (IModel<String>)new ResourceModel("files.download.pdf"), "pdf"), this.createLink(buttonMarkupId, (IModel<String>)new ResourceModel("files.download.jpg"), "jpg"), this.createLink(buttonMarkupId, (IModel<String>)Model.of((Serializable)((Object)"mp4")), "mp4"));
            }

            protected void addButtonBehavior(ButtonBehavior buttonBehavior) {
                buttonBehavior.setSize(Buttons.Size.Small).setType(Buttons.Type.Outline_Secondary);
                super.addButtonBehavior(buttonBehavior);
            }

            protected AbstractLink newBaseButton(String markupId, IModel<String> labelModel, IModel<IconType> iconTypeModel) {
                AbstractLink btn = this.createLink(markupId, (IModel<String>)Model.of((Serializable)((Object)"")), null);
                btn.add(new Behavior[]{AttributeModifier.append((String)"title", (IModel)new ResourceModel("867"))});
                return btn;
            }

            protected void onConfigure() {
                super.onConfigure();
                boolean enabled = false;
                if (FileTreePanel.this.getSelected().size() == 1) {
                    enabled = this.isDownloadable(FileTreePanel.this.getLastSelected());
                }
                this.setEnabled(enabled);
            }

            public void onDownlownClick(AjaxRequestTarget target, String ext) {
                File f;
                BaseFileItem fi = FileTreePanel.this.getLastSelected();
                File file = f = ext == null && (BaseFileItem.Type.IMAGE == fi.getType() || BaseFileItem.Type.PRESENTATION == fi.getType()) ? fi.getOriginal() : fi.getFile(ext);
                if (f != null && f.exists()) {
                    FileTreePanel.this.dwnldFile = f;
                    String fileExt = OmFileHelper.getFileExt((String)f.getName());
                    FileTreePanel.this.dwnldName = fi.getName();
                    if (!FileTreePanel.this.dwnldName.endsWith(fileExt)) {
                        FileTreePanel.this.dwnldName = FileTreePanel.this.dwnldName + "." + fileExt;
                    }
                    FileTreePanel.this.downloader.initiate((IPartialPageRequestHandler)target);
                }
            }
        };
        this.buttons.setOutputMarkupId(true);
        this.form.add(new Component[]{this.buttons.add(new Component[]{download, new ListView<AbstractLink>("other-buttons", this.newOtherButtons("button")){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<AbstractLink> item) {
                item.add(new Component[]{(Component)item.getModelObject()});
            }
        }})});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(FileTreePanel.class, "filetree.js")));
    }

    protected String getContainment() {
        return ".file.item.drop.area";
    }

    protected Component getUpload() {
        return this.upload.setVisible(false);
    }

    private void deleteAll(AjaxRequestTarget target) {
        for (BaseFileItem f : this.selected.values()) {
            if (f.isReadOnly()) continue;
            this.delete(f, (IPartialPageRequestHandler)target);
        }
        this.updateSelected(target);
        this.selected.clear();
        this.updateSelected(target);
    }

    void delete(BaseFileItem f, IPartialPageRequestHandler handler) {
        Long id = f.getId();
        if (id != null) {
            if (f instanceof Recording) {
                this.recDao.delete(f);
            } else {
                this.fileDao.delete(f);
            }
        }
        this.update(handler);
    }

    public void setReadOnly(boolean readOnly, IPartialPageRequestHandler handler) {
        if (this.readOnly != readOnly) {
            this.readOnly = readOnly;
            this.tree.refreshRoots(!readOnly);
            this.createDir.setEnabled(!readOnly);
            this.createDir.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(CREATE_DIR_CLASS + (readOnly ? DISABLED_CLASS : ""))))});
            this.upload.setEnabled(!readOnly);
            this.upload.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(UPLOAD_CLASS + (readOnly ? DISABLED_CLASS : ""))))});
            this.updateTrash(handler);
            if (handler != null) {
                handler.add(new Component[]{this.createDir, this.upload});
                this.update(handler);
            }
        }
    }

    public boolean isEditable() {
        return !this.readOnly;
    }

    protected abstract void update(AjaxRequestTarget var1, BaseFileItem var2);

    public void createFolder(AjaxRequestTarget target, String name) {
        BaseFileItem p = this.lastSelected;
        boolean isRecording = p instanceof Recording;
        Recording f = isRecording ? new Recording() : new FileItem();
        f.setName(name);
        f.setHash(UUID.randomUUID().toString());
        f.setInsertedBy(WebSession.getUserId());
        f.setType(BaseFileItem.Type.FOLDER);
        f.setOwnerId(p.getOwnerId());
        f.setGroupId(p.getGroupId());
        f.setRoomId(p.getRoomId());
        f.setParentId(BaseFileItem.Type.FOLDER == p.getType() ? p.getId() : null);
        if (isRecording) {
            this.recDao.update(f);
        } else {
            this.fileDao.update((FileItem)f);
        }
        this.update((IPartialPageRequestHandler)target);
    }

    public abstract void updateSizes();

    public boolean isSelected(BaseFileItem f) {
        return this.selected.containsKey(f.getHash());
    }

    public Map<String, BaseFileItem> getSelected() {
        return this.selected;
    }

    public BaseFileItem getLastSelected() {
        return this.lastSelected;
    }

    public void update(IPartialPageRequestHandler handler) {
        this.updateSizes();
        handler.add(new Component[]{this.sizes, this.trees});
    }

    private void updateSelected(AjaxRequestTarget target) {
        for (BaseFileItem f : this.selected.values()) {
            this.updateNode(target, f);
        }
        this.updateTrash((IPartialPageRequestHandler)target);
    }

    private void updateTrash(IPartialPageRequestHandler handler) {
        boolean hasDeletable = this.selected.values().stream().map(BaseFileItem::getId).anyMatch(Objects::nonNull);
        this.trash.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(TRASH_CLASS + (hasDeletable && !this.readOnly ? "" : DISABLED_CLASS))))});
        if (handler != null) {
            handler.add(new Component[]{this.trash});
        }
    }

    void updateNode(AjaxRequestTarget target, BaseFileItem fi) {
        if (fi != null && !fi.isDeleted() && target != null) {
            if (BaseFileItem.Type.FOLDER == fi.getType()) {
                this.tree.updateBranch(fi, (IPartialPageRequestHandler)target);
            } else {
                this.tree.updateNode(fi, (IPartialPageRequestHandler)target);
            }
        }
    }

    private static boolean sameParent(Long roomId, BaseFileItem f1, BaseFileItem f2) {
        if (f1 instanceof Recording && f2 instanceof FileItem) {
            return false;
        }
        if (f1.getParentId() != null && f1.getParentId().equals(f2.getParentId())) {
            return true;
        }
        if (f1.getParentId() == null && f2.getParentId() == null) {
            if (f1.getOwnerId() != null && f1.getOwnerId().equals(f2.getOwnerId())) {
                return true;
            }
            if (f1.getRoomId() != null && f1.getRoomId().equals(f2.getRoomId())) {
                return true;
            }
            if (f2 instanceof FileItem && roomId != null && f1.getRoomId() == null && f2.getRoomId() == null && f1.getOwnerId() == null && f2.getOwnerId() == null) {
                return true;
            }
        }
        return false;
    }

    public void select(BaseFileItem fi, AjaxRequestTarget target, boolean shift, boolean ctrl) {
        this.updateSelected(target);
        if (ctrl) {
            if (this.isSelected(fi)) {
                this.selected.remove(fi.getHash());
            } else {
                this.selected.put(fi.getHash(), fi);
            }
            this.lastSelected = fi;
        } else if (shift && this.lastSelected != null && !this.lastSelected.getHash().equals(fi.getHash()) && FileTreePanel.sameParent(this.roomId, fi, this.lastSelected)) {
            this.selected.clear();
            String lastHash = null;
            for (BaseFileItem f : this.tree.getProvider().getByParent(fi, fi.getParentId())) {
                if (lastHash == null) {
                    if (f.getHash().equals(this.lastSelected.getHash())) {
                        lastHash = fi.getHash();
                    }
                    if (f.getHash().equals(fi.getHash())) {
                        lastHash = this.lastSelected.getHash();
                    }
                }
                if (lastHash == null) continue;
                this.selected.put(f.getHash(), f);
                if (!f.getHash().equals(lastHash)) continue;
                break;
            }
        } else {
            this.selected.clear();
            this.selected.put(fi.getHash(), fi);
            this.lastSelected = fi;
        }
        this.updateSelected(target);
        if (target != null) {
            target.add(new Component[]{this.trash, this.buttons});
        }
    }

    protected List<AbstractLink> newOtherButtons(String markupId) {
        return List.of();
    }

    protected void onDetach() {
        this.homeSize.detach();
        this.publicSize.detach();
        super.onDetach();
    }
}

