/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.HostPort;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.ClientAuthType;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageProcessor;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;

public class TLSMessageProcessor
extends ConnectionOrientedMessageProcessor
implements Runnable {
    private static StackLogger logger = CommonLogger.getLogger(TLSMessageProcessor.class);

    protected TLSMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port) {
        super(ipAddress, port, "tls", sipStack);
    }

    @Override
    public void start() throws IOException {
        Thread thread = new Thread(this);
        thread.setName("MessageProcessorThread-TLS-" + this.getIpAddress().getHostAddress() + '/' + this.getPort());
        thread.setPriority(this.sipStack.getThreadPriority());
        thread.setDaemon(true);
        this.sock = this.sipStack.getNetworkLayer().createSSLServerSocket(this.getPort(), 0, this.getIpAddress());
        if (this.sipStack.getClientAuth() == ClientAuthType.Want || this.sipStack.getClientAuth() == ClientAuthType.Default) {
            ((SSLServerSocket)this.sock).setWantClientAuth(true);
        } else {
            ((SSLServerSocket)this.sock).setWantClientAuth(false);
        }
        if (this.sipStack.getClientAuth() == ClientAuthType.Enabled) {
            ((SSLServerSocket)this.sock).setNeedClientAuth(true);
        } else {
            ((SSLServerSocket)this.sock).setNeedClientAuth(false);
        }
        ((SSLServerSocket)this.sock).setUseClientMode(false);
        String[] enabledCiphers = ((SipStackImpl)this.sipStack).getEnabledCipherSuites();
        ((SSLServerSocket)this.sock).setEnabledProtocols(((SipStackImpl)this.sipStack).getEnabledProtocols());
        ((SSLServerSocket)this.sock).setEnabledCipherSuites(enabledCiphers);
        if (this.sipStack.getClientAuth() == ClientAuthType.Want || this.sipStack.getClientAuth() == ClientAuthType.Default) {
            ((SSLServerSocket)this.sock).setWantClientAuth(true);
        } else {
            ((SSLServerSocket)this.sock).setWantClientAuth(false);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SSLServerSocket want client auth " + ((SSLServerSocket)this.sock).getWantClientAuth());
            logger.logDebug("SSLServerSocket need client auth " + ((SSLServerSocket)this.sock).getNeedClientAuth());
        }
        this.isRunning = true;
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning) {
            Socket newsock;
            block17: {
                newsock = null;
                try {
                    TLSMessageProcessor tLSMessageProcessor = this;
                    synchronized (tLSMessageProcessor) {
                        while (this.sipStack.maxConnections != -1 && this.nConnections >= this.sipStack.maxConnections) {
                            try {
                                this.wait();
                                if (this.isRunning) continue;
                                return;
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                                break;
                            }
                        }
                        ++this.nConnections;
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug(" waiting to accept new connection!");
                    }
                    newsock = this.sock.accept();
                    if (!logger.isLoggingEnabled(32)) break block17;
                    logger.logDebug("Accepting new connection!");
                }
                catch (SocketException ex) {
                    if (this.isRunning) {
                        logger.logError("Fatal - SocketException occured while Accepting connection", ex);
                        this.isRunning = false;
                        break;
                    }
                }
                catch (SSLException ex) {
                    this.isRunning = false;
                    logger.logError("Fatal - SSSLException occured while Accepting connection", ex);
                    break;
                }
                catch (IOException ex) {
                    logger.logError("Problem Accepting Connection", ex);
                    continue;
                }
                catch (Exception ex) {
                    logger.logError("Unexpected Exception!", ex);
                    continue;
                }
            }
            if (!this.isRunning) continue;
            try {
                TLSMessageChannel newChannel = new TLSMessageChannel(newsock, this.sipStack, this, "TLSMessageChannelThread-" + this.nConnections);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug(Thread.currentThread() + " adding incoming channel " + newChannel.getKey());
                }
                if (!newChannel.isHandshakeCompleted()) continue;
                this.incomingMessageChannels.put(newChannel.getKey(), newChannel);
            }
            catch (Exception ex) {
                logger.logError("A problem occured while Accepting connection", ex);
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        try {
            this.sock.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collection en = this.messageChannels.values();
        for (TLSMessageChannel next : en) {
            next.close();
        }
        for (TLSMessageChannel next : this.incomingMessageChannels.values()) {
            next.close();
        }
        this.notify();
    }

    @Override
    public synchronized MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        String key = MessageChannel.getKey(targetHostPort, "TLS");
        if (this.messageChannels.get(key) != null) {
            return (TLSMessageChannel)this.messageChannels.get(key);
        }
        TLSMessageChannel retval = new TLSMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
        this.messageChannels.put(key, retval);
        retval.isCached = true;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("key " + key);
            logger.logDebug("Creating " + retval);
        }
        return retval;
    }

    @Override
    public synchronized MessageChannel createMessageChannel(InetAddress host, int port) throws IOException {
        try {
            String key = MessageChannel.getKey(host, port, "TLS");
            if (this.messageChannels.get(key) != null) {
                return (TLSMessageChannel)this.messageChannels.get(key);
            }
            TLSMessageChannel retval = new TLSMessageChannel(host, port, this.sipStack, this);
            this.messageChannels.put(key, retval);
            retval.isCached = true;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("key " + key);
                logger.logDebug("Creating " + retval);
            }
            return retval;
        }
        catch (UnknownHostException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public int getDefaultTargetPort() {
        return 5061;
    }

    @Override
    public boolean isSecure() {
        return true;
    }
}

