/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.basic;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.IDataProviderEntity;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.db.entity.basic.ScreenStreamDesc;
import org.apache.openmeetings.db.entity.basic.StreamDesc;
import org.apache.openmeetings.db.entity.basic.WebcamStreamDesc;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.wicket.util.string.Strings;

public class Client
implements IDataProviderEntity,
IWsClient {
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final int pageId;
    private User user;
    private Room room;
    private final String uid;
    private final String sid;
    private String remoteAddress;
    private final Set<Room.Right> rights = ConcurrentHashMap.newKeySet();
    private final Map<String, StreamDesc> streams = new ConcurrentHashMap<String, StreamDesc>();
    private final Date connectedSince;
    private int cam = -1;
    private int mic = -1;
    private int width = 0;
    private int height = 0;
    private String serverId = null;
    private final String pictureUri;

    public Client(String sessionId, int pageId, User u, String pictureUri) {
        this.sessionId = sessionId;
        this.pageId = pageId;
        this.user = u;
        this.connectedSince = new Date();
        this.pictureUri = pictureUri;
        this.uid = UUID.randomUUID().toString();
        this.sid = UUID.randomUUID().toString();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public int getPageId() {
        return this.pageId;
    }

    public User getUser() {
        return this.user;
    }

    public Client updateUser(UserDao dao) {
        this.user = dao.get(this.user.getId());
        return this;
    }

    public Long getUserId() {
        return this.user == null ? null : this.user.getId();
    }

    public boolean sameUserId(Long userId) {
        return this.getUserId() != null && this.getUserId().equals(userId);
    }

    public String getPictureUri() {
        return this.pictureUri;
    }

    @Override
    @Nonnull
    public String getUid() {
        return this.uid;
    }

    public String getSid() {
        return this.sid;
    }

    public boolean isSip() {
        return OmFileHelper.SIP_USER_ID.equals(this.getUserId());
    }

    public void clear() {
        this.rights.clear();
        this.streams.clear();
    }

    public boolean hasRight(Room.Right right) {
        if (Room.Right.SUPER_MODERATOR == right) {
            return this.rights.contains((Object)right);
        }
        return this.rights.contains((Object)Room.Right.SUPER_MODERATOR) || this.rights.contains((Object)Room.Right.MODERATOR) || this.rights.contains((Object)right);
    }

    public Client allow(Room.Right ... inRights) {
        this.allow(List.of(inRights));
        return this;
    }

    public void allow(Iterable<Room.Right> inRights) {
        for (Room.Right right : inRights) {
            if (this.hasRight(right)) continue;
            this.rights.add(right);
        }
    }

    public void deny(Room.Right ... inRights) {
        for (Room.Right right : inRights) {
            this.rights.remove((Object)right);
        }
    }

    public boolean isBroadcasting() {
        return this.getCamStreams().anyMatch(WebcamStreamDesc::isBroadcasting);
    }

    public List<Activity> getActivities() {
        return this.getCamStreams().flatMap(sd -> sd.getActivities().stream()).toList();
    }

    public boolean has(Activity activity) {
        return this.getCamStreams().flatMap(sd -> sd.getActivities().stream()).anyMatch(a -> activity == a);
    }

    public boolean isAllowed(Activity a) {
        boolean r = false;
        if (this.room == null) {
            return r;
        }
        switch (a) {
            case AUDIO: {
                r = this.hasRight(Room.Right.AUDIO);
                break;
            }
            case VIDEO: {
                r = !this.room.isAudioOnly() && this.hasRight(Room.Right.VIDEO);
                break;
            }
            case AUDIO_VIDEO: {
                r = !this.room.isAudioOnly() && this.hasRight(Room.Right.AUDIO) && this.hasRight(Room.Right.VIDEO);
                break;
            }
        }
        return r;
    }

    public StreamDesc addStream(StreamType stype, Activity toggle) {
        StreamDesc sd = switch (stype) {
            default -> throw new IncompatibleClassChangeError();
            case StreamType.SCREEN -> new ScreenStreamDesc(this, toggle);
            case StreamType.WEBCAM -> new WebcamStreamDesc(this, toggle);
        };
        this.streams.put(sd.getUid(), sd);
        return sd;
    }

    public StreamDesc removeStream(String inUid) {
        return this.streams.remove(inUid);
    }

    public List<StreamDesc> getStreams() {
        return List.copyOf(this.streams.values());
    }

    public StreamDesc getStream(String inUid) {
        return this.streams.get(inUid);
    }

    public Optional<ScreenStreamDesc> getScreenStream() {
        return this.streams.values().stream().filter(sd -> StreamType.SCREEN == sd.getType()).map(ScreenStreamDesc.class::cast).findFirst();
    }

    public Stream<WebcamStreamDesc> getCamStreams() {
        return this.streams.values().stream().filter(sd -> StreamType.WEBCAM == sd.getType()).map(WebcamStreamDesc.class::cast);
    }

    public Date getConnectedSince() {
        return this.connectedSince;
    }

    @Override
    public Long getId() {
        return null;
    }

    @Override
    public void setId(Long id) {
    }

    public Room getRoom() {
        return this.room;
    }

    public Long getRoomId() {
        return this.room == null ? null : this.room.getId();
    }

    public Client setRoom(Room room) {
        this.room = room;
        return this;
    }

    public boolean isCamEnabled() {
        return (this.room == null || !this.room.isAudioOnly()) && this.cam > -1;
    }

    public int getCam() {
        return this.cam;
    }

    public Client setCam(int cam) {
        this.cam = cam;
        return this;
    }

    public boolean isMicEnabled() {
        return this.mic > -1;
    }

    public int getMic() {
        return this.mic;
    }

    public Client setMic(int mic) {
        this.mic = mic;
        return this;
    }

    public int getWidth() {
        return this.room != null && this.room.isInterview() ? 320 : this.width;
    }

    public Client setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.room != null && this.room.isInterview() ? 260 : this.height;
    }

    public Client setHeight(int height) {
        this.height = height;
        return this;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public Client setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    JSONObject addUserJson(JSONObject o) {
        JSONObject u = new JSONObject();
        if (this.user != null) {
            JSONObject a = new JSONObject();
            u.put("id", (Object)this.user.getId()).put("firstName", (Object)this.user.getFirstname()).put("lastName", (Object)this.user.getLastname()).put("displayName", (Object)this.user.getDisplayName()).put("address", (Object)a).put("pictureUri", (Object)this.pictureUri);
            if (this.user.getAddress() != null) {
                if (Strings.isEmpty((String)this.user.getFirstname()) && Strings.isEmpty((String)this.user.getLastname())) {
                    a.put("email", (Object)this.user.getAddress().getEmail());
                }
                a.put("country", (Object)this.user.getAddress().getCountry());
            }
        }
        int level = this.hasRight(Room.Right.MODERATOR) ? 5 : (this.hasRight(Room.Right.WHITEBOARD) ? 3 : 1);
        return o.put("user", (Object)u).put("level", level);
    }

    JSONObject addCamMic(boolean self, JSONObject json) {
        if (self) {
            json.put("cam", this.cam).put("mic", this.mic);
        }
        return json;
    }

    public JSONObject toJson(boolean self) {
        JSONArray streamArr = new JSONArray();
        for (Map.Entry<String, StreamDesc> e : this.streams.entrySet()) {
            streamArr.put((Object)e.getValue().toJson(self));
        }
        JSONObject json = new JSONObject().put("cuid", (Object)this.uid).put("uid", (Object)this.uid).put("rights", (Object)new JSONArray(this.rights)).put("activities", (Object)new JSONArray(this.getActivities())).put("streams", (Object)streamArr).put("width", this.getWidth()).put("height", this.getHeight()).put("self", self);
        return this.addUserJson(this.addCamMic(self, json));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Client c) {
        if (c == this) {
            return;
        }
        this.user = c.user;
        this.room = c.room;
        Object object = this.rights;
        synchronized (object) {
            HashSet<Room.Right> rr = new HashSet<Room.Right>(c.rights);
            this.rights.clear();
            this.rights.addAll(rr);
        }
        object = this.streams;
        synchronized (object) {
            this.streams.clear();
            c.streams.values().stream().map(sd -> switch (sd.getType()) {
                default -> throw new IncompatibleClassChangeError();
                case StreamType.SCREEN -> new ScreenStreamDesc((ScreenStreamDesc)sd);
                case StreamType.WEBCAM -> new WebcamStreamDesc((WebcamStreamDesc)sd);
            }).forEach(sd -> this.streams.put(sd.getUid(), (StreamDesc)sd));
        }
        this.cam = c.cam;
        this.mic = c.mic;
        this.width = c.width;
        this.height = c.height;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Client)) {
            return false;
        }
        Client other = (Client)obj;
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }

    public String toString() {
        return "Client [uid=" + this.uid + ", sessionId=" + this.sessionId + ", pageId=" + this.pageId + ", userId=" + this.getUserId() + ", room=" + this.getRoomId() + ", rights=" + String.valueOf(this.rights) + ", activities=" + String.valueOf(this.getActivities()) + ", connectedSince=" + String.valueOf(this.connectedSince) + "]";
    }

    public static enum Activity {
        AUDIO,
        VIDEO,
        AUDIO_VIDEO,
        SCREEN,
        RECORD;

    }

    public static enum StreamType {
        WEBCAM,
        SCREEN;

    }
}

