/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultJsonRpcHandler<P>
implements JsonRpcHandler<P> {
    private final Logger log = LoggerFactory.getLogger(DefaultJsonRpcHandler.class);
    private boolean useSockJs;
    private String label;
    private boolean pingWatchdog = false;
    private List<String> allowedOrigins = ImmutableList.of();
    private List<Object> interceptors = ImmutableList.of();

    @Override
    public void afterConnectionEstablished(Session session) throws Exception {
    }

    @Override
    public void afterConnectionClosed(Session session, String status) throws Exception {
    }

    @Override
    public void afterReconnection(Session session) throws Exception {
    }

    @Override
    public void handleTransportError(Session session, Throwable exception) throws Exception {
        this.log.warn("Transport error. Exception " + exception.getClass().getName() + ":" + exception.getLocalizedMessage());
    }

    @Override
    public void handleUncaughtException(Session session, Exception exception) {
        this.log.warn("Uncaught exception in handler {}", (Object)this.getClass().getName(), (Object)exception);
    }

    @Override
    public Class<?> getHandlerType() {
        return this.getClass();
    }

    @Override
    public DefaultJsonRpcHandler<P> withSockJS() {
        this.useSockJs = true;
        return this;
    }

    @Override
    public boolean isSockJSEnabled() {
        return this.useSockJs;
    }

    @Override
    public final DefaultJsonRpcHandler<P> withAllowedOrigins(String ... origins) {
        this.allowedOrigins = ImmutableList.copyOf((Object[])origins);
        return this;
    }

    @Override
    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    @Override
    public DefaultJsonRpcHandler<P> withLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public DefaultJsonRpcHandler<P> withPingWatchdog(boolean pingAsWachdog) {
        this.pingWatchdog = pingAsWachdog;
        return this;
    }

    @Override
    public boolean isPingWatchdog() {
        return this.pingWatchdog;
    }

    @Override
    public JsonRpcHandler<P> withInterceptors(Object ... interceptors) {
        this.interceptors = ImmutableList.copyOf((Object[])interceptors);
        return this;
    }

    @Override
    public List<Object> interceptors() {
        return this.interceptors;
    }
}

