/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.netpreserve.jwarc.ParsingException;
import org.netpreserve.jwarc.WarcParser;

public class MessageHeaders {
    private static Pattern COMMA_SEPARATOR = Pattern.compile("[ \t]*,[ \t]*");
    private Map<String, List<String>> map;
    private static final boolean[] ILLEGAL = MessageHeaders.initIllegalLookup();

    public static MessageHeaders of(String ... keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("an even number keysAndValues must be provided");
        }
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < keysAndValues.length; i += 2) {
            map.computeIfAbsent(keysAndValues[i], k -> new ArrayList()).add(keysAndValues[i + 1]);
        }
        return new MessageHeaders(map);
    }

    MessageHeaders(Map<String, List<String>> map) {
        map.replaceAll((name, values) -> Collections.unmodifiableList(values));
        this.map = Collections.unmodifiableMap(map);
    }

    public Optional<String> sole(String name) {
        List<String> values = this.all(name);
        if (values.size() > 1) {
            throw new IllegalArgumentException("record has " + values.size() + " " + name + " headers");
        }
        return values.stream().findFirst();
    }

    public Optional<String> first(String name) {
        return this.all(name).stream().findFirst();
    }

    public List<String> all(String name) {
        return this.map.getOrDefault(name, Collections.emptyList());
    }

    public Map<String, List<String>> map() {
        return this.map;
    }

    public boolean contains(String name, String value) {
        for (String rawValue : this.all(name)) {
            for (String splitValue : COMMA_SEPARATOR.split(rawValue)) {
                if (!splitValue.equalsIgnoreCase(value)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.map.toString();
    }

    public static MessageHeaders parse(ReadableByteChannel channel) throws IOException {
        WarcParser parser = WarcParser.newWarcFieldsParser();
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        while (!parser.isFinished()) {
            int n = channel.read(buffer);
            if (n < 0) {
                parser.parse(ByteBuffer.wrap("\r\n\r\n".getBytes(StandardCharsets.US_ASCII)));
                break;
            }
            buffer.flip();
            parser.parse(buffer);
            if (parser.isError()) {
                throw new ParsingException("invalid WARC fields");
            }
            buffer.compact();
        }
        return parser.headers();
    }

    private static boolean[] initIllegalLookup() {
        int i;
        boolean[] illegal = new boolean[256];
        String separators = "()<>@,;:\\\"/[]?={} \t";
        for (i = 0; i < separators.length(); ++i) {
            illegal[separators.charAt((int)i)] = true;
        }
        for (i = 0; i < 32; ++i) {
            illegal[i] = true;
        }
        return illegal;
    }

    static String format(Map<String, List<String>> map) {
        StringBuilder out = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                out.append(name).append(": ").append(value).append("\r\n");
            }
        }
        return out.toString();
    }

    public void appendTo(Appendable appendable) throws IOException {
        for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                appendable.append(name).append(": ").append(value).append("\r\n");
            }
        }
    }
}

