/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.calendar6;

import com.github.openjson.JSONObject;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.jquery.ui.calendar6.CalendarView;
import org.wicketstuff.jquery.ui.calendar6.DateTimeDelta;
import org.wicketstuff.jquery.ui.calendar6.ICalendarListener;
import org.wicketstuff.jquery.ui.calendar6.settings.CalendarLibrarySettings;

public class CalendarBehavior
extends Behavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "fullCalendar";
    private final Options options;
    private final String selector;
    private final ICalendarListener listener;
    private JQueryAjaxBehavior onSelectAjaxBehavior;
    private JQueryAjaxBehavior onDateClickAjaxBehavior;
    private JQueryAjaxBehavior onEventClickAjaxBehavior;
    private JQueryAjaxBehavior onEventDropAjaxBehavior;
    private JQueryAjaxBehavior onEventResizeAjaxBehavior;
    private JQueryAjaxBehavior onObjectDropAjaxBehavior;
    private JQueryAjaxBehavior onViewDidMountAjaxBehavior;

    public CalendarBehavior(String selector, ICalendarListener listener) {
        this(selector, new Options(), listener);
    }

    public CalendarBehavior(String selector, Options options, ICalendarListener listener) {
        this.selector = (String)Args.notNull((Object)selector, (String)"selector");
        this.options = (Options)Args.notNull((Object)options, (String)"options");
        this.listener = (ICalendarListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isSelectable()) {
            this.onSelectAjaxBehavior = this.newOnSelectAjaxBehavior(this);
            component.add(new Behavior[]{this.onSelectAjaxBehavior});
        }
        if (this.listener.isDateClickEnabled()) {
            this.onDateClickAjaxBehavior = this.newOnDateClickAjaxBehavior(this);
            component.add(new Behavior[]{this.onDateClickAjaxBehavior});
        }
        if (this.listener.isEventClickEnabled()) {
            this.onEventClickAjaxBehavior = this.newOnEventClickAjaxBehavior(this);
            component.add(new Behavior[]{this.onEventClickAjaxBehavior});
        }
        if (this.listener.isEventDropEnabled()) {
            this.onEventDropAjaxBehavior = this.newOnEventDropAjaxBehavior(this, this.listener.getEventDropPrecondition());
            component.add(new Behavior[]{this.onEventDropAjaxBehavior});
        }
        if (this.listener.isEventResizeEnabled()) {
            this.onEventResizeAjaxBehavior = this.newOnEventResizeAjaxBehavior(this, this.listener.getEventResizePrecondition());
            component.add(new Behavior[]{this.onEventResizeAjaxBehavior});
        }
        if (this.listener.isObjectDropEnabled()) {
            this.onObjectDropAjaxBehavior = this.newOnObjectDropAjaxBehavior(this);
            component.add(new Behavior[]{this.onObjectDropAjaxBehavior});
        }
        if (this.listener.isViewDidMountEnabled()) {
            this.onViewDidMountAjaxBehavior = this.newViewDidMountAjaxBehavior(this);
            component.add(new Behavior[]{this.onViewDidMountAjaxBehavior});
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        CalendarLibrarySettings settings = CalendarLibrarySettings.get();
        if (settings.getJavaScriptReference() != null) {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)settings.getJavaScriptReference())));
        }
        if (settings.getGCalJavaScriptReference() != null) {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)settings.getGCalJavaScriptReference())));
        }
        if (settings.getLocalesJavaScriptReference() != null) {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)settings.getLocalesJavaScriptReference())));
        }
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)"window.WicketStuff = window.WicketStuff || {};\nwindow.WicketStuff.JqueryUI = window.WicketStuff.JqueryUI || {};\nwindow.WicketStuff.JqueryUI.toLocalDateTime = function (d) {\n\tlet pad = (n) => ('' + n).padStart(2, '0');\n\treturn d.getFullYear() + '-' + pad(d.getMonth() + 1) + '-' + pad(d.getDate())\n\t\t+ 'T' + pad(d.getHours()) + ':' + pad(d.getMinutes()) + ':' + pad(d.getSeconds()) + 'Z';\n};", (String)"jquery-ui-date-format-helper")));
        StringBuilder builder = new StringBuilder();
        builder.append("const el = document.querySelector('").append(this.selector).append("');\n").append("el.calendar = new FullCalendar.Calendar(el, ").append(this.options).append(");\n").append("el.calendar.render();\n");
        builder.append("jQuery(\"<img id='calendar-indicator' src='").append(RequestCycleUtils.getAjaxIndicatorUrl()).append("' />\").appendTo('.fc-header-center');\n").append("jQuery(document).ajaxStart(function() { jQuery('#calendar-indicator').show(); });\n").append("jQuery(document).ajaxStop(function() { jQuery('#calendar-indicator').hide(); });\n");
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)builder));
    }

    protected boolean isEditable() {
        return this.onDateClickAjaxBehavior != null || this.onEventClickAjaxBehavior != null;
    }

    public <T> T getOption(String key) {
        return (T)this.options.get(key);
    }

    public CalendarBehavior setOption(String key, Object value) {
        this.options.set(key, value);
        return this;
    }

    public void onConfigure(Component component) {
        this.setOption("editable", this.isEditable());
        this.setOption("selectable", this.listener.isSelectable());
        this.setOption("selectHelper", this.listener.isSelectable());
        this.setOption("disableDragging", !this.listener.isEventDropEnabled());
        this.setOption("disableResizing", !this.listener.isEventResizeEnabled());
        this.setOption("droppable", this.listener.isObjectDropEnabled());
        if (this.onSelectAjaxBehavior != null) {
            this.setOption("select", this.onSelectAjaxBehavior.getCallbackFunction());
        }
        if (this.onDateClickAjaxBehavior != null) {
            this.setOption("dateClick", this.onDateClickAjaxBehavior.getCallbackFunction());
        }
        if (this.onEventClickAjaxBehavior != null) {
            this.setOption("eventClick", this.onEventClickAjaxBehavior.getCallbackFunction());
        }
        if (this.onEventDropAjaxBehavior != null) {
            this.setOption("eventDrop", this.onEventDropAjaxBehavior.getCallbackFunction());
        }
        if (this.onEventResizeAjaxBehavior != null) {
            this.setOption("eventResize", this.onEventResizeAjaxBehavior.getCallbackFunction());
        }
        if (this.onObjectDropAjaxBehavior != null) {
            this.setOption("drop", this.onObjectDropAjaxBehavior.getCallbackFunction());
        }
        if (this.onViewDidMountAjaxBehavior != null) {
            this.setOption("viewDidMount", this.onViewDidMountAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof SelectEvent) {
            SelectEvent selectEvent = (SelectEvent)event;
            this.listener.onSelect(target, selectEvent.getView(), selectEvent.getStart(), selectEvent.getEnd(), selectEvent.isAllDay());
        } else if (event instanceof DateClickEvent) {
            DateClickEvent dayClickEvent = (DateClickEvent)event;
            this.listener.onDateClick(target, dayClickEvent.getView(), dayClickEvent.getDate(), dayClickEvent.isAllDay());
        } else if (event instanceof ClickEvent) {
            ClickEvent clickEvent = (ClickEvent)event;
            this.listener.onEventClick(target, clickEvent.getView(), clickEvent.getEventId());
        } else if (event instanceof DropEvent) {
            DropEvent dropEvent = (DropEvent)event;
            this.listener.onEventDrop(target, dropEvent.getEventId(), dropEvent.getDelta(), dropEvent.isAllDay());
        } else if (event instanceof ResizeEvent) {
            ResizeEvent resizeEvent = (ResizeEvent)event;
            this.listener.onEventResize(target, resizeEvent.getEventId(), resizeEvent.getDelta());
        } else if (event instanceof ObjectDropEvent) {
            ObjectDropEvent dropEvent = (ObjectDropEvent)event;
            this.listener.onObjectDrop(target, dropEvent.getTitle(), dropEvent.getDate(), dropEvent.isAllDay());
        } else if (event instanceof ViewDidMountEvent) {
            ViewDidMountEvent renderEvent = (ViewDidMountEvent)event;
            this.listener.onViewDidMount(target, renderEvent.getView(), renderEvent.getStart(), renderEvent.getEnd());
        }
    }

    protected JQueryAjaxBehavior newOnSelectAjaxBehavior(IJQueryAjaxAware source) {
        return new OnSelectAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnDateClickAjaxBehavior(IJQueryAjaxAware source) {
        return new OnDateClickAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnEventClickAjaxBehavior(IJQueryAjaxAware source) {
        return new OnEventClickAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnEventDropAjaxBehavior(IJQueryAjaxAware source, CharSequence precondition) {
        return new OnEventDropAjaxBehavior(source, precondition);
    }

    protected JQueryAjaxBehavior newOnEventResizeAjaxBehavior(IJQueryAjaxAware source, CharSequence precondition) {
        return new OnEventResizeAjaxBehavior(source, precondition);
    }

    protected JQueryAjaxBehavior newOnObjectDropAjaxBehavior(IJQueryAjaxAware source) {
        return new OnObjectDropAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newViewDidMountAjaxBehavior(IJQueryAjaxAware source) {
        return new OnViewDidMountAjaxBehavior(source);
    }

    protected static LocalDate parseDate(String dateStr) {
        return LocalDate.parse(dateStr, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    protected static LocalDateTime parse(String dateStr, boolean allDay) {
        return allDay ? CalendarBehavior.parseDate(dateStr).atStartOfDay() : LocalDateTime.parse(dateStr, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    protected static class SelectEvent
    extends JQueryEvent {
        private final LocalDateTime start;
        private final LocalDateTime end;
        private final boolean isAllDay = RequestCycleUtils.getQueryParameterValue((String)"allDay").toBoolean();
        private final String viewName;

        public SelectEvent() {
            String start = RequestCycleUtils.getQueryParameterValue((String)"startDate").toString();
            this.start = CalendarBehavior.parse(start, this.isAllDay);
            String end = RequestCycleUtils.getQueryParameterValue((String)"endDate").toString();
            this.end = CalendarBehavior.parse(end, this.isAllDay);
            this.viewName = RequestCycleUtils.getQueryParameterValue((String)"viewName").toString();
        }

        public LocalDateTime getStart() {
            return this.start;
        }

        public LocalDateTime getEnd() {
            return this.end;
        }

        public boolean isAllDay() {
            return this.isAllDay;
        }

        public CalendarView getView() {
            return CalendarView.get(this.viewName);
        }
    }

    protected static class DateClickEvent
    extends JQueryEvent {
        private final LocalDateTime day;
        private final boolean isAllDay = RequestCycleUtils.getQueryParameterValue((String)"allDay").toBoolean();
        private final String viewName;

        public DateClickEvent() {
            String date = RequestCycleUtils.getQueryParameterValue((String)"date").toString();
            this.day = CalendarBehavior.parse(date, this.isAllDay);
            this.viewName = RequestCycleUtils.getQueryParameterValue((String)"viewName").toString();
        }

        public LocalDateTime getDate() {
            return this.day;
        }

        public boolean isAllDay() {
            return this.isAllDay;
        }

        public CalendarView getView() {
            return CalendarView.get(this.viewName);
        }
    }

    protected static class ClickEvent
    extends JQueryEvent {
        private final String eventId = RequestCycleUtils.getQueryParameterValue((String)"eventId").toString();
        private final String viewName = RequestCycleUtils.getQueryParameterValue((String)"viewName").toString();

        public String getEventId() {
            return this.eventId;
        }

        public CalendarView getView() {
            return CalendarView.get(this.viewName);
        }
    }

    protected static class DropEvent
    extends DeltaEvent {
        private final boolean isAllDay = RequestCycleUtils.getQueryParameterValue((String)"allDay").toBoolean();

        public boolean isAllDay() {
            return this.isAllDay;
        }
    }

    protected static class ResizeEvent
    extends DeltaEvent {
        protected ResizeEvent() {
        }
    }

    protected static class ObjectDropEvent
    extends JQueryEvent {
        private final LocalDateTime day;
        private final String title;
        private final boolean isAllDay = RequestCycleUtils.getQueryParameterValue((String)"allDay").toBoolean();

        public ObjectDropEvent() {
            String date = RequestCycleUtils.getQueryParameterValue((String)"date").toString();
            this.day = CalendarBehavior.parse(date, this.isAllDay);
            this.title = RequestCycleUtils.getQueryParameterValue((String)"title").toString();
        }

        public LocalDateTime getDate() {
            return this.day;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isAllDay() {
            return this.isAllDay;
        }
    }

    protected static class ViewDidMountEvent
    extends JQueryEvent {
        private final LocalDate start;
        private final LocalDate end;
        private final CalendarView viewName;

        public ViewDidMountEvent() {
            String start = RequestCycleUtils.getQueryParameterValue((String)"startDate").toString();
            this.start = CalendarBehavior.parseDate(start);
            String end = RequestCycleUtils.getQueryParameterValue((String)"endDate").toString();
            this.end = CalendarBehavior.parseDate(end);
            this.viewName = CalendarView.get(RequestCycleUtils.getQueryParameterValue((String)"viewName").toString());
        }

        public LocalDate getStart() {
            return this.start;
        }

        public LocalDate getEnd() {
            return this.end;
        }

        public CalendarView getView() {
            return this.viewName;
        }
    }

    protected static class OnSelectAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnSelectAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"info"), CallbackParameter.resolved((String)"startDate", (String)"WicketStuff.JqueryUI.toLocalDateTime(info.start)"), CallbackParameter.resolved((String)"endDate", (String)"WicketStuff.JqueryUI.toLocalDateTime(info.end)"), CallbackParameter.resolved((String)"allDay", (String)"info.allDay"), CallbackParameter.resolved((String)"viewName", (String)"info.view.type")};
        }

        protected JQueryEvent newEvent() {
            return new SelectEvent();
        }
    }

    protected static class OnDateClickAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnDateClickAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"info"), CallbackParameter.resolved((String)"date", (String)"WicketStuff.JqueryUI.toLocalDateTime(info.date)"), CallbackParameter.resolved((String)"allDay", (String)"info.allDay"), CallbackParameter.resolved((String)"viewName", (String)"info.view.type")};
        }

        protected JQueryEvent newEvent() {
            return new DateClickEvent();
        }
    }

    protected static class OnEventClickAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnEventClickAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"info"), CallbackParameter.resolved((String)"eventId", (String)"info.event.id"), CallbackParameter.resolved((String)"viewName", (String)"info.view.type")};
        }

        protected JQueryEvent newEvent() {
            return new ClickEvent();
        }
    }

    protected static class OnEventDropAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final CharSequence precondition;

        public OnEventDropAjaxBehavior(IJQueryAjaxAware source, CharSequence precondition) {
            super(source);
            this.precondition = precondition;
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            if (!Strings.isEmpty((CharSequence)this.precondition)) {
                AjaxCallListener ajaxCallListener = new AjaxCallListener();
                ajaxCallListener.onPrecondition(this.precondition);
                attributes.getAjaxCallListeners().add(ajaxCallListener);
            }
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"info"), CallbackParameter.resolved((String)"delta", (String)"JSON.stringify(info.delta)"), CallbackParameter.resolved((String)"allDay", (String)"info.event.allDay"), CallbackParameter.resolved((String)"eventId", (String)"info.event.id")};
        }

        protected JQueryEvent newEvent() {
            return new DropEvent();
        }
    }

    protected static class OnEventResizeAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final CharSequence precondition;

        public OnEventResizeAjaxBehavior(IJQueryAjaxAware source, CharSequence precondition) {
            super(source);
            this.precondition = precondition;
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            if (!Strings.isEmpty((CharSequence)this.precondition)) {
                AjaxCallListener ajaxCallListener = new AjaxCallListener();
                ajaxCallListener.onPrecondition(this.precondition);
                attributes.getAjaxCallListeners().add(ajaxCallListener);
            }
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"info"), CallbackParameter.resolved((String)"delta", (String)"JSON.stringify(info.endDelta)"), CallbackParameter.resolved((String)"allDay", (String)"info.event.allDay"), CallbackParameter.resolved((String)"eventId", (String)"info.event.id")};
        }

        protected JQueryEvent newEvent() {
            return new ResizeEvent();
        }
    }

    protected static class OnObjectDropAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnObjectDropAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"info"), CallbackParameter.resolved((String)"date", (String)"WicketStuff.JqueryUI.toLocalDateTime(info.date)"), CallbackParameter.resolved((String)"allDay", (String)"info.allDay"), CallbackParameter.resolved((String)"title", (String)"info.draggedEl.getAttribute('data-title')")};
        }

        protected JQueryEvent newEvent() {
            return new ObjectDropEvent();
        }
    }

    protected static class OnViewDidMountAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnViewDidMountAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"info"), CallbackParameter.resolved((String)"viewName", (String)"info.view.type"), CallbackParameter.resolved((String)"startDate", (String)"WicketStuff.JqueryUI.toLocalDateTime(info.view.activeStart)"), CallbackParameter.resolved((String)"endDate", (String)"WicketStuff.JqueryUI.toLocalDateTime(info.view.activeEnd)")};
        }

        protected JQueryEvent newEvent() {
            return new ViewDidMountEvent();
        }
    }

    protected static abstract class DeltaEvent
    extends JQueryEvent {
        private final String eventId = RequestCycleUtils.getQueryParameterValue((String)"eventId").toString();
        private final DateTimeDelta delta;

        public DeltaEvent() {
            JSONObject deltaObj = new JSONObject(RequestCycleUtils.getQueryParameterValue((String)"delta").toString());
            this.delta = new DateTimeDelta(deltaObj.getInt("years"), deltaObj.getInt("months"), deltaObj.getInt("days"), deltaObj.getInt("milliseconds"));
        }

        public String getEventId() {
            return this.eventId;
        }

        public DateTimeDelta getDelta() {
            return this.delta;
        }
    }
}

