/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.complex;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.Attachment;
import com.healthmarketscience.jackcess.complex.AttachmentColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.complex.ComplexColumnInfoImpl;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class AttachmentColumnInfoImpl
extends ComplexColumnInfoImpl<Attachment>
implements AttachmentColumnInfo {
    private static final Set<String> COMPRESSED_FORMATS = new HashSet<String>(Arrays.asList("jpg", "zip", "gz", "bz2", "z", "7z", "cab", "rar", "mp3", "mpg"));
    private static final String FILE_NAME_COL_NAME = "FileName";
    private static final String FILE_TYPE_COL_NAME = "FileType";
    private static final int DATA_TYPE_RAW = 0;
    private static final int DATA_TYPE_COMPRESSED = 1;
    private static final int UNKNOWN_HEADER_VAL = 1;
    private static final int WRAPPER_HEADER_SIZE = 8;
    private static final int CONTENT_HEADER_SIZE = 12;
    private final Column _fileUrlCol;
    private final Column _fileNameCol;
    private final Column _fileTypeCol;
    private final Column _fileDataCol;
    private final Column _fileTimeStampCol;
    private final Column _fileFlagsCol;

    public AttachmentColumnInfoImpl(Column column, int complexId, Table typeObjTable, Table flatTable) throws IOException {
        super(column, complexId, typeObjTable, flatTable);
        Column fileUrlCol = null;
        Column fileNameCol = null;
        Column fileTypeCol = null;
        Column fileDataCol = null;
        Column fileTimeStampCol = null;
        Column fileFlagsCol = null;
        for (Column col : this.getTypeColumns()) {
            switch (col.getType()) {
                case TEXT: {
                    if (FILE_NAME_COL_NAME.equalsIgnoreCase(col.getName())) {
                        fileNameCol = col;
                        break;
                    }
                    if (FILE_TYPE_COL_NAME.equalsIgnoreCase(col.getName())) {
                        fileTypeCol = col;
                        break;
                    }
                    if (fileNameCol == null) {
                        fileNameCol = col;
                        break;
                    }
                    if (fileTypeCol != null) break;
                    fileTypeCol = col;
                    break;
                }
                case LONG: {
                    fileFlagsCol = col;
                    break;
                }
                case SHORT_DATE_TIME: {
                    fileTimeStampCol = col;
                    break;
                }
                case OLE: {
                    fileDataCol = col;
                    break;
                }
                case MEMO: {
                    fileUrlCol = col;
                    break;
                }
            }
        }
        this._fileUrlCol = fileUrlCol;
        this._fileNameCol = fileNameCol;
        this._fileTypeCol = fileTypeCol;
        this._fileDataCol = fileDataCol;
        this._fileTimeStampCol = fileTimeStampCol;
        this._fileFlagsCol = fileFlagsCol;
    }

    public Column getFileUrlColumn() {
        return this._fileUrlCol;
    }

    public Column getFileNameColumn() {
        return this._fileNameCol;
    }

    public Column getFileTypeColumn() {
        return this._fileTypeCol;
    }

    public Column getFileDataColumn() {
        return this._fileDataCol;
    }

    public Column getFileTimeStampColumn() {
        return this._fileTimeStampCol;
    }

    public Column getFileFlagsColumn() {
        return this._fileFlagsCol;
    }

    @Override
    public ComplexDataType getType() {
        return ComplexDataType.ATTACHMENT;
    }

    @Override
    protected AttachmentImpl toValue(ComplexValueForeignKey complexValueFk, Row rawValue) {
        ComplexColumnInfoImpl.ComplexValueIdImpl id = this.getValueId(rawValue);
        String url = (String)this.getFileUrlColumn().getRowValue(rawValue);
        String name = (String)this.getFileNameColumn().getRowValue(rawValue);
        String type = (String)this.getFileTypeColumn().getRowValue(rawValue);
        Integer flags = (Integer)this.getFileFlagsColumn().getRowValue(rawValue);
        Object ts = this.getFileTimeStampColumn().getRowValue(rawValue);
        byte[] data = (byte[])this.getFileDataColumn().getRowValue(rawValue);
        return new AttachmentImpl(id, complexValueFk, url, name, type, null, ts, flags, data);
    }

    @Override
    protected Object[] asRow(Object[] row, Attachment attachment) throws IOException {
        super.asRow(row, attachment);
        this.getFileUrlColumn().setRowValue(row, (Object)attachment.getFileUrl());
        this.getFileNameColumn().setRowValue(row, (Object)attachment.getFileName());
        this.getFileTypeColumn().setRowValue(row, (Object)attachment.getFileType());
        this.getFileFlagsColumn().setRowValue(row, (Object)attachment.getFileFlags());
        this.getFileTimeStampColumn().setRowValue(row, attachment.getFileTimeStampObject());
        this.getFileDataColumn().setRowValue(row, (Object)attachment.getEncodedFileData());
        return row;
    }

    public static Attachment newAttachment(byte[] data) {
        return AttachmentColumnInfoImpl.newAttachment(INVALID_FK, data);
    }

    public static Attachment newAttachment(ComplexValueForeignKey complexValueFk, byte[] data) {
        return AttachmentColumnInfoImpl.newAttachment(complexValueFk, null, null, null, data, null, null);
    }

    public static Attachment newAttachment(String url, String name, String type, byte[] data, Object timeStamp, Integer flags) {
        return AttachmentColumnInfoImpl.newAttachment(INVALID_FK, url, name, type, data, timeStamp, flags);
    }

    public static Attachment newAttachment(ComplexValueForeignKey complexValueFk, String url, String name, String type, byte[] data, Object timeStamp, Integer flags) {
        return new AttachmentImpl(INVALID_ID, complexValueFk, url, name, type, data, timeStamp, flags, null);
    }

    public static Attachment newEncodedAttachment(byte[] encodedData) {
        return AttachmentColumnInfoImpl.newEncodedAttachment(INVALID_FK, encodedData);
    }

    public static Attachment newEncodedAttachment(ComplexValueForeignKey complexValueFk, byte[] encodedData) {
        return AttachmentColumnInfoImpl.newEncodedAttachment(complexValueFk, null, null, null, encodedData, null, null);
    }

    public static Attachment newEncodedAttachment(String url, String name, String type, byte[] encodedData, Object timeStamp, Integer flags) {
        return AttachmentColumnInfoImpl.newEncodedAttachment(INVALID_FK, url, name, type, encodedData, timeStamp, flags);
    }

    public static Attachment newEncodedAttachment(ComplexValueForeignKey complexValueFk, String url, String name, String type, byte[] encodedData, Object timeStamp, Integer flags) {
        return new AttachmentImpl(INVALID_ID, complexValueFk, url, name, type, null, timeStamp, flags, encodedData);
    }

    private static class AttachmentImpl
    extends ComplexColumnInfoImpl.ComplexValueImpl
    implements Attachment {
        private String _url;
        private String _name;
        private String _type;
        private byte[] _data;
        private Object _timeStamp;
        private Integer _flags;
        private byte[] _encodedData;

        private AttachmentImpl(ComplexValue.Id id, ComplexValueForeignKey complexValueFk, String url, String name, String type, byte[] data, Object timeStamp, Integer flags, byte[] encodedData) {
            super(id, complexValueFk);
            this._url = url;
            this._name = name;
            this._type = type;
            this._data = data;
            this._timeStamp = timeStamp;
            this._flags = flags;
            this._encodedData = encodedData;
        }

        @Override
        public byte[] getFileData() throws IOException {
            if (this._data == null && this._encodedData != null) {
                this._data = this.decodeData();
            }
            return this._data;
        }

        @Override
        public void setFileData(byte[] data) {
            this._data = data;
            this._encodedData = null;
        }

        @Override
        public byte[] getEncodedFileData() throws IOException {
            if (this._encodedData == null && this._data != null) {
                this._encodedData = this.encodeData();
            }
            return this._encodedData;
        }

        @Override
        public void setEncodedFileData(byte[] data) {
            this._encodedData = data;
            this._data = null;
        }

        @Override
        public String getFileName() {
            return this._name;
        }

        @Override
        public void setFileName(String fileName) {
            this._name = fileName;
        }

        @Override
        public String getFileUrl() {
            return this._url;
        }

        @Override
        public void setFileUrl(String fileUrl) {
            this._url = fileUrl;
        }

        @Override
        public String getFileType() {
            return this._type;
        }

        @Override
        public void setFileType(String fileType) {
            this._type = fileType;
        }

        @Override
        public Date getFileTimeStamp() {
            return (Date)this._timeStamp;
        }

        @Override
        public void setFileTimeStamp(Date fileTimeStamp) {
            this._timeStamp = fileTimeStamp;
        }

        @Override
        public LocalDateTime getFileLocalTimeStamp() {
            return (LocalDateTime)this._timeStamp;
        }

        @Override
        public void setFileLocalTimeStamp(LocalDateTime fileTimeStamp) {
            this._timeStamp = fileTimeStamp;
        }

        @Override
        public Object getFileTimeStampObject() {
            return this._timeStamp;
        }

        @Override
        public Integer getFileFlags() {
            return this._flags;
        }

        @Override
        public void setFileFlags(Integer fileFlags) {
            this._flags = fileFlags;
        }

        @Override
        public void update() throws IOException {
            this.getComplexValueForeignKey().updateAttachment(this);
        }

        @Override
        public void delete() throws IOException {
            this.getComplexValueForeignKey().deleteAttachment(this);
        }

        public String toString() {
            String dataStr = null;
            try {
                dataStr = ByteUtil.toHexString(this.getFileData());
            }
            catch (IOException e) {
                dataStr = e.toString();
            }
            return "Attachment(" + this.getComplexValueForeignKey() + "," + this.getId() + ") " + this.getFileUrl() + ", " + this.getFileName() + ", " + this.getFileType() + ", " + this.getFileTimeStampObject() + ", " + this.getFileFlags() + ", " + dataStr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] decodeData() throws IOException {
            byte[] byArray;
            if (this._encodedData.length < 8) {
                throw new IOException("Unknown encoded attachment data format");
            }
            ByteBuffer bb = PageChannel.wrap(this._encodedData);
            int typeFlag = bb.getInt();
            int dataLen = bb.getInt();
            DataInputStream contentStream = null;
            try {
                InputStream bin = new ByteArrayInputStream(this._encodedData, 8, this._encodedData.length - 8);
                if (typeFlag != 0) {
                    if (typeFlag == 1) {
                        bin = new InflaterInputStream(bin);
                    } else {
                        throw new IOException("Unknown encoded attachment data type " + typeFlag);
                    }
                }
                contentStream = new DataInputStream(bin);
                byte[] tmpBytes = new byte[4];
                contentStream.readFully(tmpBytes);
                int headerLen = PageChannel.wrap(tmpBytes).getInt();
                ByteUtil.skipFully(contentStream, headerLen - 4);
                tmpBytes = new byte[dataLen - headerLen];
                contentStream.readFully(tmpBytes);
                byArray = tmpBytes;
            }
            catch (Throwable throwable) {
                ByteUtil.closeQuietly(contentStream);
                throw throwable;
            }
            ByteUtil.closeQuietly(contentStream);
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] encodeData() throws IOException {
            String type = this._type != null ? this._type.toLowerCase() : "";
            boolean shouldCompress = !COMPRESSED_FORMATS.contains(type);
            type = type + '\u0000';
            ByteBuffer typeBytes = ColumnImpl.encodeUncompressedText(type, JetFormat.VERSION_12.CHARSET);
            int headerLen = typeBytes.remaining() + 12;
            int dataLen = this._data.length;
            ByteUtil.ByteStream dataStream = new ByteUtil.ByteStream(8 + headerLen + dataLen);
            ByteBuffer bb = PageChannel.wrap(dataStream.getBytes());
            bb.putInt(shouldCompress ? 1 : 0);
            bb.putInt(dataLen + headerLen);
            dataStream.skip(8);
            OutputStream contentStream = dataStream;
            Deflater deflater = null;
            try {
                if (shouldCompress) {
                    deflater = new Deflater(3);
                    contentStream = new DeflaterOutputStream(contentStream, deflater);
                }
                byte[] tmpBytes = new byte[12];
                PageChannel.wrap(tmpBytes).putInt(headerLen).putInt(1).putInt(type.length());
                contentStream.write(tmpBytes);
                contentStream.write(typeBytes.array(), 0, typeBytes.remaining());
                contentStream.write(this._data);
                contentStream.close();
                contentStream = null;
                byte[] byArray = dataStream.toByteArray();
                return byArray;
            }
            finally {
                ByteUtil.closeQuietly(contentStream);
                if (deflater != null) {
                    deflater.end();
                }
            }
        }
    }
}

