/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jqplot.lib.chart;

import java.util.Arrays;
import java.util.Collection;
import org.wicketstuff.jqplot.lib.ChartConfiguration;
import org.wicketstuff.jqplot.lib.JqPlotResources;
import org.wicketstuff.jqplot.lib.chart.AbstractChart;
import org.wicketstuff.jqplot.lib.data.BarData;
import org.wicketstuff.jqplot.lib.elements.Title;
import org.wicketstuff.jqplot.lib.metadata.JqPlotPlugin;

@JqPlotPlugin(values={JqPlotResources.CategoryAxisRenderer, JqPlotResources.BarRenderer, JqPlotResources.PointLabels})
public class BarChart<T extends Number>
extends AbstractChart<BarData<T>, Long> {
    private static final long serialVersionUID = 3650210485517566138L;
    private final ChartConfiguration<Long> chartConfig;
    private BarData<T> barData = new BarData();

    public BarChart() {
        this(null, null, null);
    }

    public BarChart(String title) {
        this(title, null, null);
    }

    public BarChart(String title, String labelX, String labelY) {
        this.chartConfig = new ChartConfiguration();
        this.chartConfig.setTitle(new Title(title)).seriesDefaultsInstance().pointLabelsInstance();
        this.chartConfig.setLabelX(labelX).setLabelY(labelY).seriesDefaultsInstance().setRenderer(JqPlotResources.BarRenderer).setFill(true);
        this.chartConfig.axesInstance().xAxisInstance().setRenderer(JqPlotResources.CategoryAxisRenderer).rendererOptionsInstance();
    }

    public void addValue(Collection<T> value) {
        this.barData.addValue(value);
    }

    public void addValues(Collection<T> ... value) {
        this.barData.addValues(value);
    }

    public void addValues(T ... values) {
        this.barData.addValues(new Collection[]{Arrays.asList(values)});
    }

    @Override
    public BarData<T> getChartData() {
        return this.barData;
    }

    @Override
    public ChartConfiguration<Long> getChartConfiguration() {
        return this.chartConfig;
    }
}

