/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.UserFunctionResolvable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.IndexedVariableEvaluator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.LearningEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.elab.SharedAppendEvaluator;
import net.sf.saxon.expr.elab.StreamingArgumentEvaluator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.UnboundFunctionLibrary;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class UserFunctionCall
extends FunctionCall
implements UserFunctionResolvable,
ComponentInvocation,
ContextOriginator {
    private SequenceType staticType;
    private UserFunction function;
    private int bindingSlot = -1;
    private int tailCall = 0;
    private StructuredQName name;
    private boolean beingInlined = false;
    private SequenceEvaluator[] argumentEvaluators = null;
    private UnboundFunctionLibrary.UnboundFunctionCallDetails unboundCallDetails;
    public static final int NOT_TAIL_CALL = 0;
    public static final int FOREIGN_TAIL_CALL = 1;
    public static final int SELF_TAIL_CALL = 2;
    private static final int UNHANDLED_DEPENDENCIES = 877;

    public boolean isBeingInlined() {
        return this.beingInlined;
    }

    public void setBeingInlined(boolean beingInlined) {
        this.beingInlined = beingInlined;
    }

    public UserFunctionCall() {
    }

    public UserFunctionCall(UnboundFunctionLibrary.UnboundFunctionCallDetails details) {
        this.unboundCallDetails = details;
    }

    public void copyFrom(UserFunctionCall ufc2) {
        this.staticType = ufc2.staticType;
        this.function = ufc2.function;
        this.bindingSlot = ufc2.bindingSlot;
        this.tailCall = ufc2.tailCall;
        this.name = ufc2.name;
        this.beingInlined = false;
        this.argumentEvaluators = ufc2.argumentEvaluators;
        this.unboundCallDetails = null;
    }

    public final void setFunctionName(StructuredQName name) {
        this.name = name;
    }

    public void setStaticType(SequenceType type) {
        this.staticType = type;
    }

    @Override
    public void setFunction(UserFunction compiledFunction) {
        this.function = compiledFunction;
    }

    @Override
    public void setBindingSlot(int slot) {
        this.bindingSlot = slot;
    }

    @Override
    public int getBindingSlot() {
        return this.bindingSlot;
    }

    public UserFunction getFunction() {
        return this.function;
    }

    @Override
    public Component getFixedTarget() {
        Visibility v = this.function.getDeclaringComponent().getVisibility();
        if (v == Visibility.PRIVATE || v == Visibility.FINAL) {
            return this.function.getDeclaringComponent();
        }
        return null;
    }

    public UnboundFunctionLibrary.UnboundFunctionCallDetails getUnboundCallDetails() {
        return this.unboundCallDetails;
    }

    public boolean isTailCall() {
        return this.tailCall != 0;
    }

    public boolean isRecursiveTailCall() {
        return this.tailCall == 2;
    }

    @Override
    public final StructuredQName getFunctionName() {
        if (this.name == null) {
            return this.function.getFunctionName();
        }
        return this.name;
    }

    @Override
    public SymbolicName getSymbolicName() {
        return new SymbolicName.F(this.getFunctionName(), this.getArity());
    }

    public Component getTarget() {
        return this.function.getDeclaringComponent();
    }

    public void allocateArgumentEvaluators() {
        this.argumentEvaluators = new SequenceEvaluator[this.getArity()];
        UserFunction target = this.getFunction();
        int i = 0;
        for (Operand o : this.operands()) {
            Expression arg = o.getChildExpression();
            if (arg instanceof ErrorExpression && ((ErrorExpression)arg).getErrorCodeLocalPart().equals("UseDefault")) {
                arg = target.getDefaultValueExpression(i).copy(new RebindingMap());
                o.setChildExpression(arg);
            }
            if (i == 0 && target.getDeclaredStreamability().isConsuming()) {
                this.argumentEvaluators[i] = new StreamingArgumentEvaluator(arg);
            } else if (target.getParameterDefinitions()[i].isIndexedVariable()) {
                PullEvaluator argPull = arg.makeElaborator().elaborateForPull();
                this.argumentEvaluators[i] = new IndexedVariableEvaluator(argPull);
            } else {
                this.argumentEvaluators[i] = (arg.getDependencies() & 0x36D) != 0 ? arg.makeElaborator().eagerly() : (arg instanceof Block && ((Block)arg).isCandidateForSharedAppend() ? new SharedAppendEvaluator((Block)arg) : new LearningEvaluator(arg, arg.makeElaborator().lazily(true, false)));
            }
            ++i;
        }
    }

    public SequenceEvaluator[] getArgumentEvaluators() {
        return this.argumentEvaluators;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public ItemType getItemType() {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        UserFunction f = this.getFunction();
        if (f == null) {
            return UType.ANY;
        }
        return f.getResultType().getPrimaryType().getUType();
    }

    @Override
    public int getIntrinsicDependencies() {
        return 256;
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.function.isUpdating();
    }

    @Override
    protected int computeSpecialProperties() {
        if (this.function == null) {
            return super.computeSpecialProperties();
        }
        if (this.function.getBody() != null && (this.function.getDeclaredVisibility() == Visibility.PRIVATE || this.function.getDeclaredVisibility() == Visibility.FINAL)) {
            ArrayList<UserFunction> calledFunctions = new ArrayList<UserFunction>();
            ExpressionTool.gatherCalledFunctions(this.function.getBody(), calledFunctions);
            int props = calledFunctions.isEmpty() ? this.function.getBody().getSpecialProperties() : super.computeSpecialProperties();
            if (this.function.getDeterminism() != UserFunction.Determinism.PROACTIVE) {
                props |= 0x800000;
            }
            return props;
        }
        return super.computeSpecialProperties();
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        if (this.function == null) {
            throw new UnsupportedOperationException("UserFunctionCall.copy()");
        }
        UserFunctionCall ufc = new UserFunctionCall();
        ufc.setFunction(this.function);
        ufc.setStaticType(this.staticType);
        ExpressionTool.copyLocationInfo(this, ufc);
        int numArgs = this.getArity();
        Expression[] a2 = new Expression[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            a2[i] = this.getArg(i).copy(rebindings);
        }
        ufc.setArguments(a2);
        return ufc;
    }

    @Override
    protected int computeCardinality() {
        if (this.staticType == null) {
            return 57344;
        }
        return this.staticType.getCardinality();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e = super.typeCheck(visitor, contextInfo);
        if (e != this) {
            return e;
        }
        if (this.function != null) {
            this.checkFunctionCall(this.function, visitor);
            if (this.staticType == null || this.staticType == SequenceType.ANY_SEQUENCE) {
                this.staticType = this.function.getResultType();
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this && this.function != null) {
            return visitor.obtainOptimizer().tryInlineFunctionCall(this, visitor, contextItemType);
        }
        return e;
    }

    @Override
    public void resetLocalStaticProperties() {
        super.resetLocalStaticProperties();
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        this.tailCall = this.getFunctionName().equals(qName) && arity == this.getArity() ? 2 : 1;
        return this.tailCall;
    }

    @Override
    public int getImplementationMethod() {
        if (Cardinality.allowsMany(this.getCardinality())) {
            return 6;
        }
        return 1;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(c);
    }

    @Override
    public SequenceIterator iterate(XPathContext c) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(c);
    }

    private void requestTailCall(XPathContext context, Sequence[] actualArgs) throws XPathException {
        if (this.bindingSlot >= 0) {
            Component target;
            TailCallLoop.TailCallComponent info = new TailCallLoop.TailCallComponent();
            info.component = target = this.getTargetComponent(context);
            info.function = (UserFunction)target.getActor();
            if (target.isHiddenAbstractComponent()) {
                throw new XPathException("Cannot call an abstract function (" + this.name.getDisplayName() + ") with no implementation", "XTDE3052");
            }
            ((XPathContextMajor)context).requestTailCall(info, actualArgs);
        } else {
            TailCallLoop.TailCallFunction info = new TailCallLoop.TailCallFunction();
            info.function = this.function;
            ((XPathContextMajor)context).requestTailCall(info, actualArgs);
        }
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        TailCall tc = this.makeElaborator().elaborateForPush().processLeavingTail(output, context);
        UserFunctionCall.dispatchTailCall(tc);
    }

    public Component getTargetComponent(XPathContext context) {
        if (this.bindingSlot == -1) {
            return this.function.getDeclaringComponent();
        }
        return context.getTargetComponent(this.bindingSlot);
    }

    @Override
    public UserFunction getTargetFunction(XPathContext context) {
        return (UserFunction)this.getTargetComponent(context).getActor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence[] evaluateArguments(XPathContext c, boolean streamed) throws XPathException {
        int numArgs = this.getArity();
        Sequence[] actualArgs = SequenceTool.makeSequenceArray(numArgs);
        UserFunctionCall userFunctionCall = this;
        synchronized (userFunctionCall) {
            if (this.argumentEvaluators == null) {
                this.allocateArgumentEvaluators();
            }
        }
        for (int i = 0; i < numArgs; ++i) {
            SequenceEvaluator eval = this.argumentEvaluators[i];
            if (eval == null || eval instanceof StreamingArgumentEvaluator && !streamed) {
                eval = this.getArguments()[0].makeElaborator().eagerly();
            }
            actualArgs[i] = eval.evaluate(c);
        }
        return actualArgs;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("ufCall", this);
        if (this.getFunctionName() != null) {
            out.emitAttribute("name", this.getFunctionName());
            out.emitAttribute("tailCall", this.tailCall == 0 ? "false" : (this.tailCall == 2 ? "self" : "foreign"));
        }
        out.emitAttribute("bSlot", "" + this.getBindingSlot());
        for (Operand o : this.operands()) {
            o.getChildExpression().export(out);
        }
        if (this.getFunctionName() == null) {
            out.setChildRole("inline");
            this.function.getBody().export(out);
            out.endElement();
        }
        out.endElement();
    }

    @Override
    public String getExpressionName() {
        return "userFunctionCall";
    }

    @Override
    public Object getProperty(String name) {
        if (name.equals("target")) {
            return this.function;
        }
        return super.getProperty(name);
    }

    @Override
    public StructuredQName getObjectName() {
        return this.getFunctionName();
    }

    @Override
    public Elaborator getElaborator() {
        if (this.isTailCall()) {
            return new TailCallElaborator();
        }
        return new UserFunctionCallElaborator();
    }

    private static class UserFunctionCallElaborator
    extends PullElaborator {
        private UserFunctionCallElaborator() {
        }

        private void testNotAbstract(UserFunctionCall expr, Component target) throws XPathException {
            if (target.isHiddenAbstractComponent()) {
                throw new XPathException("Cannot call an abstract function (" + expr.getFunctionName().getDisplayName() + ") with no implementation", "XTDE3052");
            }
        }

        private XPathException.StackOverflow reportStackOverflow(Expression expr) {
            return new XPathException.StackOverflow("Too many nested function calls. May be due to infinite recursion", "SXLM0001", expr.getLocation());
        }

        @Override
        public PullEvaluator elaborateForPull() {
            UserFunctionCall expr = (UserFunctionCall)this.getExpression();
            if (expr.bindingSlot >= 0) {
                return context -> {
                    Component target = expr.getTargetComponent(context);
                    this.testNotAbstract(expr, target);
                    try {
                        Sequence[] actualArgs = expr.evaluateArguments(context, false);
                        UserFunction targetFunction = (UserFunction)target.getActor();
                        XPathContextMajor c2 = targetFunction.makeNewContext(context, expr);
                        c2.setCurrentComponent(target);
                        return targetFunction.call(c2, actualArgs).iterate();
                    }
                    catch (StackOverflowError err) {
                        throw this.reportStackOverflow(expr);
                    }
                };
            }
            UserFunction targetFunction = expr.getFunction();
            return context -> {
                try {
                    Sequence[] actualArgs = expr.evaluateArguments(context, false);
                    XPathContextMajor c2 = targetFunction.makeNewContext(context, expr);
                    return targetFunction.call(c2, actualArgs).iterate();
                }
                catch (StackOverflowError err) {
                    throw this.reportStackOverflow(expr);
                }
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            UserFunctionCall expr = (UserFunctionCall)this.getExpression();
            if (expr.bindingSlot >= 0) {
                return context -> {
                    Component target = expr.getTargetComponent(context);
                    this.testNotAbstract(expr, target);
                    try {
                        Sequence[] actualArgs = expr.evaluateArguments(context, false);
                        UserFunction targetFunction = (UserFunction)target.getActor();
                        XPathContextMajor c2 = targetFunction.makeNewContext(context, expr);
                        c2.setCurrentComponent(target);
                        return targetFunction.call(c2, actualArgs).head();
                    }
                    catch (StackOverflowError err) {
                        throw this.reportStackOverflow(expr);
                    }
                };
            }
            UserFunction targetFunction = expr.getFunction();
            return context -> {
                try {
                    Sequence[] actualArgs = expr.evaluateArguments(context, false);
                    XPathContextMajor c2 = targetFunction.makeNewContext(context, expr);
                    return targetFunction.call(c2, actualArgs).head();
                }
                catch (StackOverflowError err) {
                    throw this.reportStackOverflow(expr);
                }
            };
        }

        @Override
        public PushEvaluator elaborateForPush() {
            UserFunctionCall expr = (UserFunctionCall)this.getExpression();
            if (expr.isTailCall()) {
                throw new AssertionError((Object)"Not using tail call path");
            }
            if (expr.bindingSlot >= 0) {
                return (output, context) -> {
                    Component target = expr.getTargetComponent(context);
                    this.testNotAbstract(expr, target);
                    try {
                        Sequence[] actualArgs = expr.evaluateArguments(context, false);
                        UserFunction targetFunction = (UserFunction)target.getActor();
                        XPathContextMajor c2 = targetFunction.makeNewContext(context, expr);
                        c2.setCurrentComponent(target);
                        targetFunction.process(c2, actualArgs, output);
                    }
                    catch (StackOverflowError err) {
                        throw this.reportStackOverflow(expr);
                    }
                    return null;
                };
            }
            UserFunction targetFunction = expr.getFunction();
            return (output, context) -> {
                try {
                    Sequence[] actualArgs = expr.evaluateArguments(context, false);
                    XPathContextMajor c2 = targetFunction.makeNewContext(context, expr);
                    targetFunction.process(c2, actualArgs, output);
                }
                catch (StackOverflowError err) {
                    throw this.reportStackOverflow(expr);
                }
                return null;
            };
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            UserFunctionCall expr = (UserFunctionCall)this.getExpression();
            UserFunction targetFunction = expr.getFunction();
            return (context, pul) -> {
                Sequence[] actualArgs = expr.evaluateArguments(context, false);
                XPathContextMajor c2 = context.newCleanContext();
                c2.setOrigin(expr);
                targetFunction.callUpdating(actualArgs, c2, pul);
            };
        }
    }

    private static class TailCallElaborator
    extends PullElaborator {
        private TailCallElaborator() {
        }

        @Override
        public PullEvaluator elaborateForPull() {
            UserFunctionCall expr = (UserFunctionCall)this.getExpression();
            if (expr.bindingSlot >= 0) {
                return context -> {
                    Component target;
                    TailCallLoop.TailCallComponent info = new TailCallLoop.TailCallComponent();
                    info.component = target = expr.getTargetComponent(context);
                    info.function = (UserFunction)target.getActor();
                    if (target.isHiddenAbstractComponent()) {
                        throw new XPathException("Cannot call an abstract function (" + expr.getFunctionName().getDisplayName() + ") with no implementation", "XTDE3052");
                    }
                    Sequence[] actualArgs = expr.evaluateArguments(context, false);
                    ((XPathContextMajor)context).requestTailCall(info, actualArgs);
                    return EmptyIterator.getInstance();
                };
            }
            TailCallLoop.TailCallFunction info = new TailCallLoop.TailCallFunction();
            info.function = expr.getFunction();
            return context -> {
                Sequence[] actualArgs = expr.evaluateArguments(context, false);
                ((XPathContextMajor)context).requestTailCall(info, actualArgs);
                return EmptyIterator.getInstance();
            };
        }
    }
}

