/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.rewriter;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.apache.portals.applications.webcontent2.portlet.rewriter.MappingRewriterController;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RewriterController;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RewriterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingClasspathRewriterController
extends MappingRewriterController
implements RewriterController {
    protected static final Logger log = LoggerFactory.getLogger(MappingClasspathRewriterController.class);

    public MappingClasspathRewriterController(String mappingFile) throws RewriterException {
        super(mappingFile);
    }

    public MappingClasspathRewriterController(String mappingFile, Class basicRewriterClass, Class ruleBasedRewriterClass, Map<String, Class> adaptorMimeTypeClassMap) throws RewriterException {
        super(mappingFile, basicRewriterClass, ruleBasedRewriterClass, adaptorMimeTypeClassMap);
    }

    public MappingClasspathRewriterController(String mappingFile, List rewriterClasses, List adaptorClasses) throws RewriterException {
        super(mappingFile, rewriterClasses, adaptorClasses);
    }

    public MappingClasspathRewriterController(String mappingFile, String basicRewriterClassName, String rulesetRewriterClassName, String adaptorHtmlClassName, String adaptorXmlClassName) throws RewriterException {
        super(mappingFile, MappingClasspathRewriterController.toClassList(basicRewriterClassName, rulesetRewriterClassName), MappingClasspathRewriterController.toClassList(adaptorHtmlClassName, adaptorXmlClassName));
    }

    @Override
    protected Reader getReader(String resource) throws RewriterException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resource);
        if (stream != null) {
            return new InputStreamReader(stream);
        }
        throw new RewriterException("could not access rewriter classpath resource " + resource);
    }
}

