/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.rewriter;

import org.apache.portals.applications.webcontent2.portlet.rewriter.BasicRewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.MutableAttributes;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RulesetRewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Attribute;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Rule;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Ruleset;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesetRewriterImpl
extends BasicRewriter
implements RulesetRewriter {
    protected static final Logger log = LoggerFactory.getLogger(RulesetRewriterImpl.class);
    private Ruleset ruleset = null;
    private boolean removeComments = false;

    @Override
    public boolean shouldStripTag(String tagid) {
        if (null == this.ruleset) {
            return false;
        }
        Tag tag = this.ruleset.getTag(tagid.toUpperCase());
        if (null == tag) {
            return false;
        }
        return tag.getStrip();
    }

    @Override
    public boolean shouldRemoveTag(String tagid) {
        if (null == this.ruleset) {
            return false;
        }
        Tag tag = this.ruleset.getTag(tagid.toUpperCase());
        if (null == tag) {
            return false;
        }
        return tag.getRemove();
    }

    @Override
    public void setRuleset(Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    @Override
    public Ruleset getRuleset() {
        return this.ruleset;
    }

    @Override
    public boolean shouldRemoveComments() {
        if (null == this.ruleset) {
            return false;
        }
        return this.ruleset.getRemoveComments();
    }

    @Override
    public void enterConvertTagEvent(String tagid, MutableAttributes attributes) {
        if (null == this.ruleset) {
            return;
        }
        Tag tag = this.ruleset.getTag(tagid.toUpperCase());
        if (null == tag) {
            return;
        }
        for (Attribute attribute : tag.getAttributes()) {
            String rewritten;
            Rule rule;
            String name = attribute.getId();
            String value = attributes.getValue(name);
            if (value == null || null == (rule = attribute.getRule()) || !rule.shouldRewrite(value) || null == (rewritten = this.rewriteUrl(value, tag.getId(), name, attributes))) continue;
            if (rule.getSuffix() != null) {
                rewritten = rewritten.concat(rule.getSuffix());
            }
            attributes.addAttribute(name, rewritten);
            if (!rule.getPopup()) continue;
            attributes.addAttribute("TARGET", "_BLANK");
        }
    }

    public String rewriteUrl(String url, String tag, String attribute, MutableAttributes otherAttributes) {
        return this.getBaseRelativeUrl(url);
    }

    @Override
    public String enterConvertTextEvent(String tagid, String text) {
        return this.rewriteText(tagid, text);
    }
}

