/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.rewriter.html.neko;

import java.util.Stack;
import org.apache.portals.applications.webcontent2.portlet.rewriter.Rewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.html.neko.XMLAttributesWrapper;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.cyberneko.html.filters.ElementRemover;

public class CallbackElementRemover
extends ElementRemover {
    private Rewriter rewriter;
    private Stack tagStack = new Stack();

    public CallbackElementRemover(Rewriter rewriter) {
        this.rewriter = rewriter;
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (!this.tagStack.isEmpty()) {
            String tag = (String)this.tagStack.peek();
            this.processText(tag, text);
        }
        super.characters(text, augs);
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.rewriter.shouldRemoveComments()) {
            return;
        }
        super.comment(text, augs);
    }

    public void emptyElement(QName element, XMLAttributes attrs, Augmentations arg2) throws XNIException {
        String tag = element.rawname.toLowerCase();
        this.processTag(tag, attrs);
        super.emptyElement(element, attrs, arg2);
    }

    public void startElement(QName element, XMLAttributes attrs, Augmentations arg2) throws XNIException {
        String tag = element.rawname.toLowerCase();
        this.tagStack.push(tag);
        this.processTag(tag, attrs);
        super.startElement(element, attrs, arg2);
    }

    public void endElement(QName element, Augmentations arg1) throws XNIException {
        String tag = element.rawname.toLowerCase();
        if (!this.tagStack.isEmpty() && tag.equals(this.tagStack.peek())) {
            this.tagStack.pop();
        }
        super.endElement(element, arg1);
    }

    protected void processTag(String tag, XMLAttributes attrs) {
        if (this.fRemovedElements.contains(tag)) {
            return;
        }
        if (this.rewriter.shouldStripTag(tag)) {
            this.removeElement(tag);
            return;
        }
        if (this.rewriter.shouldRemoveTag(tag)) {
            return;
        }
        this.rewriter.enterConvertTagEvent(tag, new XMLAttributesWrapper(attrs));
        this.acceptElement(tag, this.getAttributeNames(attrs));
    }

    protected String[] getAttributeNames(XMLAttributes attrs) {
        int length = attrs != null ? attrs.getLength() : 0;
        String[] names = length > 0 ? new String[length] : null;
        int limit = length;
        for (int i = 0; i < limit; ++i) {
            names[i] = attrs.getQName(i);
        }
        return names;
    }

    protected void processText(String tag, XMLString text) {
        String convertedText = this.rewriter.enterConvertTextEvent(tag, new String(text.ch, text.offset, text.length));
        if (convertedText != null) {
            char[] convertedTextChars = convertedText.toCharArray();
            text.setValues(convertedTextChars, 0, convertedTextChars.length);
        }
    }
}

