/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.input.TargetSelectInput;
import org.tp23.antinstaller.renderer.text.SelectInputRenderer;

public class TargetSelectInputRenderer
extends SelectInputRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");

    public void renderOutput(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        TargetSelectInput iField = (TargetSelectInput)field;
        this.printText(iField, out);
        String input = reader.readLine();
        out.println();
        if (input == null || input.equals("")) {
            input = iField.getDefaultValue();
        } else {
            try {
                int idx = Integer.parseInt(input.trim());
                input = iField.getOptions()[idx - 1].value;
            }
            catch (Exception numFormatOrIndexOutOfBounds) {
                return;
            }
        }
        this.ctx.getCurrentPage().removeTarget(iField.getIdx());
        this.ctx.getCurrentPage().addTarget(iField.getIdx(), input);
        iField.setInputResult(input);
    }

    private void printText(TargetSelectInput iField, PrintStream out) throws IOException {
        out.println(iField.getDisplayText());
        SelectInput.Option[] options = iField.getOptions();
        out.print("  ");
        out.println(res.getString("enterNumber"));
        for (int i = 0; i < options.length; ++i) {
            out.print("  ");
            out.print(i + 1);
            out.print(") ");
            out.print(options[i].getText());
            if (iField.getDefaultValue().equals(options[i].value)) {
                out.print(" [");
                out.print(res.getString("_default_"));
                out.print("]");
            }
            out.println();
        }
    }
}

