/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.VersionedWriteLoggable;
import com.sleepycat.je.log.entry.ReplicableLogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

abstract class SingleItemReplicableEntry<T extends VersionedWriteLoggable>
extends SingleItemEntry<T>
implements ReplicableLogEntry {
    SingleItemReplicableEntry(Class<T> logClass) {
        super(logClass);
    }

    SingleItemReplicableEntry(LogEntryType entryType, T item) {
        super(entryType, item);
    }

    @Override
    public Collection<VersionedWriteLoggable> getEmbeddedLoggables() {
        return Collections.singleton((VersionedWriteLoggable)this.newInstanceOfType());
    }

    @Override
    public int getSize(int logVersion, boolean forReplication) {
        return ((VersionedWriteLoggable)this.getMainItem()).getLogSize(logVersion, forReplication);
    }

    @Override
    public void writeEntry(ByteBuffer logBuffer, int logVersion, boolean forReplication) {
        ((VersionedWriteLoggable)this.getMainItem()).writeToLog(logBuffer, logVersion, forReplication);
    }

    @Override
    public boolean hasReplicationFormat() {
        return ((VersionedWriteLoggable)this.getMainItem()).hasReplicationFormat();
    }

    @Override
    public boolean isReplicationFormatWorthwhile(ByteBuffer logBuffer, int srcVersion, int destVersion) {
        return ((VersionedWriteLoggable)this.newInstanceOfType()).isReplicationFormatWorthwhile(logBuffer, srcVersion, destVersion);
    }
}

