/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.config.ConfigParam;

public class EnumConfigParam<T extends Enum<T>>
extends ConfigParam {
    private final Class<T> enumClass;

    public EnumConfigParam(String configName, Enum<T> defaultValue, boolean mutable, boolean forReplication, Class<T> enumClass) {
        super(configName, defaultValue.name(), mutable, forReplication);
        this.enumClass = enumClass;
    }

    public T getEnumerator(String enumName) {
        return Enum.valueOf(this.enumClass, enumName);
    }

    @Override
    public void validateValue(String value) throws IllegalArgumentException {
        if (this.enumClass != null) {
            Enum.valueOf(this.enumClass, value);
        }
    }
}

