/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.metrics;

public class ControllerMetricsConstant {
    public static final String LABEL_ADDRESS = "address";
    public static final String LABEL_GROUP = "group";
    public static final String LABEL_PEER_ID = "peer_id";
    public static final String LABEL_AGGREGATION = "aggregation";
    public static final String AGGREGATION_DELTA = "delta";
    public static final String OPEN_TELEMETRY_METER_NAME = "controller";
    public static final String GAUGE_ROLE = "role";
    public static final String GAUGE_DLEDGER_DISK_USAGE = "dledger_disk_usage";
    public static final String GAUGE_ACTIVE_BROKER_NUM = "active_broker_num";
    public static final String COUNTER_REQUEST_TOTAL = "request_total";
    public static final String COUNTER_DLEDGER_OP_TOTAL = "dledger_op_total";
    public static final String COUNTER_ELECTION_TOTAL = "election_total";
    public static final String HISTOGRAM_REQUEST_LATENCY = "request_latency";
    public static final String HISTOGRAM_DLEDGER_OP_LATENCY = "dledger_op_latency";
    public static final String LABEL_CLUSTER_NAME = "cluster";
    public static final String LABEL_BROKER_SET = "broker_set";
    public static final String LABEL_REQUEST_TYPE = "request_type";
    public static final String LABEL_REQUEST_HANDLE_STATUS = "request_handle_status";
    public static final String LABEL_DLEDGER_OPERATION = "dledger_operation";
    public static final String LABEL_DLEDGER_OPERATION_STATUS = "dLedger_operation_status";
    public static final String LABEL_ELECTION_RESULT = "election_result";

    public static enum ElectionResult {
        NEW_MASTER_ELECTED,
        KEEP_CURRENT_MASTER,
        NO_MASTER_ELECTED;


        public String getLowerCaseName() {
            return this.name().toLowerCase();
        }
    }

    public static enum DLedgerOperationStatus {
        SUCCESS,
        FAILED,
        TIMEOUT;


        public String getLowerCaseName() {
            return this.name().toLowerCase();
        }
    }

    public static enum DLedgerOperation {
        APPEND;


        public String getLowerCaseName() {
            return this.name().toLowerCase();
        }
    }

    public static enum RequestHandleStatus {
        SUCCESS,
        FAILED,
        TIMEOUT;


        public String getLowerCaseName() {
            return this.name().toLowerCase();
        }
    }

    public static enum RequestType {
        CONTROLLER_ALTER_SYNC_STATE_SET(1001),
        CONTROLLER_ELECT_MASTER(1002),
        CONTROLLER_REGISTER_BROKER(1003),
        CONTROLLER_GET_REPLICA_INFO(1004),
        CONTROLLER_GET_METADATA_INFO(1005),
        CONTROLLER_GET_SYNC_STATE_DATA(1006),
        CONTROLLER_GET_BROKER_EPOCH_CACHE(1007),
        CONTROLLER_NOTIFY_BROKER_ROLE_CHANGED(1008),
        CONTROLLER_BROKER_HEARTBEAT(904),
        CONTROLLER_UPDATE_CONTROLLER_CONFIG(1009),
        CONTROLLER_GET_CONTROLLER_CONFIG(1010),
        CONTROLLER_CLEAN_BROKER_DATA(1011),
        CONTROLLER_GET_NEXT_BROKER_ID(1012),
        CONTROLLER_APPLY_BROKER_ID(1013);

        private final int code;

        private RequestType(int code) {
            this.code = code;
        }

        public static String getLowerCaseNameByCode(int code) {
            for (RequestType requestType : RequestType.values()) {
                if (requestType.code != code) continue;
                return requestType.name();
            }
            return null;
        }
    }
}

