/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.subscription;

import com.google.common.base.MoreObjects;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.remoting.protocol.subscription.RetryPolicy;

public class ExponentialRetryPolicy
implements RetryPolicy {
    private long initial = TimeUnit.SECONDS.toMillis(5L);
    private long max = TimeUnit.HOURS.toMillis(2L);
    private long multiplier = 2L;

    public ExponentialRetryPolicy() {
    }

    public ExponentialRetryPolicy(long initial, long max, long multiplier) {
        this.initial = initial;
        this.max = max;
        this.multiplier = multiplier;
    }

    public long getInitial() {
        return this.initial;
    }

    public void setInitial(long initial) {
        this.initial = initial;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public long getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(long multiplier) {
        this.multiplier = multiplier;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("initial", this.initial).add("max", this.max).add("multiplier", this.multiplier).toString();
    }

    @Override
    public long nextDelayDuration(int reconsumeTimes) {
        if (reconsumeTimes < 0) {
            reconsumeTimes = 0;
        }
        if (reconsumeTimes > 32) {
            reconsumeTimes = 32;
        }
        return Math.min(this.max, this.initial * (long)Math.pow(this.multiplier, reconsumeTimes));
    }
}

