/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authorization.builder;

import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ClientType;
import apache.rocketmq.v2.EndTransactionRequest;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest;
import apache.rocketmq.v2.HeartbeatRequest;
import apache.rocketmq.v2.NotifyClientTerminationRequest;
import apache.rocketmq.v2.QueryAssignmentRequest;
import apache.rocketmq.v2.QueryRouteRequest;
import apache.rocketmq.v2.RecallMessageRequest;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.SendMessageRequest;
import apache.rocketmq.v2.Subscription;
import apache.rocketmq.v2.SubscriptionEntry;
import apache.rocketmq.v2.TelemetryCommand;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.auth.authentication.model.Subject;
import org.apache.rocketmq.auth.authentication.model.User;
import org.apache.rocketmq.auth.authorization.builder.AuthorizationContextBuilder;
import org.apache.rocketmq.auth.authorization.context.DefaultAuthorizationContext;
import org.apache.rocketmq.auth.authorization.exception.AuthorizationException;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.common.action.Action;
import org.apache.rocketmq.common.action.RocketMQAction;
import org.apache.rocketmq.common.constant.GrpcConstants;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.resource.ResourcePattern;
import org.apache.rocketmq.common.resource.ResourceType;
import org.apache.rocketmq.common.resource.RocketMQResource;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RequestHeaderRegistry;
import org.apache.rocketmq.remoting.protocol.body.LockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.body.UnlockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerListByGroupRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.UnregisterClientRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumerData;
import org.apache.rocketmq.remoting.protocol.heartbeat.HeartbeatData;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class DefaultAuthorizationContextBuilder
implements AuthorizationContextBuilder {
    private static final String TOPIC = "topic";
    private static final String GROUP = "group";
    private static final String A = "a";
    private static final String B = "b";
    private static final String CONSUMER_GROUP = "consumerGroup";
    private final AuthConfig authConfig;
    private final RequestHeaderRegistry requestHeaderRegistry;

    public DefaultAuthorizationContextBuilder(AuthConfig authConfig) {
        this.authConfig = authConfig;
        this.requestHeaderRegistry = RequestHeaderRegistry.getInstance();
    }

    @Override
    public List<DefaultAuthorizationContext> build(Metadata metadata, GeneratedMessageV3 message) {
        SendMessageRequest request;
        List<DefaultAuthorizationContext> result = null;
        if (message instanceof SendMessageRequest) {
            request = (SendMessageRequest)message;
            if (request.getMessagesCount() <= 0) {
                throw new AuthorizationException("message is null.");
            }
            result = DefaultAuthorizationContextBuilder.newPubContext(metadata, request.getMessages(0).getTopic());
        }
        if (message instanceof RecallMessageRequest) {
            request = (RecallMessageRequest)message;
            result = DefaultAuthorizationContextBuilder.newPubContext(metadata, request.getTopic());
        }
        if (message instanceof EndTransactionRequest) {
            request = (EndTransactionRequest)message;
            result = DefaultAuthorizationContextBuilder.newPubContext(metadata, request.getTopic());
        }
        if (message instanceof HeartbeatRequest) {
            request = (HeartbeatRequest)message;
            if (!this.isConsumerClientType(request.getClientType())) {
                return null;
            }
            result = DefaultAuthorizationContextBuilder.newGroupSubContexts(metadata, request.getGroup());
        }
        if (message instanceof ReceiveMessageRequest) {
            request = (ReceiveMessageRequest)message;
            if (!request.hasMessageQueue()) {
                throw new AuthorizationException("messageQueue is null.");
            }
            result = this.newSubContexts(metadata, request.getGroup(), request.getMessageQueue().getTopic());
        }
        if (message instanceof AckMessageRequest) {
            request = (AckMessageRequest)message;
            result = this.newSubContexts(metadata, request.getGroup(), request.getTopic());
        }
        if (message instanceof ForwardMessageToDeadLetterQueueRequest) {
            request = (ForwardMessageToDeadLetterQueueRequest)message;
            result = this.newSubContexts(metadata, request.getGroup(), request.getTopic());
        }
        if (message instanceof NotifyClientTerminationRequest && StringUtils.isNotBlank((CharSequence)(request = (NotifyClientTerminationRequest)message).getGroup().getName())) {
            result = DefaultAuthorizationContextBuilder.newGroupSubContexts(metadata, request.getGroup());
        }
        if (message instanceof ChangeInvisibleDurationRequest) {
            request = (ChangeInvisibleDurationRequest)message;
            result = DefaultAuthorizationContextBuilder.newGroupSubContexts(metadata, request.getGroup());
        }
        if (message instanceof QueryRouteRequest) {
            request = (QueryRouteRequest)message;
            result = this.newContext(metadata, (QueryRouteRequest)request);
        }
        if (message instanceof QueryAssignmentRequest) {
            request = (QueryAssignmentRequest)message;
            result = this.newSubContexts(metadata, request.getGroup(), request.getTopic());
        }
        if (message instanceof TelemetryCommand) {
            request = (TelemetryCommand)message;
            result = DefaultAuthorizationContextBuilder.newContext(metadata, (TelemetryCommand)request);
        }
        if (CollectionUtils.isNotEmpty(result)) {
            result.forEach(context -> {
                context.setChannelId((String)metadata.get(GrpcConstants.CHANNEL_ID));
                context.setRpcCode(message.getDescriptorForType().getFullName());
            });
        }
        return result;
    }

    @Override
    public List<DefaultAuthorizationContext> build(ChannelHandlerContext context, RemotingCommand command) {
        List<DefaultAuthorizationContext> result = new ArrayList<DefaultAuthorizationContext>();
        try {
            HashMap fields = command.getExtFields();
            if (MapUtils.isEmpty((Map)fields)) {
                return result;
            }
            User subject = null;
            if (fields.containsKey("AccessKey")) {
                subject = User.of((String)fields.get("AccessKey"));
            }
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr((Channel)context.channel());
            String sourceIp = StringUtils.substringBeforeLast((String)remoteAddr, (String)":");
            switch (command.getCode()) {
                case 105: {
                    if (NamespaceUtil.isRetryTopic((String)((String)fields.get(TOPIC)))) {
                        org.apache.rocketmq.auth.authorization.model.Resource group = org.apache.rocketmq.auth.authorization.model.Resource.ofGroup((String)fields.get(TOPIC));
                        result.add(DefaultAuthorizationContext.of((Subject)subject, group, Arrays.asList(Action.SUB, Action.GET), sourceIp));
                        break;
                    }
                    org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic((String)fields.get(TOPIC));
                    result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Arrays.asList(Action.PUB, Action.SUB, Action.GET), sourceIp));
                    break;
                }
                case 10: {
                    if (NamespaceUtil.isRetryTopic((String)((String)fields.get(TOPIC)))) {
                        org.apache.rocketmq.auth.authorization.model.Resource group = StringUtils.isNotBlank((CharSequence)((CharSequence)fields.get(GROUP))) ? org.apache.rocketmq.auth.authorization.model.Resource.ofGroup((String)fields.get(GROUP)) : org.apache.rocketmq.auth.authorization.model.Resource.ofGroup((String)fields.get(TOPIC));
                        result.add(DefaultAuthorizationContext.of((Subject)subject, group, Action.SUB, sourceIp));
                        break;
                    }
                    org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic((String)fields.get(TOPIC));
                    result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Action.PUB, sourceIp));
                    break;
                }
                case 310: 
                case 320: {
                    if (NamespaceUtil.isRetryTopic((String)((String)fields.get(B)))) {
                        org.apache.rocketmq.auth.authorization.model.Resource group = StringUtils.isNotBlank((CharSequence)((CharSequence)fields.get(A))) ? org.apache.rocketmq.auth.authorization.model.Resource.ofGroup((String)fields.get(A)) : org.apache.rocketmq.auth.authorization.model.Resource.ofGroup((String)fields.get(B));
                        result.add(DefaultAuthorizationContext.of((Subject)subject, group, Action.SUB, sourceIp));
                        break;
                    }
                    org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic((String)fields.get(B));
                    result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Action.PUB, sourceIp));
                    break;
                }
                case 370: {
                    org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic((String)fields.get(TOPIC));
                    result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Action.PUB, sourceIp));
                    break;
                }
                case 37: {
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)fields.get(TOPIC)))) break;
                    org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic((String)fields.get(TOPIC));
                    result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Action.PUB, sourceIp));
                    break;
                }
                case 36: {
                    org.apache.rocketmq.auth.authorization.model.Resource group = org.apache.rocketmq.auth.authorization.model.Resource.ofGroup((String)fields.get(GROUP));
                    result.add(DefaultAuthorizationContext.of((Subject)subject, group, Action.SUB, sourceIp));
                    break;
                }
                case 11: {
                    if (!NamespaceUtil.isRetryTopic((String)((String)fields.get(TOPIC)))) {
                        org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic((String)fields.get(TOPIC));
                        result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Action.SUB, sourceIp));
                    }
                    org.apache.rocketmq.auth.authorization.model.Resource group = org.apache.rocketmq.auth.authorization.model.Resource.ofGroup((String)fields.get(CONSUMER_GROUP));
                    result.add(DefaultAuthorizationContext.of((Subject)subject, group, Action.SUB, sourceIp));
                    break;
                }
                case 12: {
                    org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic((String)fields.get(TOPIC));
                    result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Arrays.asList(Action.SUB, Action.GET), sourceIp));
                    break;
                }
                case 34: {
                    HeartbeatData heartbeatData = (HeartbeatData)HeartbeatData.decode((byte[])command.getBody(), HeartbeatData.class);
                    for (ConsumerData data : heartbeatData.getConsumerDataSet()) {
                        org.apache.rocketmq.auth.authorization.model.Resource group = org.apache.rocketmq.auth.authorization.model.Resource.ofGroup(data.getGroupName());
                        result.add(DefaultAuthorizationContext.of((Subject)subject, group, Action.SUB, sourceIp));
                        for (SubscriptionData subscriptionData : data.getSubscriptionDataSet()) {
                            if (NamespaceUtil.isRetryTopic((String)subscriptionData.getTopic())) continue;
                            org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic(subscriptionData.getTopic());
                            result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Action.SUB, sourceIp));
                        }
                    }
                    break;
                }
                case 35: {
                    UnregisterClientRequestHeader unregisterClientRequestHeader = (UnregisterClientRequestHeader)command.decodeCommandCustomHeader(UnregisterClientRequestHeader.class);
                    if (!StringUtils.isNotBlank((CharSequence)unregisterClientRequestHeader.getConsumerGroup())) break;
                    org.apache.rocketmq.auth.authorization.model.Resource group = org.apache.rocketmq.auth.authorization.model.Resource.ofGroup(unregisterClientRequestHeader.getConsumerGroup());
                    result.add(DefaultAuthorizationContext.of((Subject)subject, group, Action.SUB, sourceIp));
                    break;
                }
                case 38: {
                    GetConsumerListByGroupRequestHeader getConsumerListByGroupRequestHeader = (GetConsumerListByGroupRequestHeader)command.decodeCommandCustomHeader(GetConsumerListByGroupRequestHeader.class);
                    org.apache.rocketmq.auth.authorization.model.Resource group = org.apache.rocketmq.auth.authorization.model.Resource.ofGroup(getConsumerListByGroupRequestHeader.getConsumerGroup());
                    result.add(DefaultAuthorizationContext.of((Subject)subject, group, Arrays.asList(Action.SUB, Action.GET), sourceIp));
                    break;
                }
                case 14: {
                    QueryConsumerOffsetRequestHeader queryConsumerOffsetRequestHeader = (QueryConsumerOffsetRequestHeader)command.decodeCommandCustomHeader(QueryConsumerOffsetRequestHeader.class);
                    if (!NamespaceUtil.isRetryTopic((String)queryConsumerOffsetRequestHeader.getTopic())) {
                        org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic(queryConsumerOffsetRequestHeader.getTopic());
                        result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Arrays.asList(Action.SUB, Action.GET), sourceIp));
                    }
                    org.apache.rocketmq.auth.authorization.model.Resource group = org.apache.rocketmq.auth.authorization.model.Resource.ofGroup(queryConsumerOffsetRequestHeader.getConsumerGroup());
                    result.add(DefaultAuthorizationContext.of((Subject)subject, group, Arrays.asList(Action.SUB, Action.GET), sourceIp));
                    break;
                }
                case 15: {
                    UpdateConsumerOffsetRequestHeader updateConsumerOffsetRequestHeader = (UpdateConsumerOffsetRequestHeader)command.decodeCommandCustomHeader(UpdateConsumerOffsetRequestHeader.class);
                    if (!NamespaceUtil.isRetryTopic((String)updateConsumerOffsetRequestHeader.getTopic())) {
                        org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic(updateConsumerOffsetRequestHeader.getTopic());
                        result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Arrays.asList(Action.SUB, Action.UPDATE), sourceIp));
                    }
                    org.apache.rocketmq.auth.authorization.model.Resource group = org.apache.rocketmq.auth.authorization.model.Resource.ofGroup(updateConsumerOffsetRequestHeader.getConsumerGroup());
                    result.add(DefaultAuthorizationContext.of((Subject)subject, group, Arrays.asList(Action.SUB, Action.UPDATE), sourceIp));
                    break;
                }
                case 41: {
                    LockBatchRequestBody lockBatchRequestBody = (LockBatchRequestBody)LockBatchRequestBody.decode((byte[])command.getBody(), LockBatchRequestBody.class);
                    org.apache.rocketmq.auth.authorization.model.Resource group = org.apache.rocketmq.auth.authorization.model.Resource.ofGroup(lockBatchRequestBody.getConsumerGroup());
                    result.add(DefaultAuthorizationContext.of((Subject)subject, group, Action.SUB, sourceIp));
                    if (!CollectionUtils.isNotEmpty((Collection)lockBatchRequestBody.getMqSet())) break;
                    for (MessageQueue messageQueue : lockBatchRequestBody.getMqSet()) {
                        if (NamespaceUtil.isRetryTopic((String)messageQueue.getTopic())) continue;
                        org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic(messageQueue.getTopic());
                        result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Action.SUB, sourceIp));
                    }
                    break;
                }
                case 42: {
                    UnlockBatchRequestBody unlockBatchRequestBody = (UnlockBatchRequestBody)UnlockBatchRequestBody.decode((byte[])command.getBody(), UnlockBatchRequestBody.class);
                    org.apache.rocketmq.auth.authorization.model.Resource group = org.apache.rocketmq.auth.authorization.model.Resource.ofGroup(unlockBatchRequestBody.getConsumerGroup());
                    result.add(DefaultAuthorizationContext.of((Subject)subject, group, Action.SUB, sourceIp));
                    if (!CollectionUtils.isNotEmpty((Collection)unlockBatchRequestBody.getMqSet())) break;
                    for (MessageQueue messageQueue : unlockBatchRequestBody.getMqSet()) {
                        if (NamespaceUtil.isRetryTopic((String)messageQueue.getTopic())) continue;
                        org.apache.rocketmq.auth.authorization.model.Resource topic = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic(messageQueue.getTopic());
                        result.add(DefaultAuthorizationContext.of((Subject)subject, topic, Action.SUB, sourceIp));
                    }
                    break;
                }
                default: {
                    result = this.buildContextByAnnotation(subject, command, sourceIp);
                }
            }
            if (CollectionUtils.isNotEmpty(result)) {
                result.forEach(r -> {
                    r.setChannelId(context.channel().id().asLongText());
                    r.setRpcCode(String.valueOf(command.getCode()));
                });
            }
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new AuthorizationException("parse authorization context error.", t);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DefaultAuthorizationContext> buildContextByAnnotation(Subject subject, RemotingCommand request, String sourceIp) throws Exception {
        Object[] fields;
        ArrayList<DefaultAuthorizationContext> result = new ArrayList<DefaultAuthorizationContext>();
        Class clazz = this.requestHeaderRegistry.getRequestHeader(request.getCode());
        if (clazz == null) {
            return result;
        }
        CommandCustomHeader header = request.decodeCommandCustomHeader(clazz);
        RocketMQAction rocketMQAction = clazz.getAnnotation(RocketMQAction.class);
        ResourceType resourceType = rocketMQAction.resource();
        Action[] actions = rocketMQAction.action();
        org.apache.rocketmq.auth.authorization.model.Resource resource = null;
        if (resourceType == ResourceType.CLUSTER) {
            resource = org.apache.rocketmq.auth.authorization.model.Resource.ofCluster(this.authConfig.getClusterName());
        }
        if (ArrayUtils.isNotEmpty((Object[])(fields = clazz.getDeclaredFields()))) {
            for (Object field : fields) {
                RocketMQResource rocketMQResource = ((Field)field).getAnnotation(RocketMQResource.class);
                if (rocketMQResource == null) continue;
                ((Field)field).setAccessible(true);
                try {
                    resourceType = rocketMQResource.value();
                    String splitter = rocketMQResource.splitter();
                    Object value = ((Field)field).get(header);
                    if (value == null) continue;
                    String[] resourceValues = StringUtils.isNotBlank((CharSequence)splitter) ? StringUtils.split((String)value.toString(), (String)splitter) : new String[]{value.toString()};
                    for (String resourceValue : resourceValues) {
                        if (resourceType == ResourceType.TOPIC && NamespaceUtil.isRetryTopic((String)resourceValue)) {
                            resource = org.apache.rocketmq.auth.authorization.model.Resource.ofGroup(resourceValue);
                            result.add(DefaultAuthorizationContext.of(subject, resource, Arrays.asList(actions), sourceIp));
                            continue;
                        }
                        resource = org.apache.rocketmq.auth.authorization.model.Resource.of(resourceType, resourceValue, ResourcePattern.LITERAL);
                        result.add(DefaultAuthorizationContext.of(subject, resource, Arrays.asList(actions), sourceIp));
                    }
                }
                finally {
                    ((Field)field).setAccessible(false);
                }
            }
        }
        if (CollectionUtils.isEmpty(result) && resource != null) {
            result.add(DefaultAuthorizationContext.of(subject, resource, Arrays.asList(actions), sourceIp));
        }
        return result;
    }

    private List<DefaultAuthorizationContext> newContext(Metadata metadata, QueryRouteRequest request) {
        Resource topic = request.getTopic();
        if (StringUtils.isBlank((CharSequence)topic.getName())) {
            throw new AuthorizationException("topic is null.");
        }
        User subject = null;
        if (metadata.containsKey(GrpcConstants.AUTHORIZATION_AK)) {
            subject = User.of((String)metadata.get(GrpcConstants.AUTHORIZATION_AK));
        }
        org.apache.rocketmq.auth.authorization.model.Resource resource = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic(topic.getName());
        String sourceIp = StringUtils.substringBeforeLast((String)((String)metadata.get(GrpcConstants.REMOTE_ADDRESS)), (String)":");
        DefaultAuthorizationContext context = DefaultAuthorizationContext.of((Subject)subject, resource, Arrays.asList(Action.PUB, Action.SUB), sourceIp);
        return Collections.singletonList(context);
    }

    private static List<DefaultAuthorizationContext> newContext(Metadata metadata, TelemetryCommand request) {
        if (request.getCommandCase() != TelemetryCommand.CommandCase.SETTINGS) {
            return null;
        }
        if (!request.getSettings().hasPublishing() && !request.getSettings().hasSubscription()) {
            throw new AclException("settings command doesn't have publishing or subscription.");
        }
        ArrayList<DefaultAuthorizationContext> result = new ArrayList<DefaultAuthorizationContext>();
        if (request.getSettings().hasPublishing()) {
            List topicList = request.getSettings().getPublishing().getTopicsList();
            for (Resource topic : topicList) {
                result.addAll(DefaultAuthorizationContextBuilder.newPubContext(metadata, topic));
            }
        }
        if (request.getSettings().hasSubscription()) {
            Subscription subscription = request.getSettings().getSubscription();
            result.addAll(DefaultAuthorizationContextBuilder.newSubContexts(metadata, ResourceType.GROUP, subscription.getGroup()));
            for (SubscriptionEntry entry : subscription.getSubscriptionsList()) {
                result.addAll(DefaultAuthorizationContextBuilder.newSubContexts(metadata, ResourceType.TOPIC, entry.getTopic()));
            }
        }
        return result;
    }

    private boolean isConsumerClientType(ClientType clientType) {
        return Arrays.asList(ClientType.PUSH_CONSUMER, ClientType.SIMPLE_CONSUMER, ClientType.PULL_CONSUMER).contains(clientType);
    }

    private static List<DefaultAuthorizationContext> newPubContext(Metadata metadata, Resource topic) {
        if (topic == null || StringUtils.isBlank((CharSequence)topic.getName())) {
            throw new AuthorizationException("topic is null.");
        }
        User subject = null;
        if (metadata.containsKey(GrpcConstants.AUTHORIZATION_AK)) {
            subject = User.of((String)metadata.get(GrpcConstants.AUTHORIZATION_AK));
        }
        org.apache.rocketmq.auth.authorization.model.Resource resource = org.apache.rocketmq.auth.authorization.model.Resource.ofTopic(topic.getName());
        String sourceIp = StringUtils.substringBeforeLast((String)((String)metadata.get(GrpcConstants.REMOTE_ADDRESS)), (String)":");
        DefaultAuthorizationContext context = DefaultAuthorizationContext.of((Subject)subject, resource, Action.PUB, sourceIp);
        return Collections.singletonList(context);
    }

    private List<DefaultAuthorizationContext> newSubContexts(Metadata metadata, Resource group, Resource topic) {
        ArrayList<DefaultAuthorizationContext> result = new ArrayList<DefaultAuthorizationContext>();
        result.addAll(DefaultAuthorizationContextBuilder.newGroupSubContexts(metadata, group));
        result.addAll(DefaultAuthorizationContextBuilder.newTopicSubContexts(metadata, topic));
        return result;
    }

    private static List<DefaultAuthorizationContext> newTopicSubContexts(Metadata metadata, Resource resource) {
        return DefaultAuthorizationContextBuilder.newSubContexts(metadata, ResourceType.TOPIC, resource);
    }

    private static List<DefaultAuthorizationContext> newGroupSubContexts(Metadata metadata, Resource resource) {
        return DefaultAuthorizationContextBuilder.newSubContexts(metadata, ResourceType.GROUP, resource);
    }

    private static List<DefaultAuthorizationContext> newSubContexts(Metadata metadata, ResourceType resourceType, Resource resource) {
        if (resourceType == ResourceType.GROUP) {
            if (resource == null || StringUtils.isBlank((CharSequence)resource.getName())) {
                throw new AuthorizationException("group is null.");
            }
            return DefaultAuthorizationContextBuilder.newSubContexts(metadata, org.apache.rocketmq.auth.authorization.model.Resource.ofGroup(resource.getName()));
        }
        if (resourceType == ResourceType.TOPIC) {
            if (resource == null || StringUtils.isBlank((CharSequence)resource.getName())) {
                throw new AuthorizationException("topic is null.");
            }
            return DefaultAuthorizationContextBuilder.newSubContexts(metadata, org.apache.rocketmq.auth.authorization.model.Resource.ofTopic(resource.getName()));
        }
        throw new AuthorizationException("unknown resource type.");
    }

    private static List<DefaultAuthorizationContext> newSubContexts(Metadata metadata, org.apache.rocketmq.auth.authorization.model.Resource resource) {
        ArrayList<DefaultAuthorizationContext> result = new ArrayList<DefaultAuthorizationContext>();
        User subject = null;
        if (metadata.containsKey(GrpcConstants.AUTHORIZATION_AK)) {
            subject = User.of((String)metadata.get(GrpcConstants.AUTHORIZATION_AK));
        }
        String sourceIp = StringUtils.substringBeforeLast((String)((String)metadata.get(GrpcConstants.REMOTE_ADDRESS)), (String)":");
        result.add(DefaultAuthorizationContext.of((Subject)subject, resource, Action.SUB, sourceIp));
        return result;
    }
}

