/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public final class ConfigUtil {
    private ConfigUtil() {
    }

    public static List<String> parseArrayValue(String value) {
        if (value == null) {
            return new ArrayList<String>(0);
        }
        String[] tokens = value.split(",");
        ArrayList<String> result = new ArrayList<String>(tokens.length);
        for (String t : tokens) {
            result.add(t.trim());
        }
        return result;
    }

    public static Set<String> propertiesWithPrefix(Environment environment, String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (PropertySource propertySource : ((ConfigurableEnvironment)environment).getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                if (!key.startsWith(prefix)) continue;
                result.add(key);
            }
        }
        return result;
    }

    public static Map<String, String> stringPropertiesWithPrefix(Environment environment, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (PropertySource propertySource : ((ConfigurableEnvironment)environment).getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                if (!key.startsWith(prefix)) continue;
                result.put(key, environment.getProperty(key));
            }
        }
        return result;
    }
}

