/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.storage.geotiff.writer.PixelChannel;

abstract class CompressionChannel
extends PixelChannel {
    private static final int BUFFER_SIZE = 16384;
    protected final ChannelDataOutput output;
    protected final long length;

    protected CompressionChannel(ChannelDataOutput output, long length) {
        this.output = output;
        this.length = length;
    }

    final int bufferCapacity() {
        return Math.max((int)Math.min(this.length, 16384L), 1024);
    }

    @Override
    ByteBuffer createBuffer() {
        return ByteBuffer.allocate(this.bufferCapacity());
    }

    @Override
    public final boolean isOpen() {
        return this.output.channel.isOpen();
    }

    @Override
    public void finish(ChannelDataOutput owner) throws IOException {
        owner.flush();
        owner.clear();
    }

    @Override
    public void close() {
    }
}

