/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.event.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DistributionEventFactory.class})
public class DefaultDistributionEventFactory
implements DistributionEventFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private EventAdmin eventAdmin;

    private void generateEvent(@NotNull String distributionEventTopic, @NotNull Dictionary<String, ?> properties) {
        this.eventAdmin.postEvent(new Event(distributionEventTopic, properties));
        this.log.debug("distribution event {} posted", (Object)distributionEventTopic);
    }

    @Override
    public void generatePackageEvent(@NotNull String distributionEventTopic, @NotNull DistributionComponentKind kind, @NotNull String name, @NotNull DistributionPackageInfo info) {
        try {
            Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
            ((Dictionary)dictionary).put("distribution.component.name", name);
            ((Dictionary)dictionary).put("distribution.component.kind", kind.name());
            if (info.getRequestType() != null) {
                ((Dictionary)dictionary).put("distribution.type", info.getRequestType());
            }
            if (info.getPaths() != null) {
                ((Dictionary)dictionary).put("distribution.paths", info.getPaths());
            }
            this.generateEvent(distributionEventTopic, dictionary);
        }
        catch (Throwable e) {
            this.log.error("Cannot generate package event", e);
        }
    }
}

