/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.helper;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.request.SlingRequestListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestListenerManager.class})
@ServiceDescription(value="Request listener manager")
@ServiceVendor(value="The Apache Software Foundation")
public class RequestListenerManager {
    private final ServletContext servletContext;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, fieldOption=FieldOption.REPLACE)
    private volatile List<SlingRequestListener> listeners;

    @Activate
    public RequestListenerManager(@Reference(target="(name=org.apache.sling)") ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void sendEvent(HttpServletRequest request, SlingRequestEvent.EventType type) {
        List<SlingRequestListener> local = this.listeners;
        if (local != null && !local.isEmpty()) {
            SlingRequestEvent event = new SlingRequestEvent(this.servletContext, (ServletRequest)request, type);
            for (SlingRequestListener service : local) {
                try {
                    service.onEvent(event);
                }
                catch (Throwable t) {
                    this.logger.error("Error invoking sling request listener " + service + " : " + t.getMessage(), t);
                }
            }
        }
    }
}

