/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.ui;

import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaBuilder;
import io.wcm.handler.media.MediaHandler;
import io.wcm.handler.media.format.MediaFormatHandler;
import io.wcm.handler.media.impl.WidthUtils;
import io.wcm.handler.media.ui.ImageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class})
public class ResourceMedia {
    private static final String RA_PROPERTY_PREFIX = "property:";
    private static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("^property:.+$");
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String mediaFormat;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String refProperty;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String cropProperty;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String rotationProperty;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String cssClass;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Boolean autoCrop;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String imageWidths;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String imageSizes;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Object[] pictureSourceMediaFormat;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Object[] pictureSourceMedia;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Object[] pictureSourceWidths;
    @Self
    private MediaHandler mediaHandler;
    @Self
    private MediaFormatHandler mediaFormatHandler;
    @SlingObject
    private Resource resource;
    @Self
    private SlingHttpServletRequest request;
    private Media media;

    @PostConstruct
    private void activate() {
        MediaBuilder builder = this.mediaHandler.get(this.resource);
        if (StringUtils.isNotEmpty((CharSequence)this.mediaFormat)) {
            builder.mediaFormatName(this.mediaFormat);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.refProperty)) {
            builder.refProperty(this.refProperty);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.cropProperty)) {
            builder.cropProperty(this.cropProperty);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.rotationProperty)) {
            builder.rotationProperty(this.rotationProperty);
        }
        if (this.autoCrop != null) {
            builder.autoCrop(this.autoCrop);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.cssClass)) {
            builder.property("cssClass", this.cssClass);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.imageSizes)) {
            MediaArgs.WidthOption[] widthOptionsArray = WidthUtils.parseWidths(this.imageWidths);
            if (widthOptionsArray != null) {
                builder.imageSizes(this.imageSizes, widthOptionsArray);
            }
        } else if (this.pictureSourceMediaFormat != null && this.pictureSourceMedia != null && this.pictureSourceWidths != null) {
            ImageUtils.applyPictureSources(this.mediaFormatHandler, builder, ResourceMedia.toStringArray(this.pictureSourceMediaFormat), ResourceMedia.toStringArray(this.pictureSourceMedia), ResourceMedia.toStringArray(this.pictureSourceWidths));
        }
        this.setCustomProperties(builder);
        this.media = builder.build();
    }

    private void setCustomProperties(MediaBuilder builder) {
        this.getCustomPropertiesFromRequestAttributes().forEach((name, value) -> builder.property((String)name, value));
    }

    @NotNull
    private Map<String, Object> getCustomPropertiesFromRequestAttributes() {
        return this.enumToList(this.request.getAttributeNames()).stream().filter(this::isMediaPropAttribute).filter(this::attributeValueIsNotNull).collect(Collectors.toMap(this::toPropertyName, arg_0 -> ((SlingHttpServletRequest)this.request).getAttribute(arg_0)));
    }

    @NotNull
    private List<String> enumToList(@Nullable Enumeration<?> enumeration) {
        ArrayList<String> list = new ArrayList<String>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                list.add(String.valueOf(enumeration.nextElement()));
            }
        }
        return list;
    }

    private boolean isMediaPropAttribute(@NotNull String requestAttributeName) {
        return PROPERTY_NAME_PATTERN.matcher(requestAttributeName).matches();
    }

    private boolean attributeValueIsNotNull(String attributeName) {
        return Objects.nonNull(this.request.getAttribute(attributeName));
    }

    @NotNull
    private String toPropertyName(@NotNull String requestAttributeName) {
        return StringUtils.substringAfter((String)requestAttributeName, (String)RA_PROPERTY_PREFIX);
    }

    private static String[] toStringArray(Object ... objectArray) {
        return (String[])Arrays.stream(objectArray).map(obj -> obj == null ? "" : obj.toString()).toArray(String[]::new);
    }

    @NotNull
    public Media getMetadata() {
        return this.media;
    }

    public boolean isValid() {
        return this.media.isValid();
    }

    @Nullable
    public String getMarkup() {
        return this.media.getMarkup();
    }
}

