/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceUnavailableException;
import org.ops4j.peaberry.builders.ImportDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DirectServiceFactory {
    private DirectServiceFactory() {
    }

    static <T> Iterable<T> directServices(Iterable<Import<T>> services, ImportDecorator<? super T> decorator) {
        ArrayList<T> instances = new ArrayList<T>();
        Iterator<Import<T>> i = services.iterator();
        while (i.hasNext()) {
            T instance = DirectServiceFactory.nextService(i, decorator);
            if (null == instance) continue;
            instances.add(instance);
        }
        return Collections.unmodifiableList(instances);
    }

    static <T> T directService(Iterable<Import<T>> services, ImportDecorator<? super T> decorator) {
        Iterator<Import<T>> i = services.iterator();
        while (i.hasNext()) {
            T instance = DirectServiceFactory.nextService(i, decorator);
            if (null == instance) continue;
            return instance;
        }
        return null;
    }

    private static <T> T nextService(Iterator<Import<T>> i, ImportDecorator<? super T> decorator) {
        try {
            return (null == decorator ? i.next() : decorator.decorate(i.next())).get();
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            return null;
        }
    }
}

