/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.wizards.np;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.sling.ide.eclipse.m2e.internal.Activator;
import org.apache.sling.ide.eclipse.ui.wizards.np.AbstractNewMavenBasedSlingApplicationWizard;
import org.apache.sling.ide.log.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypePlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ChooseArchetypeWizardPage
extends WizardPage {
    static final Comparator<String> ARTIFACT_KEY_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            String[] gav1 = o1.split(" : ");
            String[] gav2 = o2.split(" : ");
            if (gav1.length != 3 || gav2.length != 3) {
                return 0;
            }
            String groupId1 = gav1[0];
            String groupId2 = gav2[0];
            int res = groupId1.compareTo(groupId2);
            if (res != 0) {
                return res;
            }
            String artifactId1 = gav1[1];
            String artifactId2 = gav2[1];
            res = artifactId1.compareTo(artifactId2);
            if (res != 0) {
                return res;
            }
            DefaultArtifactVersion version1 = new DefaultArtifactVersion(gav1[2]);
            DefaultArtifactVersion version2 = new DefaultArtifactVersion(gav2[2]);
            return version2.compareTo((Object)version1);
        }
    };
    private static final String LOADING_PLEASE_WAIT = "loading, please wait...";
    private Combo knownArchetypes;
    private Map<String, Archetype> archetypesMap = new TreeMap<String, Archetype>(ARTIFACT_KEY_COMPARATOR);
    private Button useDefaultWorkspaceLocationButton;
    private Label locationLabel;
    private Combo locationCombo;

    public ChooseArchetypeWizardPage(AbstractNewMavenBasedSlingApplicationWizard parent) {
        super("chooseArchetypePage");
        this.setTitle("Choose Project Location and Archetype");
        this.setDescription("This step defines the project location and archetype");
        this.setImageDescriptor(parent.getLogo());
    }

    public AbstractNewMavenBasedSlingApplicationWizard getWizard() {
        return (AbstractNewMavenBasedSlingApplicationWizard)super.getWizard();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        this.useDefaultWorkspaceLocationButton = new Button(container, 32);
        GridData useDefaultWorkspaceLocationButtonData = new GridData(16384, 0x1000000, false, false, 3, 1);
        this.useDefaultWorkspaceLocationButton.setLayoutData((Object)useDefaultWorkspaceLocationButtonData);
        this.useDefaultWorkspaceLocationButton.setText("Use default Workspace location");
        this.useDefaultWorkspaceLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean inWorkspace = ChooseArchetypeWizardPage.this.useDefaultWorkspaceLocationButton.getSelection();
                ChooseArchetypeWizardPage.this.locationLabel.setEnabled(!inWorkspace);
                ChooseArchetypeWizardPage.this.locationCombo.setEnabled(!inWorkspace);
                ChooseArchetypeWizardPage.this.dialogChanged();
            }
        });
        this.useDefaultWorkspaceLocationButton.setSelection(true);
        this.locationLabel = new Label(container, 0);
        GridData locationLabelData = new GridData();
        locationLabelData.horizontalIndent = 10;
        this.locationLabel.setLayoutData((Object)locationLabelData);
        this.locationLabel.setText("Location:");
        this.locationLabel.setEnabled(false);
        this.locationCombo = new Combo(container, 0);
        GridData locationComboData = new GridData(4, 0x1000000, true, false);
        this.locationCombo.setLayoutData((Object)locationComboData);
        this.locationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseArchetypeWizardPage.this.dialogChanged();
            }
        });
        this.locationCombo.setEnabled(false);
        Button locationBrowseButton = new Button(container, 0);
        GridData locationBrowseButtonData = new GridData(4, 0x1000000, false, false);
        locationBrowseButton.setLayoutData((Object)locationBrowseButtonData);
        locationBrowseButton.setText("Browse...");
        locationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ChooseArchetypeWizardPage.this.getShell());
                dialog.setText("Select Location");
                String path = ChooseArchetypeWizardPage.this.locationCombo.getText();
                if (path.length() == 0) {
                    path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString();
                }
                dialog.setFilterPath(path);
                String selectedDir = dialog.open();
                if (selectedDir != null) {
                    ChooseArchetypeWizardPage.this.locationCombo.setText(selectedDir);
                    ChooseArchetypeWizardPage.this.useDefaultWorkspaceLocationButton.setSelection(false);
                    ChooseArchetypeWizardPage.this.dialogChanged();
                }
            }
        });
        Label label = new Label(container, 0);
        label.setText("&Archetype:");
        this.knownArchetypes = new Combo(container, 12);
        GridData gd = new GridData(768);
        this.knownArchetypes.setLayoutData((Object)gd);
        this.knownArchetypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseArchetypeWizardPage.this.dialogChanged();
            }
        });
        this.knownArchetypes.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ChooseArchetypeWizardPage.this.getContainer().showPage(ChooseArchetypeWizardPage.this.getNextPage());
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)container);
    }

    public void dispose() {
        super.dispose();
    }

    public Archetype getSelectedArchetype() {
        int idx = this.knownArchetypes.getSelectionIndex();
        if (idx == -1) {
            return null;
        }
        String archetype = this.knownArchetypes.getItem(idx);
        return this.archetypesMap.get(archetype);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.knownArchetypes.getItemCount() == 0) {
            this.initialize();
        }
    }

    private void initialize() {
        this.knownArchetypes.add(LOADING_PLEASE_WAIT);
        this.knownArchetypes.select(0);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new RefreshArchetypesRunnable());
        }
        catch (InvocationTargetException e) {
            this.getWizard().reportError(e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private String keyFor(Archetype archetype2) {
        return archetype2.getGroupId() + " : " + archetype2.getArtifactId() + " : " + archetype2.getVersion();
    }

    private void dialogChanged() {
        if (this.knownArchetypes.getItemCount() == 1 && this.knownArchetypes.getItem(0).equals(LOADING_PLEASE_WAIT)) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        if (this.knownArchetypes.getSelectionIndex() == -1) {
            this.updateStatus("archetype must be selected");
            return;
        }
        if (!this.useDefaultWorkspaceLocationButton.getSelection() && this.locationCombo.getText().length() == 0) {
            this.updateStatus("location must be specified");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public IPath getLocation() {
        if (!this.useDefaultWorkspaceLocationButton.getSelection() && this.locationCombo.getText().length() > 0) {
            return new Path(this.locationCombo.getText());
        }
        return null;
    }

    class RefreshArchetypesRunnable
    implements IRunnableWithProgress {
        RefreshArchetypesRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            Logger logger = Activator.getDefault().getPluginLogger();
            monitor.beginTask("Discovering archetypes...", 5);
            ArchetypePlugin archetypeManager = M2EUIPluginActivator.getDefault().getArchetypePlugin();
            monitor.worked(1);
            Collection archetypeCatalogs = archetypeManager.getActiveArchetypeCatalogs();
            monitor.worked(2);
            ArrayList candidates = new ArrayList();
            for (ArchetypeCatalogFactory catalogFactory : archetypeCatalogs) {
                try {
                    ArchetypeCatalog catalog = catalogFactory.getArchetypeCatalog();
                    List arcs = catalog.getArchetypes();
                    logger.trace("Catalog factory {0} provided {1} archetypes", new Object[]{catalogFactory, arcs != null ? arcs.size() : 0});
                    if (arcs == null) continue;
                    candidates.addAll(arcs);
                }
                catch (CoreException ce) {
                    throw new InvocationTargetException(ce);
                }
            }
            monitor.worked(1);
            boolean changed = false;
            logger.trace("Considering {0} archetypes from {1} archetype catalogs", new Object[]{candidates.size(), archetypeCatalogs.size()});
            for (Archetype candidate : candidates) {
                if (!ChooseArchetypeWizardPage.this.getWizard().acceptsArchetype(candidate)) continue;
                String key = ChooseArchetypeWizardPage.this.keyFor(candidate);
                Archetype old = ChooseArchetypeWizardPage.this.archetypesMap.put(key, candidate);
                logger.trace("Registered archetype {0}", new Object[]{candidate});
                if (old == null || !old.equals((Object)candidate)) {
                    changed = true;
                }
                logger.trace("Old archetype was {0}, changed = {1}", new Object[]{old, changed});
            }
            monitor.worked(1);
            if (changed || ChooseArchetypeWizardPage.this.archetypesMap.isEmpty()) {
                logger.trace("Triggering refresh since changed is true", new Object[0]);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Set<String> keys = ((RefreshArchetypesRunnable)RefreshArchetypesRunnable.this).ChooseArchetypeWizardPage.this.archetypesMap.keySet();
                        ((RefreshArchetypesRunnable)RefreshArchetypesRunnable.this).ChooseArchetypeWizardPage.this.knownArchetypes.removeAll();
                        for (String aKey : keys) {
                            ((RefreshArchetypesRunnable)RefreshArchetypesRunnable.this).ChooseArchetypeWizardPage.this.knownArchetypes.add(aKey);
                        }
                        ((RefreshArchetypesRunnable)RefreshArchetypesRunnable.this).ChooseArchetypeWizardPage.this.knownArchetypes.pack();
                        if (((RefreshArchetypesRunnable)RefreshArchetypesRunnable.this).ChooseArchetypeWizardPage.this.knownArchetypes.getItemCount() == 0) {
                            ChooseArchetypeWizardPage.this.setErrorMessage("No suitable archetypes found. Please make sure that the proper maven repositories are configured and indexes are up to date.");
                        } else {
                            ((RefreshArchetypesRunnable)RefreshArchetypesRunnable.this).ChooseArchetypeWizardPage.this.knownArchetypes.select(0);
                            ChooseArchetypeWizardPage.this.updateStatus(null);
                        }
                    }
                });
            }
            monitor.done();
        }
    }
}

