/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import java.io.InputStream;
import java.util.Map;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.core.MutableRoot;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexProvider;
import org.apache.jackrabbit.oak.plugins.tree.ReadOnly;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.QueryEngineImpl;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public final class ImmutableRoot
implements Root,
ReadOnly {
    private final ImmutableTree rootTree;
    private final AuthInfo authInfo;
    private final String wspName;

    public ImmutableRoot(@NotNull NodeState rootState) {
        this(new ImmutableTree(rootState));
    }

    public ImmutableRoot(@NotNull Root root) {
        if (root instanceof MutableRoot) {
            this.rootTree = new ImmutableTree(((MutableRoot)root).getBaseState());
            this.authInfo = root.getContentSession().getAuthInfo();
            this.wspName = root.getContentSession().getWorkspaceName();
        } else if (root instanceof ImmutableRoot) {
            ImmutableRoot ir = (ImmutableRoot)root;
            this.rootTree = ir.getTree("/");
            this.authInfo = ir.authInfo;
            this.wspName = ir.wspName;
        } else {
            throw new IllegalArgumentException("Unsupported Root implementation: " + String.valueOf(root.getClass()));
        }
    }

    public ImmutableRoot(@NotNull ImmutableTree rootTree) {
        Validate.checkArgument(rootTree.isRoot());
        this.rootTree = rootTree;
        this.authInfo = AuthInfo.EMPTY;
        this.wspName = null;
    }

    public static ImmutableRoot getInstance(@NotNull Root root) {
        if (root instanceof ImmutableRoot) {
            return (ImmutableRoot)root;
        }
        return new ImmutableRoot(root);
    }

    @Override
    @NotNull
    public ImmutableTree getTree(@NotNull String path) {
        Validate.checkArgument(PathUtils.isAbsolute(path));
        ImmutableTree child = this.rootTree;
        for (String name : PathUtils.elements(path)) {
            child = child.getChild(name);
        }
        return child;
    }

    @Override
    public boolean move(String sourcePath, String destPath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void commit(@NotNull Map<String, Object> info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void commit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasPendingChanges() {
        return false;
    }

    @Override
    @NotNull
    public QueryEngine getQueryEngine() {
        return new QueryEngineImpl(){

            @Override
            protected ExecutionContext getExecutionContext() {
                return new ExecutionContext(ImmutableRoot.this.rootTree.getNodeState(), ImmutableRoot.this, new QueryEngineSettings(), new PropertyIndexProvider(), null, null);
            }
        };
    }

    @Override
    @NotNull
    public Blob createBlob(@NotNull InputStream stream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(@NotNull String reference) {
        return null;
    }

    @Override
    @NotNull
    public ContentSession getContentSession() {
        return new ContentSession(){

            @Override
            @NotNull
            public AuthInfo getAuthInfo() {
                return ImmutableRoot.this.authInfo;
            }

            @Override
            public String getWorkspaceName() {
                return ImmutableRoot.this.wspName;
            }

            @Override
            @NotNull
            public Root getLatestRoot() {
                return ImmutableRoot.this;
            }

            @Override
            public void close() {
            }
        };
    }
}

