/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.util.Map;
import org.apache.storm.security.auth.IPrincipalToLocal;
import org.apache.storm.security.auth.KerberosPrincipalToLocal;
import org.apache.storm.security.auth.X509CertPrincipalToLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertOrKerberosPrincipalToLocal
implements IPrincipalToLocal {
    private static final Logger LOG = LoggerFactory.getLogger(X509CertOrKerberosPrincipalToLocal.class);
    X509CertPrincipalToLocal x509CertPrincipalToLocal;
    KerberosPrincipalToLocal kerberosPrincipalToLocal;

    @Override
    public void prepare(Map<String, Object> conf) {
        this.x509CertPrincipalToLocal = new X509CertPrincipalToLocal();
        this.kerberosPrincipalToLocal = new KerberosPrincipalToLocal();
        this.x509CertPrincipalToLocal.prepare(conf);
        this.kerberosPrincipalToLocal.prepare(conf);
    }

    @Override
    public String toLocal(String principalName) {
        String localName = null;
        try {
            localName = this.x509CertPrincipalToLocal.toLocal(principalName);
            LOG.debug("{} translates principal {} to {}", new Object[]{this.x509CertPrincipalToLocal.getClass().getCanonicalName(), principalName, localName});
        }
        catch (RuntimeException e) {
            LOG.debug("Error reading localName from x509CertPrincipalToLocal. The error will be ignored. Error: {}", (Object)e.getMessage());
        }
        if (localName == null) {
            localName = this.kerberosPrincipalToLocal.toLocal(principalName);
            LOG.debug("{} translates principal {} to {}", new Object[]{this.kerberosPrincipalToLocal.getClass().getCanonicalName(), principalName, localName});
        }
        return localName;
    }
}

