/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.server.util;

import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicInteger;

public class CircularBuffer<T> {
    private final T[] buffer;
    private final int capacity;
    private int oldest;
    private AtomicInteger numberOfElements = new AtomicInteger();

    public CircularBuffer(Class<T> clazz, int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("CircularBuffer capacity should be greater than 0");
        }
        this.buffer = (Object[])Array.newInstance(clazz, capacity);
        this.capacity = capacity;
    }

    public synchronized void write(T element) {
        int newSize = this.numberOfElements.incrementAndGet();
        if (newSize > this.capacity) {
            this.buffer[this.oldest] = element;
            ++this.oldest;
            this.oldest %= this.capacity;
            this.numberOfElements.decrementAndGet();
        } else {
            int index = (this.oldest + this.numberOfElements.get() - 1) % this.capacity;
            this.buffer[index] = element;
        }
    }

    public synchronized T take() {
        int newSize = this.numberOfElements.decrementAndGet();
        if (newSize < 0) {
            this.numberOfElements.incrementAndGet();
            return null;
        }
        T polled = this.buffer[this.oldest];
        ++this.oldest;
        this.oldest %= this.capacity;
        return polled;
    }

    public synchronized T peek() {
        if (this.numberOfElements.get() <= 0) {
            return null;
        }
        return this.buffer[this.oldest];
    }

    public int size() {
        return this.numberOfElements.get();
    }

    public boolean isEmpty() {
        return this.numberOfElements.get() <= 0;
    }

    public boolean isFull() {
        return this.numberOfElements.get() >= this.capacity;
    }

    public synchronized void reset() {
        this.numberOfElements.set(0);
    }
}

