/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.grouping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.grouping.LoadAwareCustomStreamGrouping;
import org.apache.storm.grouping.LoadMapping;
import org.apache.storm.networktopography.DNSToSwitchMapping;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.com.google.common.collect.Sets;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadAwareShuffleGrouping
implements LoadAwareCustomStreamGrouping,
Serializable {
    private static final int MAX_WEIGHT = 100;
    private static final Logger LOG = LoggerFactory.getLogger(LoadAwareShuffleGrouping.class);
    private final Map<Integer, IndexAndWeights> orig = new HashMap<Integer, IndexAndWeights>();
    @VisibleForTesting
    List<Integer>[] rets;
    @VisibleForTesting
    volatile int[] choices;
    private int capacity;
    private Random random;
    private volatile int[] prepareChoices;
    private AtomicInteger current;
    private LocalityScope currentScope;
    private NodeInfo sourceNodeInfo;
    private List<Integer> targetTasks;
    private AtomicReference<Map<Integer, NodeInfo>> taskToNodePort;
    private AtomicReference<Map<String, String>> nodeToHost;
    private Map<String, Object> conf;
    private DNSToSwitchMapping dnsToSwitchMapping;
    private Map<LocalityScope, List<Integer>> localityGroup;
    private double higherBound;
    private double lowerBound;

    @Override
    public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
        this.random = new Random();
        this.sourceNodeInfo = new NodeInfo(context.getAssignmentId(), Sets.newHashSet((Object[])new Long[]{(long)context.getThisWorkerPort()}));
        this.taskToNodePort = context.getTaskToNodePort();
        this.nodeToHost = context.getNodeToHost();
        this.targetTasks = targetTasks;
        this.capacity = targetTasks.size() == 1 ? 1 : Math.max(1000, targetTasks.size() * 5);
        this.conf = context.getConf();
        this.dnsToSwitchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance((String)this.conf.get("storm.network.topography.plugin"));
        this.localityGroup = new HashMap<LocalityScope, List<Integer>>();
        this.currentScope = LocalityScope.WORKER_LOCAL;
        this.higherBound = ObjectReader.getDouble(this.conf.get("topology.localityaware.higher.bound"));
        this.lowerBound = ObjectReader.getDouble(this.conf.get("topology.localityaware.lower.bound"));
        this.rets = new List[targetTasks.size()];
        int i = 0;
        for (int target : targetTasks) {
            this.rets[i] = Arrays.asList(target);
            this.orig.put(target, new IndexAndWeights(i));
            ++i;
        }
        this.choices = new int[this.capacity];
        this.current = new AtomicInteger(0);
        this.prepareChoices = new int[this.capacity];
        this.updateRing(null);
    }

    @Override
    public List<Integer> chooseTasks(int taskId, List<Object> values) {
        int rightNow;
        do {
            if ((rightNow = this.current.incrementAndGet()) >= this.capacity) continue;
            return this.rets[this.choices[rightNow]];
        } while (rightNow != this.capacity);
        this.current.set(0);
        return this.rets[this.choices[0]];
    }

    @Override
    public void refreshLoad(LoadMapping loadMapping) {
        this.updateRing(loadMapping);
    }

    private void refreshLocalityGroup() {
        Map<Integer, NodeInfo> cachedTaskToNodePort = this.taskToNodePort.get();
        Map<String, String> cachedNodeToHost = this.nodeToHost.get();
        Map<String, String> hostToRack = this.getHostToRackMapping(cachedTaskToNodePort, cachedNodeToHost);
        this.localityGroup.values().stream().forEach(v -> v.clear());
        for (int target : this.targetTasks) {
            LocalityScope scope = this.calculateScope(cachedTaskToNodePort, cachedNodeToHost, hostToRack, target);
            LOG.debug("targetTask {} is in LocalityScope {}", (Object)target, (Object)scope);
            if (!this.localityGroup.containsKey((Object)scope)) {
                this.localityGroup.put(scope, new ArrayList());
            }
            this.localityGroup.get((Object)scope).add(target);
        }
    }

    private List<Integer> getTargetsInScope(LocalityScope scope) {
        LocalityScope downgradeScope;
        ArrayList<Integer> rets = new ArrayList<Integer>();
        List<Integer> targetInScope = this.localityGroup.get((Object)scope);
        if (null != targetInScope) {
            rets.addAll(targetInScope);
        }
        if ((downgradeScope = LocalityScope.downgrade(scope)) != scope) {
            rets.addAll(this.getTargetsInScope(downgradeScope));
        }
        return rets;
    }

    private LocalityScope transition(LoadMapping load) {
        List<Integer> targetInScope = this.getTargetsInScope(this.currentScope);
        if (targetInScope.isEmpty()) {
            LocalityScope upScope = LocalityScope.upgrade(this.currentScope);
            if (upScope == this.currentScope) {
                throw new RuntimeException("The current scope " + String.valueOf((Object)this.currentScope) + " has no target tasks.");
            }
            this.currentScope = upScope;
            return this.transition(load);
        }
        if (null == load) {
            return this.currentScope;
        }
        double avg = targetInScope.stream().mapToDouble(key -> load.get((int)key)).average().getAsDouble();
        LocalityScope nextScope = this.currentScope;
        if (avg > this.higherBound) {
            nextScope = LocalityScope.upgrade(this.currentScope);
        } else {
            double lowerAvg;
            LocalityScope lowerScope = LocalityScope.downgrade(this.currentScope);
            List<Integer> lowerTargets = this.getTargetsInScope(lowerScope);
            if (!lowerTargets.isEmpty() && (lowerAvg = lowerTargets.stream().mapToDouble(key -> load.get((int)key)).average().getAsDouble()) < this.lowerBound) {
                nextScope = lowerScope;
            }
        }
        return nextScope;
    }

    private synchronized void updateRing(LoadMapping load) {
        this.refreshLocalityGroup();
        LocalityScope prevScope = this.currentScope;
        this.currentScope = this.transition(load);
        if (this.currentScope != prevScope) {
            this.orig.values().stream().forEach(o -> o.resetWeight());
        }
        List<Integer> targetsInScope = this.getTargetsInScope(this.currentScope);
        double min = load == null ? 0.0 : targetsInScope.stream().mapToDouble(key -> load.get((int)key)).min().getAsDouble();
        for (int target2 : targetsInScope) {
            double l;
            IndexAndWeights val = this.orig.get(target2);
            double d = l = load == null ? 0.0 : load.get(target2);
            if (l <= min + 0.05) {
                val.weight = Math.min(100, val.weight + 1);
                continue;
            }
            val.weight = Math.max(0, val.weight - 10);
        }
        long weightSum = targetsInScope.stream().mapToLong(target -> this.orig.get((Object)target).weight).sum();
        int currentIdx = 0;
        if (weightSum > 0L) {
            for (int target3 : targetsInScope) {
                IndexAndWeights indexAndWeights = this.orig.get(target3);
                int count = (int)((double)indexAndWeights.weight / (double)weightSum * (double)this.capacity);
                for (int i = 0; i < count && currentIdx < this.capacity; ++currentIdx, ++i) {
                    this.prepareChoices[currentIdx] = indexAndWeights.index;
                }
            }
            if (currentIdx > 0) {
                while (currentIdx < this.capacity) {
                    this.prepareChoices[currentIdx] = this.prepareChoices[this.random.nextInt(currentIdx)];
                    ++currentIdx;
                }
            }
        }
        if (currentIdx == 0) {
            while (currentIdx < this.capacity) {
                this.prepareChoices[currentIdx] = currentIdx % this.rets.length;
                ++currentIdx;
            }
        }
        this.shuffleArray(this.prepareChoices);
        int[] tempForSwap = this.choices;
        this.choices = this.prepareChoices;
        this.prepareChoices = tempForSwap;
        this.current.set(-1);
    }

    private void shuffleArray(int[] arr) {
        int size;
        for (int i = size = arr.length; i > 1; --i) {
            this.swap(arr, i - 1, this.random.nextInt(i));
        }
    }

    private void swap(int[] arr, int i, int j) {
        int tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    private LocalityScope calculateScope(Map<Integer, NodeInfo> taskToNodePort, Map<String, String> nodeToHost, Map<String, String> hostToRack, int target) {
        String targetRack;
        NodeInfo targetNodeInfo = taskToNodePort.get(target);
        if (targetNodeInfo == null) {
            return LocalityScope.EVERYTHING;
        }
        if (this.sourceNodeInfo.get_node().equals(targetNodeInfo.get_node())) {
            if (this.sourceNodeInfo.get_port().equals(targetNodeInfo.get_port())) {
                return LocalityScope.WORKER_LOCAL;
            }
            return LocalityScope.HOST_LOCAL;
        }
        String sourceHostname = nodeToHost.get(this.sourceNodeInfo.get_node());
        String targetHostname = nodeToHost.get(targetNodeInfo.get_node());
        String sourceRack = sourceHostname == null ? null : hostToRack.get(sourceHostname);
        String string = targetRack = targetHostname == null ? null : hostToRack.get(targetHostname);
        if (sourceRack != null && sourceRack.equals(targetRack)) {
            return LocalityScope.RACK_LOCAL;
        }
        return LocalityScope.EVERYTHING;
    }

    private Map<String, String> getHostToRackMapping(Map<Integer, NodeInfo> taskToNodePort, Map<String, String> nodeToHost) {
        HashSet<String> hosts = new HashSet<String>();
        for (int task : this.targetTasks) {
            if (taskToNodePort.containsKey(task)) {
                String node = taskToNodePort.get(task).get_node();
                String hostname = nodeToHost.get(node);
                if (hostname == null) continue;
                hosts.add(hostname);
                continue;
            }
            LOG.error("Could not find task NodeInfo from local cache.");
        }
        String node = this.sourceNodeInfo.get_node();
        String hostname = nodeToHost.get(node);
        if (hostname != null) {
            hosts.add(hostname);
        }
        return this.dnsToSwitchMapping.resolve(new ArrayList<String>(hosts));
    }

    public int getCapacity() {
        return this.capacity;
    }

    @VisibleForTesting
    public LocalityScope getCurrentScope() {
        return this.currentScope;
    }

    static enum LocalityScope {
        WORKER_LOCAL,
        HOST_LOCAL,
        RACK_LOCAL,
        EVERYTHING;


        public static LocalityScope downgrade(LocalityScope current) {
            switch (current) {
                case EVERYTHING: {
                    return RACK_LOCAL;
                }
                case RACK_LOCAL: {
                    return HOST_LOCAL;
                }
            }
            return WORKER_LOCAL;
        }

        public static LocalityScope upgrade(LocalityScope current) {
            switch (current) {
                case WORKER_LOCAL: {
                    return HOST_LOCAL;
                }
                case HOST_LOCAL: {
                    return RACK_LOCAL;
                }
            }
            return EVERYTHING;
        }
    }

    private static class IndexAndWeights {
        final int index;
        int weight;

        IndexAndWeights(int index) {
            this.index = index;
            this.weight = 100;
        }

        void resetWeight() {
            this.weight = 100;
        }
    }
}

