/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import io.dropwizard.jersey.optional.EmptyOptionalException;
import jakarta.inject.Inject;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.jspecify.annotations.Nullable;

@Provider
@Produces(value={"*/*"})
public class OptionalMessageBodyWriter
implements MessageBodyWriter<Optional<?>> {
    @Inject
    private @Nullable jakarta.inject.Provider<MessageBodyWorkers> mbw;

    public long getSize(Optional<?> entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Optional.class.isAssignableFrom(type);
    }

    public void writeTo(Optional<?> entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Type type2;
        Object entityObj = entity.orElseThrow(() -> EmptyOptionalException.INSTANCE);
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            type2 = parameterizedType.getActualTypeArguments()[0];
        } else {
            type2 = entityObj.getClass();
        }
        Class<?> innerGenericType = type2;
        MessageBodyWriter writer = ((MessageBodyWorkers)Objects.requireNonNull(this.mbw).get()).getMessageBodyWriter(entityObj.getClass(), innerGenericType, annotations, mediaType);
        writer.writeTo(entityObj, entityObj.getClass(), innerGenericType, annotations, mediaType, httpHeaders, entityStream);
    }
}

