/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.exceptions.ConnectionClosedException;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.NettyRpcConnection;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufInputStream;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundInvoker;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.ReadTimeoutHandler;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class PreambleCallHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final NettyRpcConnection conn;
    private final byte[] preambleHeader;
    private final Call preambleCall;

    PreambleCallHandler(NettyRpcConnection conn, byte[] preambleHeader, Call preambleCall) {
        this.conn = conn;
        this.preambleHeader = preambleHeader;
        this.preambleCall = preambleCall;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        NettyFutureUtils.safeWriteAndFlush((ChannelOutboundInvoker)ctx, (Object)Unpooled.directBuffer((int)this.preambleHeader.length).writeBytes(this.preambleHeader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
        try {
            this.conn.readResponse(new ByteBufInputStream(buf), new HashMap<Integer, Call>(), this.preambleCall, remoteExc -> this.exceptionCaught(ctx, (Throwable)remoteExc));
        }
        finally {
            ChannelPipeline p = ctx.pipeline();
            p.remove("PreambleCallReadTimeoutHandler");
            p.remove("PreambleCallFrameDecoder");
            p.remove((ChannelHandler)this);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.preambleCall.setException((IOException)((Object)new ConnectionClosedException("Connection closed")));
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.preambleCall.setException(IPCUtil.toIOE(cause));
    }

    public static void setup(ChannelPipeline pipeline, int readTimeoutMs, NettyRpcConnection conn, byte[] preambleHeader, Call preambleCall) {
        pipeline.addBefore("BufferCall", "PreambleCallReadTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler((long)readTimeoutMs, TimeUnit.MILLISECONDS)).addBefore("BufferCall", "PreambleCallFrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4)).addBefore("BufferCall", "PreambleCallHandler", (ChannelHandler)new PreambleCallHandler(conn, preambleHeader, preambleCall));
    }
}

