/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.zookeeper;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ZookeeperServiceDiscoveryOps
implements ServiceOps,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceOps.class);
    private static final String SERVICE_PATH = "/services";
    private final Map<NetworkService.Type, ServiceProvider<Void>> providers = new ConcurrentHashMap<NetworkService.Type, ServiceProvider<Void>>();
    @Autowired
    private CuratorFramework client;
    private ServiceDiscovery<Void> discovery;

    public void afterPropertiesSet() throws Exception {
        this.discovery = ServiceDiscoveryBuilder.builder(Void.class).client(this.client).basePath(SERVICE_PATH).build();
        this.discovery.start();
    }

    private ServiceProvider<Void> getProvider(NetworkService.Type type) {
        return this.providers.computeIfAbsent(type, t -> {
            try {
                ServiceProvider provider = this.discovery.serviceProviderBuilder().serviceName(t.name()).build();
                provider.start();
                return provider;
            }
            catch (KeymasterException e) {
                throw e;
            }
            catch (Exception e) {
                throw new KeymasterException("While preparing ServiceProvider for " + String.valueOf(type), (Throwable)e);
            }
        });
    }

    public void register(NetworkService service) {
        try {
            this.unregister(service);
            ServiceInstance instance = ServiceInstance.builder().name(service.getType().name()).address(service.getAddress()).build();
            this.discovery.registerService(instance);
        }
        catch (KeymasterException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("While registering {}", (Object)service, (Object)e);
            throw new KeymasterException((Throwable)e);
        }
    }

    public void unregister(NetworkService service) {
        try {
            this.discovery.queryForInstances(service.getType().name()).stream().filter(instance -> instance.getName().equals(service.getType().name()) && instance.getAddress().equals(service.getAddress())).findFirst().ifPresent(instance -> {
                try {
                    this.discovery.unregisterService(instance);
                }
                catch (Exception e) {
                    LOG.error("While deregistering {}", (Object)service, (Object)e);
                    throw new KeymasterException((Throwable)e);
                }
            });
        }
        catch (KeymasterException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("While registering {}", (Object)service, (Object)e);
            throw new KeymasterException((Throwable)e);
        }
    }

    private static NetworkService toNetworkService(NetworkService.Type serviceType, ServiceInstance<Void> serviceInstance) {
        NetworkService ns = new NetworkService();
        ns.setType(serviceType);
        ns.setAddress(serviceInstance.getAddress());
        return ns;
    }

    public List<NetworkService> list(NetworkService.Type serviceType) {
        try {
            return this.discovery.queryForInstances(serviceType.name()).stream().map(serviceInstance -> ZookeeperServiceDiscoveryOps.toNetworkService(serviceType, (ServiceInstance<Void>)serviceInstance)).collect(Collectors.toList());
        }
        catch (KeymasterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    public NetworkService get(NetworkService.Type serviceType) {
        ServiceInstance serviceInstance = null;
        try {
            if (!this.discovery.queryForInstances(serviceType.name()).isEmpty()) {
                serviceInstance = this.getProvider(serviceType).getInstance();
            }
        }
        catch (KeymasterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
        if (serviceInstance == null) {
            throw new KeymasterException("No services found for " + String.valueOf(serviceType));
        }
        return ZookeeperServiceDiscoveryOps.toNetworkService(serviceType, (ServiceInstance<Void>)serviceInstance);
    }
}

