/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.springframework.core.io.Resource;

public class InMemoryResourceMetadataResolver
extends DOMMetadataResolver {
    public InMemoryResourceMetadataResolver(Resource metadataResource, OpenSamlConfigBean configBean) throws IOException {
        this(metadataResource.getInputStream(), configBean);
    }

    public InMemoryResourceMetadataResolver(InputStream metadataResource, OpenSamlConfigBean configBean) {
        super(SamlUtils.getRootElementFrom(metadataResource, configBean));
        this.setParserPool(configBean.getParserPool());
        this.setResolveViaPredicatesOnly(true);
    }

    public InMemoryResourceMetadataResolver(File metadataResource, OpenSamlConfigBean configBean) throws IOException {
        this(Files.newInputStream(metadataResource.toPath(), new OpenOption[0]), configBean);
        this.setParserPool(configBean.getParserPool());
        this.setResolveViaPredicatesOnly(true);
    }
}

