/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.util.CoordinateOperations;
import org.apache.sis.referencing.util.WraparoundApplicator;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class CoordinateOperationFinder
implements Supplier<double[]> {
    private PixelInCell anchor;
    private final GridGeometry source;
    private final GridGeometry target;
    private double[] coordinates;
    private CoordinateOperation changeOfCRS;
    private boolean knowChangeOfCRS;
    private MathTransform forwardChangeOfCRS;
    private MathTransform inverseChangeOfCRS;
    private MathTransform gridToCRS;
    private MathTransform crsToGrid;
    private boolean isWraparoundNeedVerified;
    private boolean isWraparoundNeeded;
    private boolean isWraparoundApplied;
    private boolean isWraparoundDisabled;

    CoordinateOperationFinder(GridGeometry source, GridGeometry target) {
        this.source = source;
        this.target = target;
        this.anchor = PixelInCell.CELL_CORNER;
    }

    final void verifyPresenceOfCRS(boolean rs) {
        if ((rs ? this.target : this.source).isDefined(1)) {
            Objects.requireNonNull((rs ? this.source : this.target).getCoordinateReferenceSystem());
        }
    }

    final void setAnchor(PixelInCell newValue) {
        this.anchor = newValue;
        this.gridToCRS = null;
        this.crsToGrid = null;
        if (this.coordinates != null) {
            this.coordinates = null;
            this.changeOfCRS = null;
            this.forwardChangeOfCRS = null;
            this.inverseChangeOfCRS = null;
            this.knowChangeOfCRS = false;
        }
    }

    final void nowraparound() {
        this.gridToCRS = null;
        this.crsToGrid = null;
        this.forwardChangeOfCRS = null;
        this.inverseChangeOfCRS = null;
        this.isWraparoundNeeded = false;
        this.isWraparoundApplied = true;
        this.isWraparoundNeedVerified = true;
        this.isWraparoundDisabled = true;
    }

    final CoordinateReferenceSystem getTargetCRS() {
        return this.changeOfCRS != null ? this.changeOfCRS.getTargetCRS() : (this.source.isDefined(1) ? this.source.getCoordinateReferenceSystem() : null);
    }

    private CoordinateOperation changeOfCRS() throws FactoryException, TransformException {
        if (!this.knowChangeOfCRS) {
            block10: {
                ImmutableEnvelope sourceEnvelope = this.source.envelope;
                ImmutableEnvelope targetEnvelope = this.target.envelope;
                try {
                    CoordinateOperations.CONSTANT_COORDINATES.set(this);
                    if (sourceEnvelope != null && targetEnvelope != null) {
                        this.changeOfCRS = Envelopes.findOperation(sourceEnvelope, targetEnvelope);
                    }
                    if (this.changeOfCRS != null || !this.source.isDefined(1) || !this.target.isDefined(1)) break block10;
                    CoordinateReferenceSystem sourceCRS = this.source.getCoordinateReferenceSystem();
                    DefaultGeographicBoundingBox areaOfInterest = null;
                    if (sourceEnvelope != null || targetEnvelope != null) {
                        try {
                            areaOfInterest = new DefaultGeographicBoundingBox();
                            areaOfInterest.setBounds(targetEnvelope != null ? targetEnvelope : sourceEnvelope);
                        }
                        catch (TransformException e) {
                            areaOfInterest = null;
                            CoordinateOperationFinder.recoverableException("changeOfCRS", e);
                        }
                    }
                    this.changeOfCRS = CRS.findOperation(sourceCRS, this.target.getCoordinateReferenceSystem(), areaOfInterest);
                }
                catch (BackingStoreException e) {
                    throw e.unwrapOrRethrow(TransformException.class);
                }
                finally {
                    CoordinateOperations.CONSTANT_COORDINATES.remove();
                }
            }
            this.knowChangeOfCRS = true;
        }
        return this.changeOfCRS;
    }

    final MathTransform gridToGrid() throws FactoryException, TransformException {
        MathTransform step2;
        MathTransform step1 = this.gridToCRS();
        if (step1.equals(step2 = this.target.getGridToCRS(this.anchor))) {
            return MathTransforms.identity(step1.getSourceDimensions());
        }
        return MathTransforms.concatenate(step1, step2.inverse());
    }

    final MathTransform gridToCRS() throws FactoryException, TransformException {
        block2: {
            block3: {
                DirectPosition targetMedian;
                DirectPosition sourceMedian;
                CoordinateOperation changeOfCRS;
                block4: {
                    if (this.gridToCRS != null) break block2;
                    this.gridToCRS = this.source.getGridToCRS(this.anchor);
                    changeOfCRS = this.changeOfCRS();
                    if (changeOfCRS == null) break block2;
                    if (this.forwardChangeOfCRS != null) break block3;
                    this.forwardChangeOfCRS = changeOfCRS.getMathTransform();
                    if (this.isWraparoundDisabled) break block3;
                    sourceMedian = CoordinateOperationFinder.median(this.source, this.forwardChangeOfCRS);
                    targetMedian = CoordinateOperationFinder.median(this.target, null);
                    if (targetMedian != null) break block4;
                    if (sourceMedian == null) break block3;
                    targetMedian = sourceMedian;
                    sourceMedian = null;
                }
                WraparoundApplicator ap = new WraparoundApplicator(sourceMedian, targetMedian, changeOfCRS.getTargetCRS().getCoordinateSystem());
                this.forwardChangeOfCRS = ap.forDomainOfUse(this.forwardChangeOfCRS);
            }
            this.gridToCRS = MathTransforms.concatenate(this.gridToCRS, this.forwardChangeOfCRS);
        }
        return this.gridToCRS;
    }

    final MathTransform inverse() throws FactoryException, TransformException {
        MathTransform sourceCrsToGrid = this.source.getGridToCRS(this.anchor).inverse();
        CoordinateOperation changeOfCRS = this.changeOfCRS();
        if (changeOfCRS == null) {
            return sourceCrsToGrid;
        }
        if (this.inverseChangeOfCRS == null) {
            this.inverseChangeOfCRS = changeOfCRS.getMathTransform().inverse();
            if (!this.isWraparoundDisabled) {
                this.isWraparoundApplied = false;
                if (!this.isWraparoundNeedVerified) {
                    this.isWraparoundNeedVerified = true;
                    MathTransform inverseNoWrap = this.inverseChangeOfCRS;
                    MathTransform crsToGridNoWrap = MathTransforms.concatenate(inverseNoWrap, sourceCrsToGrid);
                    if (this.target.isDefined(5)) {
                        if (this.applyWraparound(sourceCrsToGrid)) {
                            this.isWraparoundNeeded = this.isWraparoundNeeded(this.target.getExtent(), this.target.getGridToCRS(this.anchor), crsToGridNoWrap, null);
                        }
                    } else if (this.source.isDefined(4)) {
                        this.isWraparoundNeeded = this.isWraparoundNeeded(this.source.getExtent(), this.gridToCRS(), crsToGridNoWrap, sourceCrsToGrid);
                    }
                    if (!this.isWraparoundNeeded) {
                        this.inverseChangeOfCRS = inverseNoWrap;
                        this.crsToGrid = crsToGridNoWrap;
                    }
                }
                if (this.isWraparoundNeeded) {
                    this.applyWraparound(sourceCrsToGrid);
                }
            }
        }
        if (this.crsToGrid == null) {
            this.crsToGrid = MathTransforms.concatenate(this.inverseChangeOfCRS, sourceCrsToGrid);
        }
        return this.crsToGrid;
    }

    private boolean isWraparoundNeeded(GridExtent extent, MathTransform extentToCRS, MathTransform crsToGridNoWrap, MathTransform sourceCrsToGrid) throws FactoryException, TransformException {
        boolean mapCorner = this.anchor == PixelInCell.CELL_CORNER;
        int extentDim = extent.getDimension();
        int gridDim = crsToGridNoWrap.getTargetDimensions();
        double[] buffer = new double[Math.max(extentToCRS.getTargetDimensions(), gridDim)];
        double[] reference = new double[Math.max(extentDim, gridDim)];
        double[] withoutWrap = new double[gridDim];
        long maskOfUppers = Numerics.bitmask(extentDim);
        while (--maskOfUppers != 0L) {
            for (int i = 0; i < extentDim; ++i) {
                long cc;
                long bit = 1L << i;
                if ((maskOfUppers & bit) == 0L) {
                    cc = extent.getLow(i);
                } else {
                    cc = extent.getHigh(i);
                    if (mapCorner && cc != Long.MAX_VALUE) {
                        ++cc;
                    }
                }
                reference[i] = cc;
            }
            extentToCRS.transform(reference, 0, buffer, 0, 1);
            crsToGridNoWrap.transform(buffer, 0, withoutWrap, 0, 1);
            if (sourceCrsToGrid == null) {
                this.crsToGrid.transform(buffer, 0, reference, 0, 1);
            }
            boolean isBufferTransformed = false;
            for (int i = 0; i < gridDim; ++i) {
                double error = Math.abs(withoutWrap[i] - reference[i]);
                if (error <= 1.0) continue;
                if (sourceCrsToGrid == null) {
                    if (Double.isNaN(reference[i])) continue;
                    return true;
                }
                if (!isBufferTransformed) {
                    isBufferTransformed = true;
                    if (!this.applyWraparound(sourceCrsToGrid)) {
                        return false;
                    }
                    this.crsToGrid.transform(buffer, 0, buffer, 0, 1);
                }
                double d = Math.abs(buffer[i] - reference[i]);
                double d2 = error <= Double.MAX_VALUE ? error : 1.0;
                if (!(d < d2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean applyWraparound(MathTransform sourceCrsToGrid) throws FactoryException, TransformException {
        if (!this.isWraparoundApplied) {
            this.isWraparoundApplied = true;
            DirectPosition sourceMedian = CoordinateOperationFinder.median(this.source, null);
            DirectPosition targetMedian = CoordinateOperationFinder.median(this.target, this.inverseChangeOfCRS);
            if (sourceMedian == null) {
                sourceMedian = targetMedian;
                targetMedian = null;
            }
            if (sourceMedian != null) {
                MathTransform inverseNoWrap = this.inverseChangeOfCRS;
                WraparoundApplicator ap = new WraparoundApplicator(targetMedian, sourceMedian, this.changeOfCRS().getSourceCRS().getCoordinateSystem());
                this.inverseChangeOfCRS = ap.forDomainOfUse(inverseNoWrap);
                if (this.inverseChangeOfCRS != inverseNoWrap) {
                    this.crsToGrid = MathTransforms.concatenate(this.inverseChangeOfCRS, sourceCrsToGrid);
                    return true;
                }
            }
        }
        return false;
    }

    private static DirectPosition median(final GridGeometry grid, final MathTransform changeOfCRS) throws TransformException {
        if (!grid.isDefined(12)) {
            return null;
        }
        return new AbstractDirectPosition(){
            private double[] coordinates;

            @Override
            public int getDimension() {
                return this.coordinates().length;
            }

            private double[] coordinates() {
                if (this.coordinates == null) {
                    try {
                        double[] poi = grid.getExtent().getPointOfInterest(PixelInCell.CELL_CENTER);
                        MathTransform tr = grid.getGridToCRS(PixelInCell.CELL_CENTER);
                        if (changeOfCRS != null) {
                            tr = MathTransforms.concatenate(tr, changeOfCRS);
                        }
                        this.coordinates = new double[tr.getTargetDimensions()];
                        tr.transform(poi, 0, this.coordinates, 0, 1);
                    }
                    catch (TransformException e) {
                        throw new BackingStoreException(e);
                    }
                }
                return this.coordinates;
            }

            @Override
            public double getOrdinate(int i) {
                double m = this.coordinates()[i];
                int power = 10 - Math.getExponent(m);
                return Math.scalb(Math.rint(Math.scalb(m, power)), -power);
            }
        };
    }

    @Override
    public double[] get() {
        if (this.coordinates == null && this.target.isDefined(12)) {
            MathTransform tr = this.target.getGridToCRS(this.anchor);
            this.coordinates = new double[tr.getTargetDimensions()];
            double[] gc = new double[tr.getSourceDimensions()];
            Arrays.fill(gc, Double.NaN);
            GridExtent extent = this.target.getExtent();
            for (int i = 0; i < gc.length; ++i) {
                long low = extent.getLow(i);
                if (low != extent.getHigh(i)) continue;
                gc[i] = low;
            }
            try {
                tr.transform(gc, 0, this.coordinates, 0, 1);
            }
            catch (TransformException e) {
                throw new BackingStoreException(e);
            }
        }
        return this.coordinates;
    }

    final void setAccuracyOf(ImageProcessor processor) {
        double accuracy = CRS.getLinearAccuracy(this.changeOfCRS);
        if (accuracy > 0.0) {
            Length qm = Quantities.create(accuracy, Units.METRE);
            Quantity<?>[] hints = processor.getPositionalAccuracyHints();
            for (int i = 0; i < hints.length; ++i) {
                if (!Units.isLinear(hints[i].getUnit())) continue;
                hints[i] = qm;
                qm = null;
            }
            if (qm != null) {
                hints = ArraysExt.append(hints, qm);
            }
            processor.setPositionalAccuracyHints(hints);
        }
    }

    private static void recoverableException(String caller, Exception e) {
        Logging.recoverableException(GridExtent.LOGGER, CoordinateOperationFinder.class, caller, e);
    }
}

