/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.SubspaceNotSpecifiedException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridClippingMode;
import org.apache.sis.coverage.grid.GridCoordinatesView;
import org.apache.sis.coverage.grid.GridExtentCRS;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.pending.jdk.Record;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.referencing.util.AxisDirections;
import org.apache.sis.referencing.util.ExtendedPrecisionMatrix;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.internal.DoubleDouble;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class GridExtent
implements Serializable,
LenientComparable {
    private static final long serialVersionUID = -4717353677844056017L;
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.raster");
    private static final Map<AxisDirection, DimensionNameType> AXIS_DIRECTIONS = Map.of(AxisDirection.COLUMN_POSITIVE, DimensionNameType.COLUMN, AxisDirection.ROW_POSITIVE, DimensionNameType.ROW, AxisDirection.UP, DimensionNameType.VERTICAL, AxisDirection.FUTURE, DimensionNameType.TIME);
    private static final DimensionNameType[] DEFAULT_TYPES = new DimensionNameType[]{DimensionNameType.COLUMN, DimensionNameType.ROW};
    private static final WeakValueHashMap<DimensionNameType[], DimensionNameType[]> POOL = new WeakValueHashMap(DimensionNameType[].class);
    private final DimensionNameType[] types;
    private final long[] coordinates;

    static long[] allocate(int dimension) throws IllegalArgumentException {
        if (dimension >= Short.MAX_VALUE) {
            throw new IllegalArgumentException(Errors.format((short)37, dimension));
        }
        return new long[dimension << 1];
    }

    private void validateCoordinates() throws IllegalArgumentException {
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            long lower = this.coordinates[i];
            long upper = this.coordinates[i + dimension];
            if (lower <= upper) continue;
            throw new IllegalArgumentException(Resources.format((short)27, this.getAxisIdentification(i, i), lower, upper));
        }
    }

    private static DimensionNameType[] validateAxisTypes(DimensionNameType[] types) throws IllegalArgumentException {
        if (types == null || ArraysExt.allEquals(types, null)) {
            return null;
        }
        if (Arrays.equals(DEFAULT_TYPES, types)) {
            return DEFAULT_TYPES;
        }
        DimensionNameType[] shared = POOL.get(types);
        if (shared == null) {
            types = (DimensionNameType[])types.clone();
            for (int i = 1; i < types.length; ++i) {
                DimensionNameType t = types[i];
                if (t == null) continue;
                int j = i;
                while (--j >= 0) {
                    if (!t.equals(types[j])) continue;
                    throw new IllegalArgumentException(Errors.format((short)24, t));
                }
            }
            shared = POOL.putIfAbsent(types, types);
            if (shared == null) {
                return types;
            }
        }
        return shared;
    }

    private GridExtent(int dimension, DimensionNameType[] axisTypes) {
        this.coordinates = GridExtent.allocate(dimension);
        this.types = GridExtent.validateAxisTypes(axisTypes);
    }

    public GridExtent(Rectangle bounds) {
        this((long)bounds.width, bounds.height);
        this.translate2D(bounds.x, bounds.y);
    }

    public GridExtent(long width, long height) {
        ArgumentChecks.ensureStrictlyPositive("width", width);
        ArgumentChecks.ensureStrictlyPositive("height", height);
        this.coordinates = new long[4];
        this.coordinates[2] = width - 1L;
        this.coordinates[3] = height - 1L;
        this.types = DEFAULT_TYPES;
    }

    GridExtent(int xmin, int ymin, int width, int height) {
        this((long)width, height);
        this.translate2D(xmin, ymin);
    }

    private void translate2D(long xmin, long ymin) {
        int i = this.coordinates.length;
        while (--i >= 0) {
            int n = i;
            this.coordinates[n] = this.coordinates[n] + ((i & 1) == 0 ? xmin : ymin);
        }
    }

    public GridExtent(DimensionNameType[] axisTypes, long[] low, long[] high, boolean isHighIncluded) {
        ArgumentChecks.ensureNonNull("high", high);
        int dimension = high.length;
        if (low != null && low.length != dimension) {
            throw new IllegalArgumentException(Errors.format((short)80, low.length, dimension));
        }
        if (axisTypes != null && axisTypes.length != dimension) {
            throw new IllegalArgumentException(Errors.format((short)77));
        }
        this.coordinates = GridExtent.allocate(dimension);
        if (low != null) {
            System.arraycopy(low, 0, this.coordinates, 0, dimension);
        }
        System.arraycopy(high, 0, this.coordinates, dimension, dimension);
        if (!isHighIncluded) {
            for (int i = dimension; i < this.coordinates.length; ++i) {
                this.coordinates[i] = Math.decrementExact(this.coordinates[i]);
            }
        }
        this.types = GridExtent.validateAxisTypes(axisTypes);
        this.validateCoordinates();
    }

    static DimensionNameType[] typeFromAxes(CoordinateReferenceSystem crs, int dimension) {
        DimensionNameType[] axisTypes = null;
        if (crs != null) {
            CoordinateSystem cs = crs.getCoordinateSystem();
            for (int i = 0; i < dimension; ++i) {
                DimensionNameType type = AXIS_DIRECTIONS.get(AxisDirections.absolute(cs.getAxis(i).getDirection()));
                if (type == null) continue;
                if (axisTypes == null) {
                    axisTypes = new DimensionNameType[dimension];
                }
                axisTypes[i] = type;
            }
        }
        return axisTypes;
    }

    GridExtent(AbstractEnvelope envelope, GridRoundingMode rounding, GridClippingMode clipping, int[] margin, int[] chunkSize, GridExtent enclosing, int[] modifiedDimensions) {
        int dimension = envelope.getDimension();
        this.coordinates = enclosing != null ? (long[])enclosing.coordinates.clone() : GridExtent.allocate(dimension);
        this.types = enclosing != null && enclosing.types != null ? enclosing.types : GridExtent.validateAxisTypes(GridExtent.typeFromAxes(envelope.getCoordinateReferenceSystem(), dimension));
        for (int i = 0; i < dimension; ++i) {
            int hi;
            long upper;
            long lower;
            boolean isMaxValid;
            double min = envelope.getLower(i);
            double max = envelope.getUpper(i);
            boolean isMinValid = min >= -9.223372036854776E18;
            boolean bl = isMaxValid = max <= 9.223372036854776E18;
            if (min > max || enclosing == null && !(isMinValid & isMaxValid)) {
                throw new IllegalArgumentException(Resources.format((short)27, this.getAxisIdentification(i, i), min, max));
            }
            if (!isMinValid) {
                min = -9.223372036854776E18;
            }
            if (!isMaxValid) {
                max = 9.223372036854776E18;
            }
            switch (rounding) {
                default: {
                    throw new AssertionError((Object)rounding);
                }
                case ENCLOSING: {
                    lower = (long)Math.floor(min);
                    upper = (long)Math.ceil(max);
                    if (lower == upper) break;
                    --upper;
                    break;
                }
                case CONTAINED: {
                    double lo = Math.ceil(min);
                    double hi2 = Math.floor(max);
                    if (lo > hi2) {
                        upper = lower = (long)(lo - min > max - hi2 ? hi2 : lo);
                        break;
                    }
                    lower = (long)lo;
                    upper = (long)hi2;
                    if (lower == upper) break;
                    --upper;
                    break;
                }
                case NEAREST: {
                    double span;
                    long extent;
                    long delta;
                    lower = Math.round(min);
                    upper = Math.round(max);
                    if (lower == upper) {
                        if (!(min - Math.floor(min) > Math.ceil(max) - max)) break;
                        upper = --lower;
                        break;
                    }
                    if ((delta = --upper - lower + 1L) < 0L || (extent = Math.round(span = envelope.getSpan(i))) == 0L || Math.abs(delta -= extent) != 1L) break;
                    double dmin = Math.abs(min - Math.rint(min));
                    double dmax = Math.abs(max - Math.rint(max));
                    boolean adjustMax = dmax >= dmin;
                    double d = Math.abs(span - (double)extent);
                    double d2 = adjustMax ? dmax : dmin;
                    if (!(d < d2)) break;
                    if (adjustMax) {
                        upper = Math.subtractExact(upper, delta);
                        break;
                    }
                    lower = Math.addExact(lower, delta);
                }
            }
            if (enclosing != null && clipping == GridClippingMode.BORDER_EXPANSION) {
                long hv;
                int lo = modifiedDimensions != null ? modifiedDimensions[i] : i;
                hi = lo + this.getDimension();
                long lv = Math.max(lower, this.coordinates[lo]);
                if (lv > (hv = Math.min(upper, this.coordinates[hi]))) {
                    throw new DisjointExtentException(this.getAxisIdentification(lo, i), this.coordinates[lo], this.coordinates[hi], lv, hv);
                }
                lower = lv;
                upper = hv;
            }
            if (margin != null && i < margin.length) {
                int m = margin[i];
                if (enclosing != null && m > 0) {
                    if (lower < (lower -= (long)m)) {
                        lower = Long.MIN_VALUE;
                    }
                    if (upper > (upper += (long)m)) {
                        upper = Long.MAX_VALUE;
                    }
                } else {
                    lower = Math.subtractExact(lower, (long)m);
                    upper = Math.addExact(upper, (long)m);
                }
            }
            if (lower > upper) {
                upper += lower - upper >>> 1;
                lower = upper;
            }
            if (chunkSize != null && i < chunkSize.length) {
                int s = chunkSize[i];
                lower = Math.subtractExact(lower, (long)Math.floorMod(lower, s));
                upper = Math.addExact(upper, (long)(s - 1 - Math.floorMod(upper, s)));
            }
            if (enclosing != null && clipping == GridClippingMode.STRICT) {
                int lo = modifiedDimensions != null ? modifiedDimensions[i] : i;
                hi = lo + this.getDimension();
                long validMin = this.coordinates[lo];
                long validMax = this.coordinates[hi];
                if (lower > validMin) {
                    this.coordinates[lo] = lower;
                }
                if (upper < validMax) {
                    this.coordinates[hi] = upper;
                }
                if (lower <= validMax && upper >= validMin) continue;
                throw new DisjointExtentException(this.getAxisIdentification(lo, i), validMin, validMax, lower, upper);
            }
            this.coordinates[i] = lower;
            this.coordinates[i + this.getDimension()] = upper;
        }
    }

    GridExtent(GridExtent enclosing, long[] coordinates) {
        this.coordinates = coordinates;
        DimensionNameType[] dimensionNameTypeArray = this.types = enclosing != null ? enclosing.types : null;
        assert (this.types == null || this.types.length == this.getDimension());
    }

    private GridExtent(GridExtent extent) {
        this.types = extent.types;
        this.coordinates = (long[])extent.coordinates.clone();
    }

    public final int getDimension() {
        return this.coordinates.length >>> 1;
    }

    final int getSubDimension() {
        int n = 0;
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (this.coordinates[i] == this.coordinates[i + dimension]) continue;
            ++n;
        }
        return n;
    }

    public boolean startsAtZero() {
        return GridExtent.isZero(this.coordinates, this.getDimension());
    }

    private static boolean isZero(long[] vector, int n) {
        while (--n >= 0) {
            if (vector[n] == 0L) continue;
            return false;
        }
        return true;
    }

    GridCoordinatesView getLow() {
        return new GridCoordinatesView(this.coordinates, 0);
    }

    GridCoordinatesView getHigh() {
        return new GridCoordinatesView(this.coordinates, this.getDimension());
    }

    public long getLow(int index) {
        ArgumentChecks.ensureValidIndex(this.getDimension(), index);
        return this.coordinates[index];
    }

    public long getHigh(int index) {
        int dimension = this.getDimension();
        ArgumentChecks.ensureValidIndex(dimension, index);
        return this.coordinates[index + dimension];
    }

    public long getMedian(int index) {
        int dimension = this.getDimension();
        ArgumentChecks.ensureValidIndex(dimension, index);
        long low = this.coordinates[index];
        long high = this.coordinates[index + dimension];
        return (low >> 1) + (high >> 1) + ((low | high) & 1L);
    }

    public long getRelative(int index, double ratio) {
        if (ratio == 0.5) {
            return this.getMedian(index);
        }
        if (ratio == 1.0) {
            return this.getHigh(index);
        }
        return Math.addExact(this.getLow(index), Math.round(this.getSize(index, true) * ratio));
    }

    public long getSize(int index) {
        int dimension = this.getDimension();
        ArgumentChecks.ensureValidIndex(dimension, index);
        return Math.incrementExact(Math.subtractExact(this.coordinates[dimension + index], this.coordinates[index]));
    }

    public double getSize(int index, boolean minusOne) {
        int dimension = this.getDimension();
        ArgumentChecks.ensureValidIndex(dimension, index);
        long size = this.coordinates[dimension + index] - this.coordinates[index];
        if (!minusOne && ++size == 0L) {
            return 1.8446744073709552E19;
        }
        return Numerics.toUnsignedDouble(size);
    }

    final long[] getCoordinates() {
        return (long[])this.coordinates.clone();
    }

    public double[] getPointOfInterest(PixelInCell anchor) {
        int dimension = this.getDimension();
        double[] center = new double[dimension];
        boolean isCorner = PixelInCell.CELL_CORNER.equals(anchor);
        for (int i = 0; i < dimension; ++i) {
            long low = this.coordinates[i];
            if (isCorner) {
                low = Math.incrementExact(this.coordinates[i]);
            }
            center[i] = MathFunctions.average(low, this.coordinates[i + dimension]);
        }
        return center;
    }

    public SortedMap<Integer, Long> getSliceCoordinates() {
        TreeMap<Integer, Long> slice = new TreeMap<Integer, Long>();
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            long value = this.coordinates[i];
            if (value != this.coordinates[i + dimension]) continue;
            slice.put(i, value);
        }
        return slice;
    }

    public int[] getSubspaceDimensions(int numDim) {
        int i;
        int m = this.ensureValidDimension(numDim);
        int[] selected = new int[numDim];
        int count = 0;
        for (i = 0; i < m; ++i) {
            long low = this.coordinates[i];
            long high = this.coordinates[i + m];
            if (low == high) continue;
            if (count < numDim) {
                selected[count++] = i;
                continue;
            }
            long size = high - low;
            if (size != -1L) {
                ++size;
            }
            throw new SubspaceNotSpecifiedException(Resources.format((short)50, numDim, this.getAxisIdentification(i, i), Numerics.toUnsignedDouble(size)));
        }
        if (numDim != count) {
            i = 0;
            while (true) {
                if (this.coordinates[i] == this.coordinates[i + m]) {
                    selected[count++] = i;
                    if (count == numDim) break;
                }
                ++i;
            }
            Arrays.sort(selected);
        }
        return selected;
    }

    private int ensureValidDimension(int numDim) {
        ArgumentChecks.ensurePositive("numDim", numDim);
        int m = this.getDimension();
        if (numDim > m) {
            throw new CannotEvaluateException(Resources.format((short)22, numDim));
        }
        return m;
    }

    public int[] getLargestDimensions(int numDim) {
        return DimSize.sort(this.coordinates, this.ensureValidDimension(numDim), numDim);
    }

    public Optional<DimensionNameType> getAxisType(int index) {
        ArgumentChecks.ensureValidIndex(this.getDimension(), index);
        return Optional.ofNullable(this.types != null ? this.types[index] : null);
    }

    final DimensionNameType[] getAxisTypes() {
        return this.types != null ? this.types : DEFAULT_TYPES;
    }

    final Object getAxisIdentification(int index, int indexShown) {
        DimensionNameType type;
        if (this.types != null && (type = this.types[index]) != null) {
            return indexShown + " (" + Types.getCodeTitle(type) + ")";
        }
        return indexShown;
    }

    public GridExtent withRange(int index, long low, long high) {
        int ih = this.getDimension();
        ArgumentChecks.ensureValidIndex(ih, index);
        if (this.coordinates[index] == low && this.coordinates[ih += index] == high) {
            return this;
        }
        if (low > high) {
            throw new IllegalArgumentException(Resources.format((short)27, this.getAxisIdentification(index, index), low, high));
        }
        GridExtent copy = new GridExtent(this);
        copy.coordinates[index] = low;
        copy.coordinates[ih] = high;
        return copy;
    }

    public GeneralEnvelope toEnvelope(MathTransform cornerToCRS) throws TransformException {
        ArgumentChecks.ensureNonNull("cornerToCRS", cornerToCRS);
        GeneralEnvelope envelope = this.toEnvelope(cornerToCRS, cornerToCRS, null);
        Matrix gridToCRS = MathTransforms.getMatrix(cornerToCRS);
        if (gridToCRS != null && Matrices.isAffine(gridToCRS)) {
            try {
                envelope.setCoordinateReferenceSystem(GridExtentCRS.forExtentAlone(gridToCRS, this.getAxisTypes()));
            }
            catch (FactoryException e) {
                throw new TransformException(e.getMessage(), e);
            }
        }
        return envelope;
    }

    final GeneralEnvelope toEnvelope(MathTransform cornerToCRS, MathTransform gridToCRS, Envelope fallback) throws TransformException {
        GeneralEnvelope envelope = Envelopes.transform(cornerToCRS, (Envelope)this.toEnvelope());
        this.complete(envelope, gridToCRS, gridToCRS != cornerToCRS, fallback);
        return envelope;
    }

    final GeneralEnvelope toEnvelope() {
        int dimension = this.getDimension();
        GeneralEnvelope envelope = new GeneralEnvelope(dimension);
        for (int i = 0; i < dimension; ++i) {
            long high = this.coordinates[i + dimension];
            if (high != Long.MAX_VALUE) {
                ++high;
            }
            envelope.setRange(i, this.coordinates[i], high);
        }
        return envelope;
    }

    final GeneralEnvelope[] toEnvelopes(MathTransform cornerToCRS, MathTransform gridToCRS, Envelope fallback) throws TransformException {
        GeneralEnvelope[] envelopes;
        for (GeneralEnvelope envelope : envelopes = Envelopes.wraparound(cornerToCRS, this.toEnvelope())) {
            this.complete(envelope, gridToCRS, gridToCRS != cornerToCRS, fallback);
        }
        return envelopes;
    }

    private void complete(GeneralEnvelope envelope, MathTransform gridToCRS, boolean isCenter, Envelope fallback) {
        if (envelope.isEmpty()) {
            try {
                int dimension = this.getDimension();
                TransformSeparator separator = null;
                for (int srcDim = 0; srcDim < dimension; ++srcDim) {
                    if (this.coordinates[srcDim + dimension] != 0L || this.coordinates[srcDim] != 0L) continue;
                    if (separator == null) {
                        separator = new TransformSeparator(gridToCRS);
                    }
                    separator.addSourceDimensionRange(srcDim, srcDim + 1);
                    Matrix component = MathTransforms.getMatrix(separator.separate());
                    if (component != null) {
                        int[] targets = separator.getTargetDimensions();
                        for (int j = 0; j < targets.length; ++j) {
                            int tgtDim = targets[j];
                            double lower = envelope.getLower(tgtDim);
                            double upper = envelope.getUpper(tgtDim);
                            double value = component.getElement(j, component.getNumCol() - 1);
                            if (isCenter) {
                                double span = upper - value;
                                if (Double.isNaN(span) && Double.isNaN(span = value - lower)) {
                                    span = 0.0;
                                }
                                if (Double.isNaN(lower)) {
                                    lower = value - span;
                                }
                                if (Double.isNaN(upper)) {
                                    upper = value + span;
                                }
                            } else if (Double.isNaN(lower)) {
                                lower = value;
                            }
                            envelope.setRange(tgtDim, lower, upper);
                        }
                    }
                    separator.clear();
                }
                if (fallback != null) {
                    int tgtDim = envelope.getDimension();
                    while (--tgtDim >= 0) {
                        boolean modified = false;
                        double lower = envelope.getLower(tgtDim);
                        double upper = envelope.getUpper(tgtDim);
                        if (Double.isNaN(lower)) {
                            lower = fallback.getMinimum(tgtDim);
                            modified = true;
                        }
                        if (Double.isNaN(upper)) {
                            upper = fallback.getMaximum(tgtDim);
                            modified = true;
                        }
                        if (!modified || lower > upper) continue;
                        envelope.setRange(tgtDim, lower, upper);
                    }
                }
            }
            catch (FactoryException e) {
                Logging.recoverableException(LOGGER, GridExtent.class, "toEnvelope", e);
            }
        }
    }

    public GridExtent insertDimension(int index, DimensionNameType axisType, long low, long high, boolean isHighIncluded) {
        int dimension = this.getDimension();
        ArgumentChecks.ensureValidIndex(dimension + 1, index);
        if (!isHighIncluded) {
            high = Math.decrementExact(high);
        }
        int newDim = dimension + 1;
        DimensionNameType[] axisTypes = null;
        if (this.types != null || axisType != null) {
            axisTypes = this.types != null ? ArraysExt.insert(this.types, index, 1) : new DimensionNameType[newDim];
            axisTypes[index] = axisType;
        }
        GridExtent ex = new GridExtent(newDim, axisTypes);
        System.arraycopy(this.coordinates, 0, ex.coordinates, 0, index);
        System.arraycopy(this.coordinates, index, ex.coordinates, index + 1, dimension - index);
        System.arraycopy(this.coordinates, dimension, ex.coordinates, newDim, index);
        System.arraycopy(this.coordinates, dimension + index, ex.coordinates, newDim + index + 1, dimension - index);
        ex.coordinates[index] = low;
        ex.coordinates[index + newDim] = high;
        ex.validateCoordinates();
        return ex;
    }

    public GridExtent selectDimensions(int ... indices) {
        return (indices = GridExtent.verifyDimensions(indices, this.getDimension())) != null ? this.reorder(indices) : this;
    }

    static int[] verifyDimensions(int[] indices, int limit) {
        ArgumentChecks.ensureNonNull("indices", indices);
        int n = indices.length;
        ArgumentChecks.ensureCountBetween("indices", false, 1, limit, n);
        indices = (int[])indices.clone();
        if (!ArraysExt.isSorted(indices, true)) {
            throw new IllegalArgumentException(Resources.format((short)54));
        }
        int d = indices[0];
        if (d >= 0 && (d = indices[n - 1]) < limit) {
            return (int[])(n != limit ? indices : null);
        }
        throw new IndexOutOfBoundsException(Errors.format((short)71, d));
    }

    final GridExtent reorder(int[] indices) {
        int sd = this.getDimension();
        int td = indices.length;
        DimensionNameType[] tt = null;
        if (this.types != null) {
            tt = new DimensionNameType[td];
            for (int i = 0; i < td; ++i) {
                tt[i] = this.types[indices[i]];
            }
        }
        GridExtent sub = new GridExtent(td, tt);
        for (int i = 0; i < td; ++i) {
            int j = indices[i];
            sub.coordinates[i] = this.coordinates[j];
            sub.coordinates[i + td] = this.coordinates[j + sd];
        }
        return sub;
    }

    public GridExtent expand(long ... margins) {
        ArgumentChecks.ensureNonNull("margins", margins);
        int m = this.getDimension();
        int length = Math.min(m, margins.length);
        if (GridExtent.isZero(margins, length)) {
            return this;
        }
        GridExtent resized = new GridExtent(this);
        long[] c = resized.coordinates;
        for (int i = 0; i < length; ++i) {
            long p = margins[i];
            c[i] = Math.subtractExact(c[i], p);
            c[i + m] = Math.addExact(c[i + m], p);
        }
        return resized;
    }

    final GridExtent forChunkSize(int ... sizes) {
        int m = this.getDimension();
        int length = Math.min(m, sizes.length);
        GridExtent resized = new GridExtent(this);
        long[] c = resized.coordinates;
        for (int i = 0; i < length; ++i) {
            int s = sizes[i];
            int j = i + m;
            c[i] = Math.subtractExact(c[i], (long)Math.floorMod(c[i], s));
            c[j] = Math.addExact(c[j], (long)(s - 1 - Math.floorMod(c[j], s)));
        }
        return resized;
    }

    public GridExtent resize(long ... sizes) {
        ArgumentChecks.ensureNonNull("sizes", sizes);
        int m = this.getDimension();
        int length = Math.min(m, sizes.length);
        GridExtent resize = new GridExtent(this);
        long[] c = resize.coordinates;
        for (int i = 0; i < length; ++i) {
            long size = sizes[i];
            if (size <= 0L) {
                throw new IllegalArgumentException(Errors.format((short)165, Strings.toIndexed("sizes", i), size));
            }
            long lower = c[i];
            long upper = c[i + m];
            long current = Math.incrementExact(Math.subtractExact(upper, lower));
            if (Math.abs(lower) <= Math.abs(upper)) {
                lower = Numerics.multiplyDivide(lower, size, current);
                upper = Math.addExact(lower, size - 1L);
            } else {
                upper = Numerics.multiplyDivide(upper, size, current);
                lower = Math.subtractExact(upper, size - 1L);
            }
            c[i] = lower;
            c[i + m] = upper;
        }
        return Arrays.equals(c, this.coordinates) ? this : resize;
    }

    public GridExtent subsample(int ... periods) {
        ArgumentChecks.ensureNonNull("periods", periods);
        int m = this.getDimension();
        int length = Math.min(m, periods.length);
        GridExtent sub = new GridExtent(this);
        for (int i = 0; i < length; ++i) {
            int s = periods[i];
            if (s > 1) {
                int j = i + m;
                long low = this.coordinates[i];
                long size = this.coordinates[j] - low + 1L;
                if (size == 0L) {
                    throw new ArithmeticException(Errors.format((short)10, 64));
                }
                long r = Long.divideUnsigned(size, s);
                if (r * (long)s == size) {
                    --r;
                }
                sub.coordinates[i] = low /= (long)s;
                sub.coordinates[j] = low + r;
                continue;
            }
            if (s > 0) continue;
            throw new IllegalArgumentException(Errors.format((short)165, Strings.toIndexed("periods", i), s));
        }
        return Arrays.equals(this.coordinates, sub.coordinates) ? this : sub;
    }

    public GridExtent upsample(int ... periods) {
        ArgumentChecks.ensureNonNull("periods", periods);
        int m = this.getDimension();
        int length = Math.min(m, periods.length);
        GridExtent sub = new GridExtent(this);
        for (int i = 0; i < length; ++i) {
            int s = periods[i];
            if (s > 1) {
                int j = i + m;
                sub.coordinates[i] = Math.multiplyExact(this.coordinates[i], s);
                sub.coordinates[j] = Math.addExact(Math.multiplyExact(this.coordinates[j], s), (long)(s - 1));
                continue;
            }
            if (s > 0) continue;
            throw new IllegalArgumentException(Errors.format((short)165, Strings.toIndexed("periods", i), s));
        }
        return Arrays.equals(this.coordinates, sub.coordinates) ? this : sub;
    }

    final GridExtent sliceByRatio(DirectPosition slicePoint, double sliceRatio, int[] dimensionsToKeep) {
        int i = slicePoint.getDimension();
        while (--i >= 0) {
            slicePoint.setOrdinate(i, Math.fma(sliceRatio, this.getSize(i, true), (double)this.getLow(i)));
        }
        for (i = 0; i < dimensionsToKeep.length; ++i) {
            slicePoint.setOrdinate(dimensionsToKeep[i], Double.NaN);
        }
        return this.slice(slicePoint, null);
    }

    final GridExtent slice(DirectPosition slicePoint, int[] modifiedDimensions) {
        GridExtent slice = new GridExtent(this);
        int n = slicePoint.getDimension();
        int m = this.getDimension();
        for (int k = 0; k < n; ++k) {
            double p = slicePoint.getOrdinate(k);
            if (Double.isNaN(p)) continue;
            long c = Math.round(p);
            int i = modifiedDimensions != null ? modifiedDimensions[k] : k;
            long low = this.coordinates[i];
            long high = this.coordinates[i + m];
            if (c >= low && c <= high) {
                slice.coordinates[i + m] = slice.coordinates[i] = c;
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (int j = 0; j < n; ++j) {
                if (j != 0) {
                    b.append(", ");
                }
                if (Double.isNaN(p = slicePoint.getOrdinate(j))) {
                    b.append("NaN");
                    continue;
                }
                b.append(Math.round(p));
            }
            throw new PointOutsideCoverageException(Resources.format((short)21, this.getAxisIdentification(i, k), low, high, b.toString()));
        }
        return Arrays.equals(this.coordinates, slice.coordinates) ? this : slice;
    }

    final MatrixSIS cornerToCRS(Envelope env, long flippedAxes, int[] sourceDimensions) {
        int srcDim = this.getDimension();
        int tgtDim = env.getDimension();
        MatrixSIS affine = Matrices.create(tgtDim + 1, srcDim + 1, ExtendedPrecisionMatrix.CREATE_ZERO);
        for (int j = 0; j < tgtDim; ++j) {
            DoubleDouble scale;
            int i;
            int n = i = sourceDimensions != null ? sourceDimensions[j] : j;
            if (i < srcDim) {
                boolean flip = (flippedAxes & Numerics.bitmask(j)) != 0L;
                DoubleDouble offset = DoubleDouble.of(this.coordinates[i]);
                DoubleDouble size = DoubleDouble.of(this.coordinates[i + srcDim]).subtract(offset).add(1);
                scale = DoubleDouble.of(env.getSpan(j), true).divide(size);
                if (flip) {
                    scale = scale.negate();
                }
                if (!offset.isZero()) {
                    offset = offset.multiply(scale).negate();
                }
                offset = offset.add(flip ? env.getMaximum(j) : env.getMinimum(j), true);
                affine.setNumber(j, srcDim, offset);
            } else {
                scale = DoubleDouble.NaN;
            }
            affine.setNumber(j, i, scale);
        }
        affine.setElement(tgtDim, srcDim, 1.0);
        return affine;
    }

    public GridExtent translate(long ... translation) {
        ArgumentChecks.ensureNonNull("translation", translation);
        int m = this.getDimension();
        int length = Math.min(m, translation.length);
        if (GridExtent.isZero(translation, length)) {
            return this;
        }
        GridExtent translated = new GridExtent(this);
        long[] c = translated.coordinates;
        for (int i = 0; i < length; ++i) {
            int j = i + m;
            long t = translation[i];
            c[i] = Math.addExact(c[i], t);
            c[j] = Math.addExact(c[j], t);
        }
        return translated;
    }

    public boolean contains(long ... cell) {
        ArgumentChecks.ensureNonNull("cell", cell);
        int m = this.getDimension();
        int length = Math.min(m, cell.length);
        for (int i = 0; i < length; ++i) {
            long c = cell[i];
            if (c >= this.coordinates[i] && c <= this.coordinates[i + m]) continue;
            return false;
        }
        return true;
    }

    public GridExtent intersect(GridExtent other) {
        return this.combine(other, false);
    }

    public GridExtent union(GridExtent other) {
        return this.combine(other, true);
    }

    private GridExtent combine(GridExtent other, boolean union) {
        int i;
        this.ensureSameAxes(other, "other");
        int n = this.coordinates.length;
        int m = n >>> 1;
        long[] clipped = new long[n];
        for (i = 0; i < m; ++i) {
            clipped[i] = GridExtent.extremum(this.coordinates[i], other.coordinates[i], !union);
        }
        while (i < n) {
            clipped[i] = GridExtent.extremum(this.coordinates[i], other.coordinates[i], union);
            ++i;
        }
        if (Arrays.equals(clipped, this.coordinates)) {
            return this;
        }
        if (Arrays.equals(clipped, other.coordinates)) {
            return other;
        }
        if (!union) {
            for (i = 0; i < m; ++i) {
                if (clipped[i] <= clipped[i + m]) continue;
                throw new DisjointExtentException(this, other, i);
            }
        }
        return new GridExtent(this, clipped);
    }

    private static long extremum(long a, long b, boolean max) {
        return max ? Math.max(a, b) : Math.min(a, b);
    }

    final void ensureSameAxes(GridExtent other, String param) {
        int n = this.coordinates.length;
        int m = n >>> 1;
        if (n != other.coordinates.length) {
            throw new MismatchedDimensionException(Errors.format((short)81, param, m, other.getDimension()));
        }
        if (this.types != other.types && this.types != null && other.types != null) {
            for (int i = 0; i < m; ++i) {
                DimensionNameType t2;
                DimensionNameType t1 = this.types[i];
                if (t1 == null || (t2 = other.types[i]) == null || t1.equals(t2)) continue;
                throw new IllegalArgumentException(Errors.format((short)200, i, t1, t2));
            }
        }
    }

    final boolean isSameSize(GridExtent other) {
        if (other == null || this.coordinates.length != other.coordinates.length) {
            return false;
        }
        int dimension = this.getDimension();
        long[] oc = other.coordinates;
        for (int i = 0; i < dimension; ++i) {
            if (this.coordinates[i + dimension] - this.coordinates[i] == oc[i + dimension] - oc[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof GridExtent) {
            GridExtent other = (GridExtent)object;
            if (Arrays.equals(this.coordinates, other.coordinates)) {
                switch (mode) {
                    case STRICT: {
                        if (!this.getClass().equals(object.getClass())) {
                            return false;
                        }
                    }
                    case BY_CONTRACT: {
                        if (Arrays.equals(this.types, other.types)) break;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.coordinates) + Arrays.hashCode(this.types) ^ 0xD838F82F;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(256);
        try {
            this.appendTo(out, Vocabulary.getResources((Locale)null));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.toString();
    }

    final void appendTo(Appendable out, Vocabulary vocabulary) throws IOException {
        TableAppender table = new TableAppender(out, "");
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            InternationalString title;
            String name = null;
            if (this.types != null && (title = Types.getCodeTitle(this.types[i])) != null) {
                name = title.toString(vocabulary.getLocale());
            }
            if (name == null) {
                name = vocabulary.getString((short)64, i);
            }
            long lower = this.coordinates[i];
            long upper = this.coordinates[i + dimension];
            table.setCellAlignment((byte)-1);
            table.append(name).append(": ").nextColumn();
            table.append('[').nextColumn();
            table.setCellAlignment((byte)1);
            table.append(Long.toString(lower)).append(" \u2026 ").nextColumn();
            table.append(Long.toString(upper)).append("] ").nextColumn();
            table.append('(').append(vocabulary.getString((short)22, GridExtent.toSizeString(upper - lower + 1L))).append(')').nextLine();
        }
        table.flush();
    }

    static String toSizeString(long size) {
        return size != 0L ? Long.toUnsignedString(size) : "2\u2076\u2074";
    }

    private static final class DimSize
    extends Record
    implements Comparable<DimSize> {
        private final int dim;
        private final long size;

        private DimSize(int dim, long size) {
            this.dim = dim;
            this.size = size;
        }

        @Override
        public int compareTo(DimSize other) {
            int c = Long.compareUnsigned(other.size, this.size);
            if (c == 0) {
                c = Integer.compare(this.dim, other.dim);
            }
            return c;
        }

        static int[] sort(long[] coordinates, int m, int numDim) {
            if (numDim == m) {
                return ArraysExt.range(0, numDim);
            }
            Object[] sizes = new DimSize[m];
            for (int i = 0; i < m; ++i) {
                sizes[i] = new DimSize(i, coordinates[m + i] - coordinates[i]);
            }
            Arrays.sort(sizes);
            int[] result = new int[numDim];
            for (int i = 0; i < numDim; ++i) {
                result[i] = ((DimSize)sizes[i]).dim;
            }
            Arrays.sort(result);
            return result;
        }
    }
}

