/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

final class CurveExtremum {
    double ex1;
    double ey1;
    double ex2;
    double ey2;

    CurveExtremum() {
    }

    void resolve(double x1, double y1, double dy1, double x2, double y2, double dy2) {
        double d = (dy2 - dy1) / (x2 -= x1);
        double w = (dy1 - (y2 -= y1) / x2) / x2;
        double D = (2.0 * w + d) / x2;
        double C = -3.0 * w - d;
        double a = 3.0 * D;
        double b = 2.0 * C;
        double q = -0.5 * (b + Math.copySign(Math.sqrt(b * b - 4.0 * a * dy1), b));
        double r1 = q / a;
        double r2 = dy1 / q;
        this.ex1 = x1 + r1;
        this.ex2 = x1 + r2;
        this.ey1 = y1 + r1 * (dy1 + r1 * (C + r1 * D));
        this.ey2 = y1 + r2 * (dy1 + r2 * (C + r2 * D));
    }
}

