/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.esri;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorCentroid2D;
import com.esri.core.geometry.OperatorContains;
import com.esri.core.geometry.OperatorCrosses;
import com.esri.core.geometry.OperatorDisjoint;
import com.esri.core.geometry.OperatorEquals;
import com.esri.core.geometry.OperatorExportToWkt;
import com.esri.core.geometry.OperatorIntersects;
import com.esri.core.geometry.OperatorOverlaps;
import com.esri.core.geometry.OperatorSimpleRelation;
import com.esri.core.geometry.OperatorTouches;
import com.esri.core.geometry.OperatorWithin;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWithCRS;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.geometry.wrapper.esri.Factory;
import org.apache.sis.pending.geoapi.filter.SpatialOperatorName;
import org.opengis.geometry.DirectPosition;

final class Wrapper
extends GeometryWithCRS {
    private final Geometry geometry;
    private static final Supplier<OperatorSimpleRelation>[] PREDICATES = new Supplier[SpatialOperatorName.OVERLAPS.ordinal() + 1];

    Wrapper(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometries<Geometry> factory() {
        return Factory.INSTANCE;
    }

    @Override
    protected Object implementation() {
        return this.geometry;
    }

    @Override
    public GeneralEnvelope getEnvelope() {
        Envelope2D bounds = new Envelope2D();
        this.geometry.queryEnvelope2D(bounds);
        GeneralEnvelope env = this.createEnvelope();
        env.setRange(0, bounds.xmin, bounds.xmax);
        env.setRange(1, bounds.ymin, bounds.ymax);
        return env;
    }

    @Override
    public DirectPosition getCentroid() {
        Point2D c = OperatorCentroid2D.local().execute(this.geometry, null);
        return new DirectPosition2D(this.getCoordinateReferenceSystem(), c.x, c.y);
    }

    @Override
    public double[] getPointCoordinates() {
        double[] coord;
        if (!(this.geometry instanceof Point)) {
            return null;
        }
        Point pt = (Point)this.geometry;
        if (pt.hasZ()) {
            coord = new double[3];
            coord[2] = pt.getZ();
        } else {
            coord = new double[2];
        }
        coord[1] = pt.getY();
        coord[0] = pt.getX();
        return coord;
    }

    @Override
    public double[] getAllCoordinates() {
        if (this.geometry instanceof MultiVertexGeometry) {
            Point2D[] points = ((MultiVertexGeometry)this.geometry).getCoordinates2D();
            double[] coordinates = new double[points.length * 2];
            int i = 0;
            for (Point2D p : points) {
                coordinates[i++] = p.x;
                coordinates[i++] = p.y;
            }
            return coordinates;
        }
        return null;
    }

    public Geometry mergePolylines(Iterator<?> polylines) {
        Polyline path = new Polyline();
        boolean lineTo = false;
        Geometry next = this.geometry;
        block0: while (true) {
            if (next instanceof Point) {
                Point pt = (Point)next;
                if (pt.isEmpty()) {
                    lineTo = false;
                } else {
                    double x = ((Point)next).getX();
                    double y = ((Point)next).getY();
                    if (lineTo) {
                        path.lineTo(x, y);
                    } else {
                        path.startPath(x, y);
                        lineTo = true;
                    }
                }
            } else {
                path.add((MultiPath)next, false);
                lineTo = false;
            }
            while (polylines.hasNext()) {
                next = (Geometry)polylines.next();
                if (next == null) continue;
                continue block0;
            }
            break;
        }
        return path;
    }

    @Override
    protected boolean predicateSameCRS(SpatialOperatorName type, GeometryWrapper other) {
        Supplier<OperatorSimpleRelation> op;
        int ordinal = type.ordinal();
        if (ordinal >= 0 && ordinal < PREDICATES.length && (op = PREDICATES[ordinal]) != null) {
            return op.get().execute(this.geometry, ((Wrapper)other).geometry, Wrapper.srs(), null);
        }
        return super.predicateSameCRS(type, other);
    }

    @Override
    protected Object operationSameCRS(SQLMM operation, GeometryWrapper other, Object argument) {
        Geometry result;
        switch (operation) {
            case ST_Dimension: {
                return this.geometry.getDimension();
            }
            case ST_CoordDim: {
                return this.geometry.hasZ() ? 3 : 2;
            }
            case ST_GeometryType: {
                return this.geometry.getType().name();
            }
            case ST_IsEmpty: {
                return this.geometry.isEmpty();
            }
            case ST_Is3D: {
                return this.geometry.hasZ();
            }
            case ST_IsMeasured: {
                return this.geometry.hasM();
            }
            case ST_X: {
                return ((Point)this.geometry).getX();
            }
            case ST_Y: {
                return ((Point)this.geometry).getY();
            }
            case ST_Z: {
                return ((Point)this.geometry).getZ();
            }
            case ST_Envelope: {
                return this.getEnvelope();
            }
            case ST_Boundary: {
                result = this.geometry.getBoundary();
                break;
            }
            case ST_Simplify: {
                result = GeometryEngine.simplify((Geometry)this.geometry, (SpatialReference)Wrapper.srs());
                break;
            }
            case ST_ConvexHull: {
                result = GeometryEngine.convexHull((Geometry)this.geometry);
                break;
            }
            case ST_Buffer: {
                result = GeometryEngine.buffer((Geometry)this.geometry, (SpatialReference)Wrapper.srs(), (double)((Number)argument).doubleValue());
                break;
            }
            case ST_Intersection: {
                result = GeometryEngine.intersect((Geometry)this.geometry, (Geometry)((Wrapper)other).geometry, (SpatialReference)Wrapper.srs());
                break;
            }
            case ST_Union: {
                result = GeometryEngine.union((Geometry[])new Geometry[]{this.geometry, ((Wrapper)other).geometry}, (SpatialReference)Wrapper.srs());
                break;
            }
            case ST_Difference: {
                result = GeometryEngine.difference((Geometry)this.geometry, (Geometry)((Wrapper)other).geometry, (SpatialReference)Wrapper.srs());
                break;
            }
            case ST_SymDifference: {
                result = GeometryEngine.symmetricDifference((Geometry)this.geometry, (Geometry)((Wrapper)other).geometry, (SpatialReference)Wrapper.srs());
                break;
            }
            case ST_Distance: {
                return GeometryEngine.distance((Geometry)this.geometry, (Geometry)((Wrapper)other).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Equals: {
                return GeometryEngine.equals((Geometry)this.geometry, (Geometry)((Wrapper)other).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Disjoint: {
                return GeometryEngine.disjoint((Geometry)this.geometry, (Geometry)((Wrapper)other).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Touches: {
                return GeometryEngine.touches((Geometry)this.geometry, (Geometry)((Wrapper)other).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Crosses: {
                return GeometryEngine.crosses((Geometry)this.geometry, (Geometry)((Wrapper)other).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Within: {
                return GeometryEngine.within((Geometry)this.geometry, (Geometry)((Wrapper)other).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Contains: {
                return GeometryEngine.contains((Geometry)this.geometry, (Geometry)((Wrapper)other).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Overlaps: {
                return GeometryEngine.overlaps((Geometry)this.geometry, (Geometry)((Wrapper)other).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_AsText: {
                return GeometryEngine.geometryToWkt((Geometry)this.geometry, (int)0);
            }
            case ST_GeomFromText: {
                return GeometryEngine.geometryFromWkt((String)((String)argument), (int)0, (Geometry.Type)Geometry.Type.Unknown);
            }
            case ST_PointFromText: {
                return GeometryEngine.geometryFromWkt((String)((String)argument), (int)0, (Geometry.Type)Geometry.Type.Point);
            }
            case ST_MPointFromText: {
                return GeometryEngine.geometryFromWkt((String)((String)argument), (int)0, (Geometry.Type)Geometry.Type.MultiPoint);
            }
            case ST_LineFromText: {
                return GeometryEngine.geometryFromWkt((String)((String)argument), (int)0, (Geometry.Type)Geometry.Type.Line);
            }
            case ST_PolyFromText: {
                return GeometryEngine.geometryFromWkt((String)((String)argument), (int)0, (Geometry.Type)Geometry.Type.Polygon);
            }
            case ST_Intersects: {
                return OperatorIntersects.local().execute(this.geometry, ((Wrapper)other).geometry, Wrapper.srs(), null);
            }
            case ST_Centroid: {
                result = new Point(OperatorCentroid2D.local().execute(this.geometry, null));
                break;
            }
            default: {
                return super.operationSameCRS(operation, other, argument);
            }
        }
        return result;
    }

    private static SpatialReference srs() {
        return null;
    }

    @Override
    public String formatWKT(double flatness) {
        return OperatorExportToWkt.local().execute(0, this.geometry, null);
    }

    static {
        Wrapper.PREDICATES[SpatialOperatorName.EQUALS.ordinal()] = OperatorEquals::local;
        Wrapper.PREDICATES[SpatialOperatorName.DISJOINT.ordinal()] = OperatorDisjoint::local;
        Wrapper.PREDICATES[SpatialOperatorName.INTERSECTS.ordinal()] = OperatorIntersects::local;
        Wrapper.PREDICATES[SpatialOperatorName.TOUCHES.ordinal()] = OperatorTouches::local;
        Wrapper.PREDICATES[SpatialOperatorName.CROSSES.ordinal()] = OperatorCrosses::local;
        Wrapper.PREDICATES[SpatialOperatorName.WITHIN.ordinal()] = OperatorWithin::local;
        Wrapper.PREDICATES[SpatialOperatorName.CONTAINS.ordinal()] = OperatorContains::local;
        Wrapper.PREDICATES[SpatialOperatorName.OVERLAPS.ordinal()] = OperatorOverlaps::local;
        Wrapper.PREDICATES[SpatialOperatorName.BBOX.ordinal()] = new BBOX();
    }

    private static final class BBOX
    extends OperatorSimpleRelation
    implements Supplier<OperatorSimpleRelation> {
        private BBOX() {
        }

        @Override
        public OperatorSimpleRelation get() {
            return this;
        }

        public Operator.Type getType() {
            return Operator.Type.Intersects;
        }

        public boolean execute(Geometry g1, Geometry g2, SpatialReference srs, ProgressTracker pt) {
            return !OperatorDisjoint.local().execute(g1, g2, srs, pt);
        }
    }
}

