/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.lang.reflect.InaccessibleObjectException;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.measure.Unit;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.FormatField;
import org.apache.sis.measure.FormattedCharacterIterator;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.internal.LocalizedParseException;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.internal.StandardDateFormat;
import org.apache.sis.util.resources.Errors;

public class RangeFormat
extends Format
implements Localized {
    private static final long serialVersionUID = 2459948572315667868L;
    private static final int MIN_VALUE_FIELD = 0;
    private static final int MAX_VALUE_FIELD = 1;
    private static final int UNIT_FIELD = 2;
    private final int openSet;
    private final int openInclusive;
    private final int openExclusive;
    private final int openExclusiveAlt;
    private final int closeSet;
    private final int closeInclusive;
    private final int closeExclusive;
    private final int closeExclusiveAlt;
    private final String separator;
    private final char minusSign;
    private final String infinity;
    private boolean alternateForm;
    protected final Class<?> elementType;
    protected final Format elementFormat;
    protected final UnitFormat unitFormat;
    private transient Map<Unit<?>, Boolean> insertSpaceBeforeUnit;
    private Locale locale;

    public RangeFormat() {
        this(Locale.getDefault(Locale.Category.FORMAT));
        this.locale = Locale.getDefault(Locale.Category.DISPLAY);
    }

    public RangeFormat(Locale locale) {
        this(locale, Number.class);
    }

    public RangeFormat(Locale locale, TimeZone timezone) {
        this(locale, Date.class);
        ((DateFormat)this.elementFormat).setTimeZone(timezone);
    }

    public RangeFormat(Locale locale, Class<?> elementType) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("locale", locale);
        ArgumentChecks.ensureNonNull("elementType", elementType);
        this.locale = locale;
        this.elementType = elementType;
        if (Angle.class.isAssignableFrom(elementType)) {
            this.elementFormat = AngleFormat.getInstance(locale);
            this.unitFormat = null;
        } else if (Number.class.isAssignableFrom(elementType)) {
            this.elementFormat = NumberFormat.getNumberInstance(locale);
            this.unitFormat = new UnitFormat(locale);
        } else if (Date.class.isAssignableFrom(elementType) || elementType == Instant.class) {
            this.elementFormat = DateFormat.getDateTimeInstance(3, 3, locale);
            this.unitFormat = null;
        } else if (Temporal.class.isAssignableFrom(elementType)) {
            FormatStyle dateStyle = StandardDateFormat.hasDateFields(elementType) ? FormatStyle.SHORT : null;
            FormatStyle timeStyle = StandardDateFormat.hasTimeFields(elementType) ? FormatStyle.SHORT : null;
            this.elementFormat = new DateTimeFormatterBuilder().appendLocalized(dateStyle, timeStyle).toFormatter(locale).toFormat();
            this.unitFormat = null;
        } else {
            throw new IllegalArgumentException(Errors.format((short)163, elementType));
        }
        DecimalFormatSymbols ds = this.elementFormat instanceof DecimalFormat ? ((DecimalFormat)this.elementFormat).getDecimalFormatSymbols() : DecimalFormatSymbols.getInstance(locale);
        this.minusSign = ds.getMinusSign();
        this.infinity = ds.getInfinity();
        this.openSet = 123;
        this.openInclusive = 91;
        this.openExclusive = 40;
        this.openExclusiveAlt = 93;
        this.closeSet = 125;
        this.closeInclusive = 93;
        this.closeExclusive = 41;
        this.closeExclusiveAlt = 91;
        this.separator = "\u2026";
    }

    private boolean isOpen(int c) {
        return c == this.openInclusive || c == this.openExclusive || c == this.openExclusiveAlt;
    }

    private boolean isClose(int c) {
        return c == this.closeInclusive || c == this.closeExclusive || c == this.closeExclusiveAlt;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public String getElementPattern(boolean localized) {
        Format format = this.elementFormat;
        if (format instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)format;
            return localized ? df.toLocalizedPattern() : df.toPattern();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat df = (SimpleDateFormat)format;
            return localized ? df.toLocalizedPattern() : df.toPattern();
        }
        if (format instanceof AngleFormat) {
            return ((AngleFormat)format).toPattern();
        }
        return null;
    }

    public void setElementPattern(String pattern, boolean localized) {
        Format format = this.elementFormat;
        if (format instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)format;
            if (localized) {
                df.applyLocalizedPattern(pattern);
            } else {
                df.applyPattern(pattern);
            }
        } else if (format instanceof SimpleDateFormat) {
            SimpleDateFormat df = (SimpleDateFormat)format;
            if (localized) {
                df.applyLocalizedPattern(pattern);
            } else {
                df.applyPattern(pattern);
            }
        } else if (format instanceof AngleFormat) {
            ((AngleFormat)format).applyPattern(pattern);
        } else {
            throw new IllegalStateException();
        }
    }

    public boolean isAlternateForm() {
        return this.alternateForm;
    }

    public void setAlternateForm(boolean alternateForm) {
        this.alternateForm = alternateForm;
    }

    private boolean insertSpaceBeforeUnit(Unit<?> unit) {
        Boolean value;
        if (this.insertSpaceBeforeUnit == null) {
            this.insertSpaceBeforeUnit = new HashMap();
        }
        if ((value = this.insertSpaceBeforeUnit.get(unit)) == null) {
            String symbol = this.unitFormat.format(unit);
            value = !symbol.isEmpty() && Character.isLetterOrDigit(symbol.codePointAt(0));
            this.insertSpaceBeforeUnit.put(unit, value);
        }
        return value;
    }

    private static int getField(FieldPosition position) {
        if (position != null) {
            Format.Field field = position.getFieldAttribute();
            if (field instanceof Field) {
                return ((Field)field).field;
            }
            return position.getField();
        }
        return -1;
    }

    private static Range<?> cast(Object range) throws IllegalArgumentException {
        if (range instanceof Range) {
            return (Range)range;
        }
        String message = range == null ? Errors.format((short)113, "range") : Errors.format((short)43, "range", Range.class, range.getClass());
        throw new IllegalArgumentException(message);
    }

    @Override
    public StringBuffer format(Object range, StringBuffer toAppendTo, FieldPosition pos) {
        this.format(RangeFormat.cast(range), toAppendTo, pos, null);
        return toAppendTo;
    }

    private void format(Range<?> range, StringBuffer toAppendTo, FieldPosition pos, FormattedCharacterIterator characterIterator) {
        int fieldPos = RangeFormat.getField(pos);
        if (range.isEmpty()) {
            toAppendTo.appendCodePoint(this.openSet);
            if (fieldPos >= 0 && fieldPos <= 2) {
                int p = toAppendTo.length();
                pos.setBeginIndex(p);
                pos.setEndIndex(p);
            }
            toAppendTo.appendCodePoint(this.closeSet);
            return;
        }
        Object minValue = range.getMinValue();
        Object maxValue = range.getMaxValue();
        boolean isSingleton = minValue != null && minValue.equals(maxValue);
        int field = 0;
        if (isSingleton) {
            if (fieldPos == 0) {
                fieldPos = 1;
            }
            field = 1;
        }
        toAppendTo.appendCodePoint(isSingleton ? this.openSet : (range.isMinIncluded() ? this.openInclusive : (this.alternateForm ? this.openExclusiveAlt : this.openExclusive)));
        while (field <= 2) {
            Object value;
            switch (field) {
                case 0: {
                    value = this.toFormattable(minValue);
                    break;
                }
                case 1: {
                    value = this.toFormattable(maxValue);
                    break;
                }
                case 2: {
                    value = range.unit();
                    break;
                }
                default: {
                    throw new AssertionError(field);
                }
            }
            int startPosition = toAppendTo.length();
            if (value == null) {
                switch (field) {
                    case 0: {
                        toAppendTo.append(this.minusSign != '-' ? (char)this.minusSign : (char)'\u2212');
                    }
                    case 1: {
                        toAppendTo.append(this.infinity);
                    }
                }
            } else {
                Format format;
                if (field == 2) {
                    if (this.insertSpaceBeforeUnit((Unit)value)) {
                        startPosition = toAppendTo.append(' ').length();
                    }
                    format = this.unitFormat;
                } else {
                    format = this.elementFormat;
                }
                Numerics.useScientificNotationIfNeeded(format, value, (f, v) -> {
                    if (characterIterator != null) {
                        characterIterator.append(f.formatToCharacterIterator(v), toAppendTo);
                    } else {
                        f.format(v, toAppendTo, new FieldPosition(-1));
                    }
                    return null;
                });
            }
            if (characterIterator != null) {
                characterIterator.addFieldLimit(Field.forCode(field), value, startPosition);
            }
            if (field == fieldPos) {
                pos.setBeginIndex(startPosition);
                pos.setEndIndex(toAppendTo.length());
            }
            switch (field) {
                case 0: {
                    toAppendTo.append(' ').append(this.separator).append(' ');
                    break;
                }
                case 1: {
                    toAppendTo.appendCodePoint(isSingleton ? this.closeSet : (range.isMaxIncluded() ? this.closeInclusive : (this.alternateForm ? this.closeExclusiveAlt : this.closeExclusive)));
                }
            }
            ++field;
        }
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object range) {
        StringBuffer buffer = new StringBuffer();
        FormattedCharacterIterator it = new FormattedCharacterIterator(buffer);
        this.format(RangeFormat.cast(range), buffer, null, it);
        return it;
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        return this.parse(source);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public Range<?> parse(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        UnconvertibleObjectException failure = null;
        try {
            Range<?> range = this.tryParse(source, pos);
            if (range != null) {
                return range;
            }
        }
        catch (UnconvertibleObjectException e) {
            failure = e;
        }
        throw new LocalizedParseException(this.locale, this.elementType, source, pos).initCause(failure);
    }

    public Range<?> parse(String source, ParsePosition pos) {
        Range<?> range;
        int origin = pos.getIndex();
        try {
            range = this.tryParse(source, pos);
        }
        catch (UnconvertibleObjectException e) {
            range = null;
        }
        if (range != null) {
            pos.setErrorIndex(-1);
        } else {
            pos.setIndex(origin);
        }
        return range;
    }

    private Range<?> tryParse(String source, ParsePosition pos) throws UnconvertibleObjectException {
        Object value;
        boolean isMinIncluded;
        boolean isMaxIncluded;
        Object minValue;
        Object maxValue;
        int c;
        int length = source.length();
        int index = pos.getIndex();
        while (true) {
            if (index >= length) {
                pos.setErrorIndex(length);
                return null;
            }
            c = source.codePointAt(index);
            if (!Character.isWhitespace(c)) break;
            index += Character.charCount(c);
        }
        if (!this.isOpen(c)) {
            boolean hasBraces;
            boolean bl = hasBraces = c == this.openSet;
            if (hasBraces) {
                while ((index += Character.charCount(c)) < length && Character.isWhitespace(c = source.codePointAt(index))) {
                }
            }
            if (hasBraces && c == this.closeSet) {
                minValue = maxValue = this.valueOfNil();
                isMaxIncluded = false;
                isMinIncluded = false;
            } else {
                pos.setIndex(index);
                value = this.elementFormat.parseObject(source, pos);
                if (value == null) {
                    return null;
                }
                pos.setErrorIndex(index);
                minValue = maxValue = this.convert(value);
                index = pos.getIndex();
                isMaxIncluded = true;
                isMinIncluded = true;
            }
            if (hasBraces) {
                do {
                    if (index >= length) {
                        pos.setErrorIndex(length);
                        return null;
                    }
                    c = source.codePointAt(index);
                    index += Character.charCount(c);
                } while (Character.isWhitespace(c));
                if (c != this.closeSet) {
                    pos.setErrorIndex(index - Character.charCount(c));
                    return null;
                }
                pos.setIndex(index);
            }
        } else {
            boolean bl = isMinIncluded = c == this.openInclusive;
            do {
                if ((index += Character.charCount(c)) < length) continue;
                pos.setErrorIndex(length);
                return null;
            } while (Character.isWhitespace(c = source.codePointAt(index)));
            if (this.isClose(c)) {
                pos.setErrorIndex(index);
                minValue = maxValue = this.valueOfNil();
                isMaxIncluded = false;
                index += Character.charCount(c);
            } else {
                pos.setIndex(index);
                int savedIndex = index;
                value = this.elementFormat.parseObject(source, pos);
                if (value == null) {
                    if (c == this.minusSign || c == 8722) {
                        index += Character.charCount(c);
                    }
                    if (!source.startsWith(this.infinity, index)) {
                        return null;
                    }
                    pos.setIndex(index += this.infinity.length());
                }
                pos.setErrorIndex(savedIndex);
                minValue = this.convert(value);
                index = pos.getIndex();
                while (true) {
                    if (index >= length) {
                        pos.setErrorIndex(length);
                        return null;
                    }
                    c = source.codePointAt(index);
                    if (!Character.isWhitespace(c)) break;
                    index += Character.charCount(c);
                }
                String separator = this.separator;
                if (source.startsWith(separator, index)) {
                    index += separator.length();
                    while (true) {
                        if (index >= length) {
                            pos.setErrorIndex(length);
                            return null;
                        }
                        c = source.codePointAt(index);
                        if (!Character.isWhitespace(c)) break;
                        index += Character.charCount(c);
                    }
                    pos.setIndex(index);
                    value = this.elementFormat.parseObject(source, pos);
                    if (value == null) {
                        if (!source.startsWith(this.infinity, index)) {
                            return null;
                        }
                        pos.setIndex(index += this.infinity.length());
                    }
                    pos.setErrorIndex(index);
                    maxValue = this.convert(value);
                    index = pos.getIndex();
                    while (true) {
                        if (index >= length) {
                            pos.setErrorIndex(length);
                            return null;
                        }
                        c = source.charAt(index);
                        if (Character.isWhitespace(c)) {
                            index += Character.charCount(c);
                            continue;
                        }
                        break;
                    }
                } else {
                    maxValue = minValue;
                }
                if (!this.isClose(c)) {
                    pos.setErrorIndex(index);
                    return null;
                }
                index += Character.charCount(c);
                isMaxIncluded = c == this.closeInclusive;
            }
            pos.setIndex(index);
        }
        Unit<?> unit = null;
        if (this.unitFormat != null) {
            while (index < length) {
                c = source.codePointAt(index);
                if (Character.isWhitespace(c)) {
                    index += Character.charCount(c);
                    continue;
                }
                pos.setIndex(index);
                unit = this.unitFormat.parse(source, pos);
                break;
            }
        }
        if (Number.class.isAssignableFrom(this.elementType)) {
            Class<Object> type = this.elementType;
            Number min = (Number)minValue;
            Number max = (Number)maxValue;
            if (type == Number.class) {
                type = Numbers.widestClass(Numbers.narrowestClass(min), Numbers.narrowestClass(max));
                min = Numbers.cast(min, type);
                max = Numbers.cast(max, type);
            }
            if (min != null && min.doubleValue() == Double.NEGATIVE_INFINITY) {
                min = null;
            }
            if (max != null && max.doubleValue() == Double.POSITIVE_INFINITY) {
                max = null;
            }
            if (unit != null) {
                MeasurementRange<Number> range = new MeasurementRange<Number>(type, min, isMinIncluded, max, isMaxIncluded, unit);
                return range;
            }
            return new NumberRange<Number>(type, min, isMinIncluded, max, isMaxIncluded);
        }
        if (Date.class.isAssignableFrom(this.elementType)) {
            return new Range<Date>(Date.class, (Date)minValue, isMinIncluded, (Date)maxValue, isMaxIncluded);
        }
        return new Range<Comparable>(this.elementType, (Comparable)minValue, isMinIncluded, (Comparable)maxValue, isMaxIncluded);
    }

    private Object convert(Object value) throws UnconvertibleObjectException {
        if (value == null || this.elementType.isInstance(value)) {
            return value;
        }
        if (value instanceof Number && Number.class.isAssignableFrom(this.elementType)) {
            return Numbers.cast((Number)value, this.elementType);
        }
        if (value instanceof Date && this.elementType == Instant.class) {
            return ((Date)value).toInstant();
        }
        throw new UnconvertibleObjectException(Errors.format((short)50, this.elementType, value.getClass()));
    }

    private Object toFormattable(Object value) {
        if (value instanceof Instant && this.elementType == Instant.class) {
            return Date.from((Instant)value);
        }
        return value;
    }

    private Object valueOfNil() {
        Object value = Numbers.valueOfNil(this.elementType);
        if (value == null) {
            value = Date.class.isAssignableFrom(this.elementType) ? new Date() : Integer.valueOf(0);
        }
        return this.convert(value);
    }

    @Override
    public RangeFormat clone() {
        RangeFormat f = (RangeFormat)super.clone();
        try {
            f.clone("elementFormat");
            f.clone("unitFormat");
        }
        catch (ReflectiveOperationException e) {
            throw (InaccessibleObjectException)new InaccessibleObjectException().initCause(e);
        }
        return f;
    }

    private void clone(String field) throws ReflectiveOperationException {
        java.lang.reflect.Field f = RangeFormat.class.getDeclaredField(field);
        f.setAccessible(true);
        f.set(this, ((Format)f.get(this)).clone());
    }

    public static final class Field
    extends FormatField {
        private static final long serialVersionUID = 2000378602311146796L;
        public static final Field MIN_VALUE = new Field("MIN_VALUE", 0);
        public static final Field MAX_VALUE = new Field("MAX_VALUE", 1);
        public static final Field UNIT = new Field("UNIT", 2);

        private Field(String name, int fieldID) {
            super(name, fieldID);
        }

        static Field forCode(int field) {
            switch (field) {
                case 0: {
                    return MIN_VALUE;
                }
                case 1: {
                    return MAX_VALUE;
                }
                case 2: {
                    return UNIT;
                }
            }
            throw new AssertionError(field);
        }
    }
}

