/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.metadata.internal.Identifiers;
import org.apache.sis.metadata.internal.NameMeaning;
import org.apache.sis.metadata.internal.NameToIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.Properties;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;

public final class IdentifiedObjects
extends Static {
    private IdentifiedObjects() {
    }

    public static Map<String, ?> getProperties(IdentifiedObject object, String ... excludes) {
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("excludes", excludes);
        return new Properties(object, excludes);
    }

    public static Set<String> getNames(IdentifiedObject object, Citation authority) {
        LinkedHashSet<String> names = new LinkedHashSet<String>(8);
        IdentifiedObjects.getName(object, authority, names);
        return names;
    }

    public static String getName(IdentifiedObject object, Citation authority) {
        return IdentifiedObjects.getName(object, authority, null);
    }

    private static String getName(IdentifiedObject object, Citation authority, Collection<String> addTo) {
        if (object != null) {
            String name;
            Identifier identifier = object.getName();
            if (identifier != null && (authority == null || Citations.identifierMatches(authority, identifier.getAuthority())) && (name = identifier.getCode()) != null) {
                if (addTo == null) {
                    return name;
                }
                addTo.add(name);
            }
            for (GenericName alias : CollectionsExt.nonNull(object.getAlias())) {
                String name2;
                if (alias == null) continue;
                if (alias instanceof Identifier) {
                    identifier = (Identifier)((Object)alias);
                    if (authority != null && !Citations.identifierMatches(authority, identifier.getAuthority())) continue;
                    name2 = identifier.getCode();
                } else {
                    GenericName scope;
                    NameSpace ns;
                    if (authority != null && ((ns = alias.scope()) == null || (scope = ns.name()) == null || !Citations.identifierMatches(authority, scope.toString()))) continue;
                    name2 = alias.toString();
                }
                if (name2 == null) continue;
                if (addTo == null) {
                    return name2;
                }
                addTo.add(name2);
            }
        }
        return null;
    }

    public static Identifier getIdentifier(IdentifiedObject object, Citation authority) {
        if (object != null) {
            String cs = null;
            if (authority instanceof IdentifierSpace) {
                cs = ((IdentifierSpace)authority).getName();
            }
            for (ReferenceIdentifier identifier : CollectionsExt.nonNull(object.getIdentifiers())) {
                if (identifier == null) continue;
                if (cs != null && cs.equalsIgnoreCase(identifier.getCodeSpace())) {
                    return identifier;
                }
                if (authority != null && !Citations.identifierMatches(authority, identifier.getAuthority())) continue;
                return identifier;
            }
        }
        return null;
    }

    public static String getIdentifierOrName(IdentifiedObject object) {
        if (object != null) {
            for (Identifier identifier : CollectionsExt.nonNull(object.getIdentifiers())) {
                String code = IdentifiedObjects.toString(identifier);
                if (code == null) continue;
                return code;
            }
            String name = IdentifiedObjects.toString(object.getName());
            if (name != null) {
                return name;
            }
        }
        return null;
    }

    public static String getSimpleNameOrIdentifier(IdentifiedObject object) {
        if (object != null) {
            String code;
            String code2;
            ReferenceIdentifier identifier = object.getName();
            if (identifier != null && CharSequences.isUnicodeIdentifier(code2 = identifier.getCode())) {
                return code2;
            }
            for (GenericName genericName : CollectionsExt.nonNull(object.getAlias())) {
                LocalName localName;
                if (genericName == null || (localName = genericName.tip()) == null || !CharSequences.isUnicodeIdentifier(code = localName.toString())) continue;
                return code;
            }
            for (Identifier identifier2 : CollectionsExt.nonNull(object.getIdentifiers())) {
                if (identifier2 == null || !CharSequences.isUnicodeIdentifier(code = identifier2.getCode())) continue;
                return code;
            }
        }
        return null;
    }

    public static String getDisplayName(IdentifiedObject object, Locale locale) {
        String name;
        block4: {
            Identifier id;
            if (object == null) {
                return null;
            }
            name = IdentifiedObjects.toString(object.getName(), locale);
            for (GenericName c : CollectionsExt.nonNull(object.getAlias())) {
                String alias = IdentifiedObjects.toString(c, locale);
                if (alias == null) continue;
                if (name == null || CharSequences.isAcronymForWords(name, alias)) {
                    return alias;
                }
                String unlocalized = c.toString();
                if (alias.equals(unlocalized) || !CharSequences.isAcronymForWords(name, unlocalized)) continue;
                return alias;
            }
            if (name != null) break block4;
            Iterator<Object> iterator = CollectionsExt.nonNull(object.getIdentifiers()).iterator();
            while (iterator.hasNext() && (name = IdentifiedObjects.toString(id = (Identifier)iterator.next(), locale)) == null) {
            }
        }
        return name;
    }

    public static String lookupURN(IdentifiedObject object, Citation authority) throws FactoryException {
        List<IdentifiedObject> components;
        IdentifiedObjectFinder finder;
        if (object == null) {
            return null;
        }
        try {
            finder = IdentifiedObjects.newFinder(Citations.toCodeSpace(authority));
        }
        catch (NoSuchAuthorityFactoryException e) {
            IdentifiedObjects.warning("lookupURN", e);
            finder = IdentifiedObjects.newFinder(null);
        }
        String urn = IdentifiedObjects.lookupURN(object, authority, finder);
        if (urn != null) {
            return urn;
        }
        if (object instanceof CompoundCRS) {
            components = CRS.getSingleComponents((CompoundCRS)object);
        } else if (object instanceof ConcatenatedOperation) {
            components = ((ConcatenatedOperation)object).getOperations();
        } else {
            return null;
        }
        StringBuilder buffer = null;
        for (IdentifiedObject component : components) {
            urn = IdentifiedObjects.lookupURN(component, authority, finder);
            if (urn == null) {
                return null;
            }
            assert (urn.startsWith("urn:ogc:def")) : urn;
            if (buffer == null) {
                buffer = new StringBuilder(40).append("urn:ogc:def").append(':').append(NameMeaning.toObjectType(object.getClass()));
            }
            buffer.append(',').append(urn, "urn:ogc:def".length() + 1, urn.length());
        }
        return buffer != null ? buffer.toString() : null;
    }

    private static String lookupURN(IdentifiedObject object, Citation authority, IdentifiedObjectFinder finder) throws FactoryException {
        String urn = null;
        if (object != null) {
            for (IdentifiedObject candidate : finder.find(object)) {
                String c = IdentifiedObjects.toURN(candidate.getClass(), IdentifiedObjects.getIdentifier(candidate, authority));
                if (c == null && authority == null) {
                    for (Identifier identifier : candidate.getIdentifiers()) {
                        c = IdentifiedObjects.toURN(candidate.getClass(), identifier);
                        if (c == null) continue;
                        break;
                    }
                }
                if (c == null) continue;
                if (urn != null && !urn.equals(c)) {
                    return null;
                }
                urn = c;
            }
        }
        return urn;
    }

    public static Integer lookupEPSG(IdentifiedObject object) throws FactoryException {
        Integer code = null;
        if (object != null) {
            for (IdentifiedObject candidate : IdentifiedObjects.newFinder("EPSG").find(object)) {
                Identifier id = IdentifiedObjects.getIdentifier(candidate, Citations.EPSG);
                if (id == null) continue;
                try {
                    Integer previous = code;
                    code = Integer.valueOf(id.getCode());
                    if (previous == null || previous.equals(code)) continue;
                    return null;
                }
                catch (NumberFormatException e) {
                    IdentifiedObjects.warning("lookupEPSG", e);
                }
            }
        }
        return code;
    }

    private static void warning(String method, Exception e) {
        Logging.recoverableException(CRS.LOGGER, IdentifiedObjects.class, method, e);
    }

    public static IdentifiedObjectFinder newFinder(String authority) throws NoSuchAuthorityFactoryException, FactoryException {
        GeodeticAuthorityFactory factory = authority == null ? AuthorityFactories.ALL : AuthorityFactories.ALL.getAuthorityFactory(GeodeticAuthorityFactory.class, authority, null);
        return ((GeodeticAuthorityFactory)factory).newIdentifiedObjectFinder();
    }

    public static boolean isHeuristicMatchForName(IdentifiedObject object, String name) {
        ArgumentChecks.ensureNonNull("name", name);
        if (object == null) {
            return false;
        }
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).isHeuristicMatchForName(name);
        }
        return NameToIdentifier.isHeuristicMatchForName(object.getName(), object.getAlias(), name, NameToIdentifier.Simplifier.DEFAULT);
    }

    public static String toURN(Class<?> type, Identifier identifier) {
        ArgumentChecks.ensureNonNull("type", type);
        if (identifier == null) {
            return null;
        }
        String cs = null;
        if (identifier instanceof ReferenceIdentifier) {
            cs = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (cs == null || cs.isEmpty()) {
            cs = Identifiers.getIdentifier(identifier.getAuthority(), true);
        }
        return NameMeaning.toURN(type, cs, identifier instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier).getVersion() : null, identifier.getCode());
    }

    public static String toString(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof GenericName) {
            return identifier.toString();
        }
        String code = identifier.getCode();
        String cs = null;
        if (identifier instanceof ReferenceIdentifier) {
            cs = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (cs == null || cs.isEmpty()) {
            cs = Citations.toCodeSpace(identifier.getAuthority());
        }
        if (cs != null) {
            return cs + ":" + code;
        }
        return code;
    }

    private static String toString(Identifier identifier, Locale locale) {
        String name;
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof GenericName && (name = IdentifiedObjects.toString(((GenericName)((Object)identifier)).tip(), locale)) != null) {
            return name;
        }
        return Strings.trimOrNull(identifier.getCode());
    }

    private static String toString(GenericName name, Locale locale) {
        String s;
        InternationalString i18n;
        if (name == null) {
            return null;
        }
        if (locale != null && (i18n = name.toInternationalString()) != null && (s = Strings.trimOrNull(i18n.toString(locale))) != null) {
            return s;
        }
        return Strings.trimOrNull(name.toString());
    }
}

