/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.util;

import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.util.Static;
import org.opengis.referencing.datum.Ellipsoid;

public final class Formulas
extends Static {
    public static final double LINEAR_TOLERANCE = 0.01;
    public static final double ANGULAR_TOLERANCE = 8.999280057595393E-8;
    public static final double TEMPORAL_TOLERANCE = 60.0;
    public static final double LONGITUDE_MAX = 4.052915431398935E8;
    public static final long JULIAN_YEAR_LENGTH = 31557600000L;
    public static final int MAXIMUM_ITERATIONS = 18;
    public static final boolean USE_FMA = false;

    private Formulas() {
    }

    public static boolean isPoleToPole(double ymin, double ymax) {
        return Math.abs(ymin - -90.0) <= 8.999280057595393E-8 && Math.abs(ymax - 90.0) <= 8.999280057595393E-8;
    }

    public static double scaleComparedToEarth(Ellipsoid planet) {
        return Formulas.getAuthalicRadius(planet) / 6371007.180918474;
    }

    public static double getAuthalicRadius(Ellipsoid ellipsoid) {
        if (ellipsoid == null) {
            return Double.NaN;
        }
        if (ellipsoid instanceof DefaultEllipsoid) {
            return ((DefaultEllipsoid)ellipsoid).getAuthalicRadius();
        }
        return Formulas.getAuthalicRadius(ellipsoid.getSemiMajorAxis(), ellipsoid.getSemiMinorAxis());
    }

    public static double getAuthalicRadius(double a, double b) {
        if (a != b) {
            double f = 1.0 - b / a;
            double e = Math.sqrt(2.0 * f - f * f);
            return Math.sqrt(0.5 * (a * a + b * b * MathFunctions.atanh(e) / e));
        }
        return a;
    }

    public static double radiusOfConformalSphere(Ellipsoid ellipsoid, double \u03c6) {
        double sin\u03c6 = Math.sin(\u03c6);
        double a = ellipsoid.getSemiMajorAxis();
        double r = ellipsoid.getSemiMinorAxis() / a;
        return a * (r / (1.0 - (1.0 - r * r) * (sin\u03c6 * sin\u03c6)));
    }

    public static double geocentricRadius(Ellipsoid ellipsoid, double \u03c6) {
        double a = ellipsoid.getSemiMajorAxis();
        double b = ellipsoid.getSemiMinorAxis();
        double at = a * Math.cos(\u03c6);
        at *= at;
        double bt = b * Math.sin(\u03c6);
        bt *= bt;
        return Math.sqrt((a * a * at + b * b * bt) / (at + bt));
    }

    public static double getSemiMinor(double semiMajorAxis, double inverseFlattening) {
        return semiMajorAxis * (1.0 - 1.0 / inverseFlattening);
    }

    public static double getInverseFlattening(double semiMajorAxis, double semiMinorAxis) {
        return semiMajorAxis / (semiMajorAxis - semiMinorAxis);
    }

    public static double fastHypot(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }
}

