/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.classic;

import java.io.IOException;
import java.nio.charset.Charset;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.HyperRectangleReader;
import org.apache.sis.io.stream.Region;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.netcdf.base.DataType;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.base.GridAdjustment;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.storage.netcdf.classic.ChannelDecoder;
import org.apache.sis.storage.netcdf.classic.DimensionInfo;
import org.apache.sis.storage.netcdf.classic.GridInfo;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.StandardDateFormat;
import org.apache.sis.util.internal.UnmodifiableArrayList;

final class VariableInfo
extends Variable
implements Comparable<VariableInfo> {
    private static final String[] DESCRIPTION_ATTRIBUTES = new String[]{"long_name", "description", "title", "standard_name"};
    private final HyperRectangleReader reader;
    private final String name;
    final DimensionInfo[] dimensions;
    private long offsetToNextRecord;
    private final Map<String, Object> attributes;
    private final Set<String> attributeNames;
    private final DataType dataType;
    GridInfo grid;
    boolean isCoordinateSystemAxis;

    VariableInfo(Decoder decoder, ChannelDataInput input, String name, DimensionInfo[] dimensions, Map<String, Object> attributes, Set<String> attributeNames, DataType dataType, int size, long offset) throws DataStoreContentException {
        super(decoder);
        this.name = name;
        this.dimensions = dimensions;
        this.attributes = attributes;
        this.attributeNames = attributeNames;
        Object isUnsigned = this.getAttributeValue("_Unsigned", "_unsigned");
        if (isUnsigned instanceof String) {
            dataType = dataType.unsigned(Boolean.parseBoolean((String)isUnsigned));
        }
        this.dataType = dataType;
        if (dataType != null && (this.offsetToNextRecord = (long)dataType.size()) != 0L) {
            for (int i = 0; i < dimensions.length; ++i) {
                DimensionInfo dim = dimensions[i];
                if (!dim.isUnlimited) {
                    this.offsetToNextRecord = Math.multiplyExact(this.offsetToNextRecord, dim.length());
                    continue;
                }
                if (i == 0) continue;
                throw new DataStoreContentException(this.getLocale(), "netCDF", input.filename, null);
            }
            this.reader = new HyperRectangleReader(dataType.number, input);
            this.reader.setOrigin(offset);
        } else {
            this.reader = null;
        }
        if (size != -1) {
            long expected = this.paddedSize();
            long actual = Integer.toUnsignedLong(size);
            if (actual != expected) {
                if (expected != 0L) {
                    this.warning(ChannelDecoder.class, "readVariables", (short)8, this.getFilename(), name, actual - expected);
                }
                if (actual > this.offsetToNextRecord) {
                    this.offsetToNextRecord = actual;
                }
            }
        }
        boolean bl = this.isCoordinateSystemAxis = (dimensions.length == 1 || dimensions.length == 2) && this.getAxisType() != null;
        if (!this.isCoordinateSystemAxis && dimensions.length == 1) {
            Object value = this.getAttributeValue("_CoordinateAliasForDimension", "_coordinatealiasfordimension");
            if (value == null && (value = this.getAttributeValue("_CoordinateVariableAlias", "_coordinatevariablealias")) == null) {
                value = name;
            }
            this.isCoordinateSystemAxis = dimensions[0].name.equals(value);
        }
        this.split("flag_names");
        this.split("flag_meanings");
        this.setEnumeration(null);
    }

    private void split(String attributeName) {
        Object previous;
        CharSequence[] values = this.getAttributeAsStrings(attributeName, ' ');
        if (values != null && (previous = this.attributes.put(attributeName, values)) instanceof Vector) {
            this.attributes.put(attributeName, previous);
        }
    }

    private long paddedSize() {
        return Math.addExact(this.offsetToNextRecord, 3L) & 0xFFFFFFFFFFFFFFFCL;
    }

    static void complete(VariableInfo[] variables) {
        HashSet referencedAsAxis = new HashSet();
        VariableInfo[] unlimited = new VariableInfo[variables.length];
        int count = 0;
        long recordStride = 0L;
        boolean isUnknown = false;
        for (VariableInfo variable : variables) {
            Collections.addAll(referencedAsAxis, variable.getCoordinateVariables());
            if (!variable.isUnlimited()) continue;
            long paddedSize = variable.paddedSize();
            unlimited[count++] = variable;
            isUnknown |= paddedSize == 0L;
            recordStride = Math.addExact(recordStride, paddedSize);
        }
        if (isUnknown) {
            for (int i = 0; i < count; ++i) {
                unlimited[i].offsetToNextRecord = -1L;
            }
        } else if (count == 1) {
            unlimited[0].offsetToNextRecord = 0L;
        } else {
            for (int i = 0; i < count; ++i) {
                unlimited[i].offsetToNextRecord = Math.subtractExact(recordStride, unlimited[i].offsetToNextRecord);
            }
        }
        if (!referencedAsAxis.isEmpty()) {
            for (VariableInfo variable : variables) {
                if (!referencedAsAxis.remove(variable.name)) continue;
                variable.isCoordinateSystemAxis = true;
                if (referencedAsAxis.isEmpty()) break;
            }
        }
    }

    @Override
    public String getFilename() {
        String filename;
        if (this.reader != null && (filename = this.reader.filename()) != null) {
            return filename;
        }
        return super.getFilename();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        for (String attributeName : DESCRIPTION_ATTRIBUTES) {
            String value = this.getAttributeAsString(attributeName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    protected String getUnitsString() {
        return this.getAttributeAsString("units");
    }

    @Override
    protected Unit<?> parseUnit(String symbols) {
        Unit<?> unit;
        Matcher parts = TIME_UNIT_PATTERN.matcher(symbols);
        DateTimeParseException dateError = null;
        if (parts.matches()) {
            try {
                this.epoch = StandardDateFormat.parseInstantUTC(parts.group(2));
            }
            catch (DateTimeParseException e) {
                dateError = e;
            }
            symbols = parts.group(1);
        }
        try {
            unit = Units.valueOf(symbols);
        }
        catch (MeasurementParseException e) {
            if (dateError != null) {
                e.addSuppressed(dateError);
            }
            throw e;
        }
        if (dateError != null) {
            this.error(Variable.class, "getUnit", dateError, (short)183, this.getName(), symbols);
        }
        return unit;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    protected boolean isUnlimited() {
        return this.dimensions.length != 0 && this.dimensions[0].isUnlimited;
    }

    @Override
    protected boolean isCoordinateSystemAxis() {
        return this.isCoordinateSystemAxis;
    }

    @Override
    protected String getAxisType() {
        Object value = this.getAttributeValue("_CoordinateAxisType", "_coordinateaxistype");
        if (value == null) {
            value = this.getAttributeValue("axis");
        }
        return value != null ? value.toString() : null;
    }

    final CharSequence[] getCoordinateVariables() {
        return CharSequences.split(this.getAttributeAsString("coordinates"), ' ');
    }

    @Override
    protected Grid findGrid(GridAdjustment adjustment) throws IOException, DataStoreException {
        if (this.grid == null) {
            this.decoder.getGridCandidates();
            if (this.grid == null) {
                this.grid = (GridInfo)super.findGrid(adjustment);
            }
        }
        return this.grid;
    }

    @Override
    public int getNumDimensions() {
        return this.dimensions.length;
    }

    @Override
    public List<Dimension> getGridDimensions() {
        return UnmodifiableArrayList.wrap(this.dimensions);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributeNames);
    }

    @Override
    public Class<?> getAttributeType(String attributeName) {
        return Classes.getClass(this.getAttributeValue(attributeName));
    }

    private Object getAttributeValue(String attributeName, String lowerCase) {
        Object value = this.getAttributeValue(attributeName);
        if (value == null) {
            value = this.attributes.get(lowerCase);
        }
        return value;
    }

    @Override
    protected Object getAttributeValue(String attributeName) {
        return this.attributes.get(attributeName);
    }

    final void addAttributesTo(TreeTable.Node branch) {
        VariableInfo.addAttributesTo(branch, this.attributeNames, this.attributes);
    }

    static void addAttributesTo(TreeTable.Node branch, Set<String> attributeNames, Map<String, Object> attributes) {
        for (String name : attributeNames) {
            TreeTable.Node node = branch.newChild();
            node.setValue(TableColumn.NAME, name);
            Object[] value = attributes.get(name);
            if (value == null) continue;
            if (value instanceof Vector) {
                value = ((Vector)value).toArray();
            }
            node.setValue(TableColumn.VALUE, value);
        }
    }

    @Override
    protected Object readFully() throws IOException, DataStoreException {
        return this.readArray(null, null);
    }

    @Override
    public Vector read(GridExtent area, int[] subsampling) throws IOException, DataStoreException {
        return Vector.create(this.readArray(area, subsampling), this.dataType.isUnsigned);
    }

    @Override
    public List<?> readAnyType(GridExtent area, int[] subsampling) throws IOException, DataStoreException {
        Object array = this.readArray(area, subsampling);
        if (this.dataType == DataType.CHAR && this.dimensions.length >= 2) {
            return this.createStringList(array, area);
        }
        return Vector.create(array, this.dataType.isUnsigned);
    }

    private Object readArray(GridExtent area, int[] subsampling) throws IOException, DataStoreException {
        float[] copy;
        if (this.reader == null) {
            throw new DataStoreContentException(this.unknownType());
        }
        int dimension = this.dimensions.length;
        long[] lower = new long[dimension];
        long[] upper = new long[dimension];
        long[] size = area != null ? new long[dimension] : upper;
        for (int i = 0; i < dimension; ++i) {
            size[i] = this.dimensions[dimension - 1 - i].length();
            if (area == null) continue;
            lower[i] = area.getLow(i);
            upper[i] = Math.incrementExact(area.getHigh(i));
        }
        if (subsampling == null) {
            subsampling = new int[dimension];
            Arrays.fill(subsampling, 1);
        }
        Region region = new Region(size, lower, upper, subsampling);
        if (this.isUnlimited()) {
            if (this.offsetToNextRecord < 0L) {
                throw this.canNotComputePosition(null);
            }
            region.setAdditionalByteOffset(this.dimensions.length - 1, this.offsetToNextRecord);
        }
        Object array = this.reader.read(region);
        this.replaceNaN(array);
        if (area == null && array instanceof double[] && (copy = ArraysExt.copyAsFloatsIfLossless((double[])array)) != null) {
            array = copy;
        }
        return array;
    }

    @Override
    protected String[] createStringArray(Object array, int count, int length) {
        byte[] chars = (byte[])array;
        Charset encoding = ((ChannelDecoder)this.decoder).getEncoding();
        String[] strings = new String[count];
        int lower = 0;
        String previous = "";
        if (StoreUtilities.basedOnASCII(encoding)) {
            int plo = 0;
            int phi = 0;
            for (int i = 0; i < count; ++i) {
                int upper;
                String element = "";
                int j = upper = lower + length;
                while (--j >= lower) {
                    if (Byte.toUnsignedInt(chars[j]) <= 32) continue;
                    while (Byte.toUnsignedInt(chars[lower]) <= 32) {
                        ++lower;
                    }
                    if (Arrays.equals(chars, lower, ++j, chars, plo, phi)) {
                        element = previous;
                        break;
                    }
                    previous = element = new String(chars, lower, j - lower, encoding);
                    plo = lower;
                    phi = j;
                    break;
                }
                strings[i] = element;
                lower = upper;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                String element = new String(chars, lower, length, encoding).trim();
                if (!previous.equals(element)) {
                    previous = element;
                }
                strings[i] = previous;
                lower += length;
            }
        }
        return strings;
    }

    @Override
    protected double coordinateForAxis(int j, int i) throws IOException, DataStoreException {
        assert (j >= 0 && j < this.dimensions[0].length) : j;
        assert (i >= 0 && i < this.dimensions[1].length) : i;
        long n = this.dimensions[1].length();
        return this.read().doubleValue(Math.toIntExact((long)i + n * (long)j));
    }

    private String unknownType() {
        return this.resources().getString((short)5, this.getFilename(), this.name, (Object)this.dataType);
    }

    @Override
    public int compareTo(VariableInfo other) {
        int c = Long.compare(this.reader.getOrigin(), other.reader.getOrigin());
        if (c == 0) {
            c = this.name.compareTo(other.name);
        }
        return c;
    }
}

