/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.referencing;

import jakarta.xml.bind.annotation.XmlElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.xml.bind.gco.PropertyType;
import org.apache.sis.xml.bind.referencing.CC_GeneralOperationParameter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class CC_OperationParameterGroup
extends PropertyType<CC_OperationParameterGroup, ParameterDescriptorGroup> {
    public CC_OperationParameterGroup() {
    }

    @Override
    protected Class<ParameterDescriptorGroup> getBoundType() {
        return ParameterDescriptorGroup.class;
    }

    private CC_OperationParameterGroup(ParameterDescriptorGroup parameter) {
        super(parameter);
    }

    @Override
    protected CC_OperationParameterGroup wrap(ParameterDescriptorGroup parameter) {
        return new CC_OperationParameterGroup(parameter);
    }

    @XmlElement(name="OperationParameterGroup")
    public DefaultParameterDescriptorGroup getElement() {
        return DefaultParameterDescriptorGroup.castOrCopy((ParameterDescriptorGroup)this.metadata);
    }

    public void setElement(DefaultParameterDescriptorGroup parameter) {
        this.metadata = parameter;
    }

    public static GeneralParameterDescriptor[] merge(List<GeneralParameterDescriptor> descriptors, GeneralParameterDescriptor[] fromValues, Map<GeneralParameterDescriptor, GeneralParameterDescriptor> replacements) {
        if (descriptors.isEmpty()) {
            return fromValues;
        }
        LinkedHashMap<String, GeneralParameterDescriptor> union = new LinkedHashMap<String, GeneralParameterDescriptor>(Containers.hashMapCapacity(descriptors.size()));
        for (GeneralParameterDescriptor p : descriptors) {
            String name = p.getName().getCode();
            if (union.put(name, p) == null) continue;
            throw new CorruptedObjectException(name);
        }
        for (GeneralParameterDescriptor valueDescriptor : fromValues) {
            GeneralParameterDescriptor complete;
            String name = valueDescriptor.getName().getCode();
            GeneralParameterDescriptor previous = union.put(name, complete = valueDescriptor);
            if (previous == null) continue;
            if (previous instanceof ParameterDescriptor) {
                CC_OperationParameterGroup.verifyEquivalence(name, complete instanceof ParameterDescriptor);
                Class valueClass = ((ParameterDescriptor)previous).getValueClass();
                if (valueClass != null) {
                    Class r = ((ParameterDescriptor)complete).getValueClass();
                    if (r != null) {
                        CC_OperationParameterGroup.verifyEquivalence(name, valueClass == r);
                    }
                    complete = previous;
                    previous = union.put(name, complete);
                }
            } else if (previous instanceof ParameterDescriptorGroup) {
                CC_OperationParameterGroup.verifyEquivalence(name, complete instanceof ParameterDescriptorGroup);
            }
            GeneralParameterDescriptor replacement = CC_GeneralOperationParameter.merge(previous, complete);
            if (replacement == valueDescriptor) continue;
            union.put(name, replacement);
            if (replacements.put(valueDescriptor, replacement) == null) continue;
            throw new CorruptedObjectException(name);
        }
        return (GeneralParameterDescriptor[])union.values().toArray(GeneralParameterDescriptor[]::new);
    }

    private static void verifyEquivalence(String name, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException(Resources.format((short)35, name));
        }
    }
}

