/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.service;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.openejb.cdi.CompositeBeans;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.event.BeforeAppInfoBuilderEvent;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.observer.Observes;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.JarArchive;

public class ScanJarService {
    private File path;
    private boolean directory;
    private volatile CompositeBeans beans;

    public void addScanningResult(@Observes BeforeAppInfoBuilderEvent event) throws Exception {
        for (EjbModule ejbModule : event.getAppModule().getEjbModules()) {
            if (!ejbModule.getModuleId().startsWith("ear-scoped-cdi-beans")) continue;
            this.doMerge(ejbModule);
            return;
        }
        for (WebModule webModule : event.getAppModule().getWebModules()) {
            for (EjbModule ejbModule : event.getAppModule().getEjbModules()) {
                if (!ejbModule.getModuleId().equals(webModule.getModuleId())) continue;
                this.doMerge(ejbModule);
                return;
            }
        }
    }

    private void doMerge(EjbModule ejbModule) throws Exception {
        Beans beans = ejbModule.getBeans();
        if (CompositeBeans.class.isInstance(beans)) {
            CompositeBeans cb = (CompositeBeans)((Object)CompositeBeans.class.cast(beans));
            this.ensureInit();
            this.merge(cb);
        } else if (beans != null) {
            this.ensureInit();
            for (URL key : this.beans.getManagedClasses().keySet()) {
                beans.getManagedClasses().putAll(this.beans.getManagedClasses());
                this.addIfNotNull(beans.getInterceptors(), this.beans.getInterceptorsByUrl().get(key));
                this.addIfNotNull(beans.getAlternativeClasses(), this.beans.getAlternativesByUrl().get(key));
                this.addIfNotNull(beans.getAlternativeStereotypes(), this.beans.getAlternativeStereotypesByUrl().get(key));
                this.addIfNotNull(beans.getDecorators(), this.beans.getDecoratorsByUrl().get(key));
            }
        }
    }

    private void addIfNotNull(List<String> out, Collection<String> in) {
        if (in != null) {
            out.addAll(in);
        }
    }

    private void merge(CompositeBeans cb) {
        cb.getManagedClasses().putAll(this.beans.getManagedClasses());
        cb.getNotManagedClasses().putAll(this.beans.getNotManagedClasses());
        cb.getAlternativesByUrl().putAll(this.beans.getAlternativesByUrl());
        cb.getAlternativeStereotypesByUrl().putAll(this.beans.getAlternativeStereotypesByUrl());
        cb.getInterceptorsByUrl().putAll(this.beans.getInterceptorsByUrl());
        cb.getDecoratorsByUrl().putAll(this.beans.getDecoratorsByUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInit() throws Exception {
        if (this.beans != null) {
            return;
        }
        ScanJarService scanJarService = this;
        synchronized (scanJarService) {
            if (this.beans != null) {
                return;
            }
            ClassLoader loader = ParentClassLoaderFinder.Helper.get();
            CompositeBeans mergedModel = new CompositeBeans();
            for (File file : this.findFiles()) {
                Beans beansModel;
                FinderFactory.OpenEJBAnnotationFinder finder;
                URL url = file.toURI().toURL();
                if (file.isDirectory()) {
                    finder = new FinderFactory.OpenEJBAnnotationFinder((Archive)new FileArchive(loader, file));
                    mergedModel.getManagedClasses().put(url, finder.getAnnotatedClassNames());
                    File beansXml = new File(file, "META-INF/beans.xml");
                    if (!beansXml.exists()) continue;
                    FileInputStream inputStream = new FileInputStream(beansXml);
                    try {
                        beansModel = ReadDescriptors.readBeans(inputStream);
                        mergedModel.mergeClasses(url, beansModel);
                        continue;
                    }
                    finally {
                        inputStream.close();
                        continue;
                    }
                }
                finder = new FinderFactory.OpenEJBAnnotationFinder((Archive)new JarArchive(loader, url));
                mergedModel.getManagedClasses().put(url, finder.getAnnotatedClassNames());
                try (URLClassLoader cl = new URLClassLoader(new URL[]{url});){
                    InputStream is = cl.getResourceAsStream("META-INF/beans.xml");
                    try {
                        if (is == null) continue;
                        beansModel = ReadDescriptors.readBeans(is);
                        mergedModel.mergeClasses(url, beansModel);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            this.beans = mergedModel;
        }
    }

    private Iterable<? extends File> findFiles() {
        LinkedList<File> files = new LinkedList<File>();
        if (!this.directory) {
            files.add(this.path);
        } else {
            File[] children = this.path.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    return name.endsWith(".jar") || name.endsWith(".zip") || pathname.isDirectory();
                }
            });
            if (children != null) {
                Collections.addAll(files, children);
            }
        }
        return files;
    }

    public void setPath(String path) throws Exception {
        this.path = new File(path).getCanonicalFile();
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }
}

